/* rygel-tracker-selection-query.c generated by valac 0.11.3, the Vala compiler
 * generated from rygel-tracker-selection-query.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE (rygel_tracker_resources_iface_get_type ())
#define RYGEL_TRACKER_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIface))
#define RYGEL_TRACKER_IS_RESOURCES_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE))
#define RYGEL_TRACKER_RESOURCES_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TRACKER_TYPE_RESOURCES_IFACE, RygelTrackerResourcesIfaceIface))

typedef struct _RygelTrackerResourcesIface RygelTrackerResourcesIface;
typedef struct _RygelTrackerResourcesIfaceIface RygelTrackerResourcesIfaceIface;

#define RYGEL_TRACKER_TYPE_RESOURCES_IFACE_PROXY (rygel_tracker_resources_iface_proxy_get_type ())

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerSelectionQueryExecuteData RygelTrackerSelectionQueryExecuteData;

struct _RygelTrackerResourcesIfaceIface {
	GTypeInterface parent_iface;
	void (*sparql_query) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*sparql_query_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
	void (*sparql_update) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*sparql_update_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, GError** error);
	void (*sparql_update_blank) (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable** (*sparql_update_blank_finish) (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
};

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	gchar** result;
	gint result_length1;
	gint result_length2;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSelectionQueryExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelTrackerSelectionQuery* self;
	RygelTrackerResourcesIface* resources;
	gchar* _tmp0_;
	gchar* str;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gchar** _tmp5_;
	gchar** _tmp4_;
	gchar** _tmp6_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_selection_query_parent_class = NULL;

gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_resources_iface_proxy_get_type (void) G_GNUC_CONST;
guint rygel_tracker_resources_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_tracker_resources_iface_get_type (void) G_GNUC_CONST;
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TRACKER_SELECTION_QUERY_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE "?item"
#define RYGEL_TRACKER_SELECTION_QUERY_SHARED_FILTER "(!BOUND(nmm:uPnPShared(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")) ||" " nmm:uPnPShared(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") = true)"
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
RygelTrackerQuery* rygel_tracker_query_construct (GType object_type, RygelTrackerQueryTriplets* triplets);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query);
static GeeArrayList* rygel_tracker_selection_query_copy_str_list (GeeList* str_list);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type, RygelTrackerQueryTriplets* triplets);
static void rygel_tracker_selection_query_real_execute_data_free (gpointer _data);
static void rygel_tracker_selection_query_real_execute (RygelTrackerQuery* base, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_selection_query_real_execute_co (RygelTrackerSelectionQueryExecuteData* data);
gchar* rygel_tracker_query_to_string (RygelTrackerQuery* self);
void rygel_tracker_resources_iface_sparql_query (RygelTrackerResourcesIface* self, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** rygel_tracker_resources_iface_sparql_query_finish (RygelTrackerResourcesIface* self, GAsyncResult* _res_, int* result_length1, int* result_length2, GError** error);
static void rygel_tracker_selection_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* rygel_tracker_selection_query_real_to_string (RygelTrackerQuery* base);
static void rygel_tracker_selection_query_finalize (RygelTrackerQuery* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count) {
	RygelTrackerSelectionQuery* self = NULL;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (variables != NULL, NULL);
	g_return_val_if_fail (triplets != NULL, NULL);
	self = (RygelTrackerSelectionQuery*) rygel_tracker_query_construct (object_type, triplets);
	if (filters != NULL) {
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		_tmp0_ = _g_object_ref0 (filters);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (self->filters);
		self->filters = _tmp1_;
	} else {
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_;
		_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (self->filters);
		self->filters = _tmp3_;
	}
	_tmp4_ = _g_object_ref0 (variables);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (self->variables);
	self->variables = _tmp5_;
	_tmp6_ = g_strdup (order_by);
	_tmp7_ = _tmp6_;
	_g_free0 (self->order_by);
	self->order_by = _tmp7_;
	self->offset = offset;
	self->max_count = max_count;
	return self;
}


RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count) {
	return rygel_tracker_selection_query_construct (RYGEL_TRACKER_TYPE_SELECTION_QUERY, variables, triplets, filters, order_by, offset, max_count);
}


RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query) {
	RygelTrackerSelectionQuery* self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* _tmp1_;
	RygelTrackerQueryTriplets* _tmp2_ = NULL;
	RygelTrackerQueryTriplets* _tmp3_;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = rygel_tracker_selection_query_copy_str_list ((GeeList*) query->variables);
	_tmp1_ = _tmp0_;
	_tmp2_ = rygel_tracker_query_triplets_new_clone (((RygelTrackerQuery*) query)->triplets);
	_tmp3_ = _tmp2_;
	_tmp4_ = rygel_tracker_selection_query_copy_str_list ((GeeList*) query->filters);
	_tmp5_ = _tmp4_;
	self = (RygelTrackerSelectionQuery*) rygel_tracker_selection_query_construct (object_type, _tmp1_, _tmp3_, _tmp5_, query->order_by, query->offset, query->max_count);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	return self;
}


RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query) {
	return rygel_tracker_selection_query_construct_clone (RYGEL_TRACKER_TYPE_SELECTION_QUERY, query);
}


static void rygel_tracker_selection_query_real_execute_data_free (gpointer _data) {
	RygelTrackerSelectionQueryExecuteData* data;
	data = _data;
	_g_object_unref0 (data->resources);
	_rygel_tracker_query_unref0 (data->self);
	g_slice_free (RygelTrackerSelectionQueryExecuteData, data);
}


static gpointer _rygel_tracker_query_ref0 (gpointer self) {
	return self ? rygel_tracker_query_ref (self) : NULL;
}


static void rygel_tracker_selection_query_real_execute (RygelTrackerQuery* base, RygelTrackerResourcesIface* resources, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSelectionQuery * self;
	RygelTrackerSelectionQueryExecuteData* _data_;
	self = (RygelTrackerSelectionQuery*) base;
	_data_ = g_slice_new0 (RygelTrackerSelectionQueryExecuteData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, rygel_tracker_selection_query_real_execute);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_tracker_selection_query_real_execute_data_free);
	_data_->self = _rygel_tracker_query_ref0 (self);
	_data_->resources = _g_object_ref0 (resources);
	rygel_tracker_selection_query_real_execute_co (_data_);
}


static void rygel_tracker_selection_query_real_execute_finish (RygelTrackerQuery* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerSelectionQueryExecuteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_tracker_selection_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSelectionQueryExecuteData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	rygel_tracker_selection_query_real_execute_co (data);
}


static gboolean rygel_tracker_selection_query_real_execute_co (RygelTrackerSelectionQueryExecuteData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = rygel_tracker_query_to_string ((RygelTrackerQuery*) data->self);
	data->str = data->_tmp0_;
	g_debug ("rygel-tracker-selection-query.vala:78: Executing SPARQL query: %s", data->str);
	data->_state_ = 1;
	rygel_tracker_resources_iface_sparql_query (data->resources, data->str, rygel_tracker_selection_query_execute_ready, data);
	return FALSE;
	_state_1:
	data->_tmp3_ = NULL;
	data->_tmp3_ = rygel_tracker_resources_iface_sparql_query_finish (data->resources, data->_res_, &data->_tmp1_, &data->_tmp2_, &data->_inner_error_);
	data->_tmp5_ = data->_tmp3_;
	data->_tmp4__length1 = data->_tmp1_;
	data->_tmp4__length2 = data->_tmp2_;
	data->_tmp4_ = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_free0 (data->str);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			_g_free0 (data->str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->_tmp6_ = data->_tmp4_;
	data->self->result = (_vala_array_free (data->self->result, data->self->result_length1 * data->self->result_length2, (GDestroyNotify) g_free), NULL);
	data->self->result_length1 = data->_tmp4__length1;
	data->self->result_length2 = data->_tmp4__length2;
	data->self->result = data->_tmp6_;
	_g_free0 (data->str);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar* rygel_tracker_selection_query_real_to_string (RygelTrackerQuery* base) {
	RygelTrackerSelectionQuery * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* query;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GeeArrayList* _tmp10_ = NULL;
	GeeArrayList* filters;
	gint _tmp11_;
	gchar* _tmp21_;
	self = (RygelTrackerSelectionQuery*) base;
	_tmp0_ = g_strdup ("SELECT ");
	query = _tmp0_;
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _variable_list;
		gint _tmp2_;
		gint _variable_size;
		gint _variable_index;
		_tmp1_ = _g_object_ref0 (self->variables);
		_variable_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _variable_list);
		_variable_size = _tmp2_;
		_variable_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			gchar* variable;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_variable_index = _variable_index + 1;
			if (!(_variable_index < _variable_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _variable_list, _variable_index);
			variable = (gchar*) _tmp3_;
			_tmp4_ = g_strconcat (" ", variable, NULL);
			_tmp5_ = g_strconcat (query, _tmp4_, NULL);
			_g_free0 (query);
			query = _tmp5_;
			_g_free0 (_tmp4_);
			_g_free0 (variable);
		}
		_g_object_unref0 (_variable_list);
	}
	_tmp6_ = RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_selection_query_parent_class)->to_string (RYGEL_TRACKER_QUERY (self));
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (" WHERE { ", _tmp7_, NULL);
	_tmp9_ = g_strconcat (query, _tmp8_, NULL);
	_g_free0 (query);
	query = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp7_);
	_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	filters = _tmp10_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) filters, (GeeCollection*) self->filters);
	gee_abstract_collection_add ((GeeAbstractCollection*) filters, RYGEL_TRACKER_SELECTION_QUERY_SHARED_FILTER);
	_tmp11_ = gee_collection_get_size ((GeeCollection*) filters);
	if (_tmp11_ > 0) {
		gchar* _tmp12_;
		gchar* _tmp20_;
		_tmp12_ = g_strconcat (query, " FILTER (", NULL);
		_g_free0 (query);
		query = _tmp12_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp13_;
				_tmp13_ = TRUE;
				while (TRUE) {
					gint _tmp14_;
					gpointer _tmp15_ = NULL;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gint _tmp18_;
					if (!_tmp13_) {
						i++;
					}
					_tmp13_ = FALSE;
					_tmp14_ = gee_collection_get_size ((GeeCollection*) filters);
					if (!(i < _tmp14_)) {
						break;
					}
					_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) filters, i);
					_tmp16_ = (gchar*) _tmp15_;
					_tmp17_ = g_strconcat (query, _tmp16_, NULL);
					_g_free0 (query);
					query = _tmp17_;
					_g_free0 (_tmp16_);
					_tmp18_ = gee_collection_get_size ((GeeCollection*) filters);
					if (i < (_tmp18_ - 1)) {
						gchar* _tmp19_;
						_tmp19_ = g_strconcat (query, " && ", NULL);
						_g_free0 (query);
						query = _tmp19_;
					}
				}
			}
		}
		_tmp20_ = g_strconcat (query, ")", NULL);
		_g_free0 (query);
		query = _tmp20_;
	}
	_tmp21_ = g_strconcat (query, " }", NULL);
	_g_free0 (query);
	query = _tmp21_;
	if (self->order_by != NULL) {
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = g_strconcat (" ORDER BY ", self->order_by, NULL);
		_tmp23_ = g_strconcat (query, _tmp22_, NULL);
		_g_free0 (query);
		query = _tmp23_;
		_g_free0 (_tmp22_);
	}
	if (self->offset > 0) {
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp24_ = g_strdup_printf ("%i", self->offset);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (" OFFSET ", _tmp25_, NULL);
		_tmp27_ = g_strconcat (query, _tmp26_, NULL);
		_g_free0 (query);
		query = _tmp27_;
		_g_free0 (_tmp26_);
		_g_free0 (_tmp25_);
	}
	if (self->max_count > 0) {
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp28_ = g_strdup_printf ("%i", self->max_count);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (" LIMIT ", _tmp29_, NULL);
		_tmp31_ = g_strconcat (query, _tmp30_, NULL);
		_g_free0 (query);
		query = _tmp31_;
		_g_free0 (_tmp30_);
		_g_free0 (_tmp29_);
	}
	result = query;
	_g_object_unref0 (filters);
	return result;
}


static GeeArrayList* rygel_tracker_selection_query_copy_str_list (GeeList* str_list) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* copy;
	g_return_val_if_fail (str_list != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	copy = _tmp0_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) copy, (GeeCollection*) str_list);
	result = copy;
	return result;
}


static void rygel_tracker_selection_query_class_init (RygelTrackerSelectionQueryClass * klass) {
	rygel_tracker_selection_query_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_QUERY_CLASS (klass)->finalize = rygel_tracker_selection_query_finalize;
	RYGEL_TRACKER_QUERY_CLASS (klass)->execute = rygel_tracker_selection_query_real_execute;
	RYGEL_TRACKER_QUERY_CLASS (klass)->execute_finish = rygel_tracker_selection_query_real_execute_finish;
	RYGEL_TRACKER_QUERY_CLASS (klass)->to_string = rygel_tracker_selection_query_real_to_string;
}


static void rygel_tracker_selection_query_instance_init (RygelTrackerSelectionQuery * self) {
}


static void rygel_tracker_selection_query_finalize (RygelTrackerQuery* obj) {
	RygelTrackerSelectionQuery * self;
	self = RYGEL_TRACKER_SELECTION_QUERY (obj);
	_g_object_unref0 (self->variables);
	_g_object_unref0 (self->filters);
	_g_free0 (self->order_by);
	self->result = (_vala_array_free (self->result, self->result_length1 * self->result_length2, (GDestroyNotify) g_free), NULL);
	RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_selection_query_parent_class)->finalize (obj);
}


/**
 * Represents Tracker SPARQL Selection query
 */
GType rygel_tracker_selection_query_get_type (void) {
	static volatile gsize rygel_tracker_selection_query_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_selection_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSelectionQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_selection_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSelectionQuery), 0, (GInstanceInitFunc) rygel_tracker_selection_query_instance_init, NULL };
		GType rygel_tracker_selection_query_type_id;
		rygel_tracker_selection_query_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_QUERY, "RygelTrackerSelectionQuery", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_selection_query_type_id__volatile, rygel_tracker_selection_query_type_id);
	}
	return rygel_tracker_selection_query_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



