/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1new (JNIEnv *env, jclass cls) 
{
    {
        return (jint)gtk_tree_path_new ();
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_new_from_string
 * Signature: ([B)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1new_1from_1string (JNIEnv 
    *env, jclass cls, jstring path) 
{
    const gchar* path_g = (*env)->GetStringUTFChars( env, path, NULL );
	jint retval =  (jint)gtk_tree_path_new_from_string (path_g);
	(*env)->ReleaseStringUTFChars(env, path, path_g);
	return retval;
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_to_string
 * Signature: (I)[B
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1to_1string (JNIEnv 
    *env, jclass cls, jint path) 
{
    GtkTreePath *path_g = (GtkTreePath *)path;
    {
        return (*env)->NewStringUTF( env, gtk_tree_path_to_string (path_g) );
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_new_first
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1new_1first (JNIEnv *env, 
    jclass cls) 
{
    {
        return (jint)gtk_tree_path_new_first ();
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_append_index
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1append_1index (JNIEnv *env, 
    jclass cls, jint path, jint index) 
{
    GtkTreePath *path_g = (GtkTreePath *)path;
    gint32 index_g = (gint32) index;
    {
        gtk_tree_path_append_index (path_g, index_g);
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_prepend_index
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1prepend_1index (JNIEnv *env, 
    jclass cls, jint path, jint index) 
{
    GtkTreePath *path_g = (GtkTreePath *)path;
    gint32 index_g = (gint32) index;
    {
        gtk_tree_path_prepend_index (path_g, index_g);
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_get_depth
 * Signature: (I)I
 */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1get_1depth (JNIEnv *env, 
        jclass cls, jint path) 
    {
        GtkTreePath *path_g = (GtkTreePath *)path;
        {
            jint result_j = (jint) (gtk_tree_path_get_depth (path_g));
            return result_j;
        }
    }

/*
 * Class:     org_gnu_gtk_TreePath
 * Method:    gtk_tree_path_get_indices
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1get_1indices
  (JNIEnv *env, jclass cls, jint path)
{
	gint* list = gtk_tree_path_get_indices((GtkTreePath*)path);
	gint len;
	jintArray ar;
	int i = 0;
 	if (NULL == list)
		return NULL;
	len = gtk_tree_path_get_depth((GtkTreePath*)path);
	ar = (*env)->NewIntArray(env, len);
	for (i = 0; i < len; i++) {
		(*env)->SetIntArrayRegion(env, ar, i, 1, (jint*)list[i]);
	}
	return ar;
}
                                                                               
/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_compare
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1compare (JNIEnv *env, jclass 
    cls, jint a, jint b) 
{
    GtkTreePath *a_g = (GtkTreePath *)a;
    GtkTreePath *b_g = (GtkTreePath *)b;
    {
        jint result_j = (jint) (gtk_tree_path_compare (a_g, b_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_next
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1next (JNIEnv *env, jclass 
    cls, jint path) 
{
    GtkTreePath *path_g = (GtkTreePath *)path;
    {
        gtk_tree_path_next (path_g);
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_prev
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1prev (JNIEnv *env, jclass 
    cls, jint path) 
{
    GtkTreePath *path_g = (GtkTreePath *)path;
    {
        jboolean result_j = (jboolean) (gtk_tree_path_prev (path_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_up
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1up (JNIEnv *env, jclass 
    cls, jint path) 
{
    GtkTreePath *path_g = (GtkTreePath *)path;
    {
        jboolean result_j = (jboolean) (gtk_tree_path_up (path_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_down
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1down (JNIEnv *env, jclass 
    cls, jint path) 
{
    GtkTreePath *path_g = (GtkTreePath *)path;
    {
        gtk_tree_path_down (path_g);
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_is_ancestor
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1is_1ancestor (JNIEnv 
    *env, jclass cls, jint path, jint descendant) 
{
    GtkTreePath *path_g = (GtkTreePath *)path;
    GtkTreePath *descendant_g = (GtkTreePath *)descendant;
    {
        jboolean result_j = (jboolean) (gtk_tree_path_is_ancestor (path_g, descendant_g));
        return result_j;
    }
}

/*
 * Class:     org.gnu.gtk.TreePath
 * Method:    gtk_tree_path_is_descendant
 * Signature: (II)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TreePath_gtk_1tree_1path_1is_1descendant (JNIEnv 
    *env, jclass cls, jint path, jint ancestor) 
{
    GtkTreePath *path_g = (GtkTreePath *)path;
    GtkTreePath *ancestor_g = (GtkTreePath *)ancestor;
    {
        jboolean result_j = (jboolean) (gtk_tree_path_is_descendant (path_g, ancestor_g));
        return result_j;
    }
}


#ifdef __cplusplus
}

#endif
