/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-02 09:42:24 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
	JNIEXPORT void JNICALL 
    Java_org_gnu_gtk_TextTag_setBooleanProperty (
        JNIEnv *env, jclass cls, jint renderer, jstring property, jboolean setting) 
    {
        GtkTextTag *renderer_g = (GtkTextTag *)renderer;
		const char* property_utf =  (*env)->GetStringUTFChars(env, property, NULL);
		g_object_set( renderer_g,  property_utf, setting, NULL);
		(*env)->ReleaseStringUTFChars( env, property, property_utf);
	}
	JNIEXPORT void JNICALL 
    Java_org_gnu_gtk_TextTag_setStringProperty (
        JNIEnv *env, jclass cls, jint renderer, jstring property, jstring setting) 
    {
        GtkTextTag *renderer_g = (GtkTextTag *)renderer;
		const char* setting_utf = (*env)->GetStringUTFChars( env, setting, NULL );
		const char* property_utf =  (*env)->GetStringUTFChars(env, property, NULL);
		g_object_set( renderer_g,  property_utf, setting_utf, NULL);
		(*env)->ReleaseStringUTFChars( env, property, property_utf);
	}
	JNIEXPORT void JNICALL 
    Java_org_gnu_gtk_TextTag_setIntProperty (
        JNIEnv *env, jclass cls, jint renderer, jstring property, jint setting) 
    {
        GtkTextTag *renderer_g = (GtkTextTag *)renderer;
		const char* property_utf =  (*env)->GetStringUTFChars(env, property, NULL);
		g_object_set( renderer_g,  property_utf, setting, NULL);
		(*env)->ReleaseStringUTFChars( env, property, property_utf);
	}
	JNIEXPORT void JNICALL 
    Java_org_gnu_gtk_TextTag_setDoubleProperty (
        JNIEnv *env, jclass cls, jint renderer, jstring property, jdouble setting) 
    {
        GtkTextTag *renderer_g = (GtkTextTag *)renderer;
		const char* property_utf =  (*env)->GetStringUTFChars(env, property, NULL);
		g_object_set( renderer_g,  property_utf, setting, NULL);
		(*env)->ReleaseStringUTFChars( env, property, property_utf);
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    gchar * GtkTextTag_get_name (GtkTextTag * cptr) 
    {
        return cptr->name;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getName
     * Signature: (I)Ljava/lang/String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_TextTag_getName (JNIEnv *env, jclass cls, jint cptr) 
    {
	gchar *result_g = GtkTextTag_get_name ((GtkTextTag*)cptr);
	return result_g ? (*env)->NewStringUTF(env, result_g) : NULL;
    }

    gboolean GtkTextTag_get_bg_color_set (GtkTextTag * cptr) 
    {
        return cptr->bg_color_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getBgColorSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getBgColorSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_bg_color_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_bg_stipple_set (GtkTextTag * cptr) 
    {
        return cptr->bg_stipple_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getBgStippleSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getBgStippleSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_bg_stipple_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_fg_color_set (GtkTextTag * cptr) 
    {
        return cptr->fg_color_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getFgColorSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getFgColorSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_fg_color_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_scale_set (GtkTextTag * cptr) 
    {
        return cptr->scale_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getScaleSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getScaleSet (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_scale_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_fg_stipple_set (GtkTextTag * cptr) 
    {
        return cptr->fg_stipple_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getFgStippleSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getFgStippleSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_fg_stipple_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_justification_set (GtkTextTag * cptr) 
    {
        return cptr->justification_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getJustificationSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getJustificationSet (JNIEnv *env, jclass 
        cls, jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_justification_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_left_margin_set (GtkTextTag * cptr) 
    {
        return cptr->left_margin_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getLeftMarginSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getLeftMarginSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_left_margin_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_indent_set (GtkTextTag * cptr) 
    {
        return cptr->indent_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getIndentSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getIndentSet (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_indent_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_rise_set (GtkTextTag * cptr) 
    {
        return cptr->rise_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getRiseSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getRiseSet (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_rise_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_strikethrough_set (GtkTextTag * cptr) 
    {
        return cptr->strikethrough_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getStrikethroughSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getStrikethroughSet (JNIEnv *env, jclass 
        cls, jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_strikethrough_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_right_margin_set (GtkTextTag * cptr) 
    {
        return cptr->right_margin_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getRightMarginSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getRightMarginSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_right_margin_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_pixels_above_lines_set (GtkTextTag * cptr) 
    {
        return cptr->pixels_above_lines_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getPixelsAboveLinesSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getPixelsAboveLinesSet (JNIEnv *env, jclass 
        cls, jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_pixels_above_lines_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_pixels_below_lines_set (GtkTextTag * cptr) 
    {
        return cptr->pixels_below_lines_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getPixelsBelowLinesSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getPixelsBelowLinesSet (JNIEnv *env, jclass 
        cls, jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_pixels_below_lines_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_pixels_inside_wrap_set (GtkTextTag * cptr) 
    {
        return cptr->pixels_inside_wrap_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getPixelsInsideWrapSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getPixelsInsideWrapSet (JNIEnv *env, jclass 
        cls, jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_pixels_inside_wrap_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_tabs_set (GtkTextTag * cptr) 
    {
        return cptr->tabs_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getTabsSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getTabsSet (JNIEnv *env, jclass cls, jint 
        cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_tabs_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_underline_set (GtkTextTag * cptr) 
    {
        return cptr->underline_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getUnderlineSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getUnderlineSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_underline_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_wrap_mode_set (GtkTextTag * cptr) 
    {
        return cptr->wrap_mode_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getWrapModeSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getWrapModeSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_wrap_mode_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_bg_full_height_set (GtkTextTag * cptr) 
    {
        return cptr->bg_full_height_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getBgFullHeightSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getBgFullHeightSet (JNIEnv *env, jclass 
        cls, jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_bg_full_height_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_invisible_set (GtkTextTag * cptr) 
    {
        return cptr->invisible_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getInvisibleSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getInvisibleSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_invisible_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_editable_set (GtkTextTag * cptr) 
    {
        return cptr->editable_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getEditableSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getEditableSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_editable_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_language_set (GtkTextTag * cptr) 
    {
        return cptr->language_set;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getLanguageSet
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getLanguageSet (JNIEnv *env, jclass cls, 
        jint cptr) 
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_language_set (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_pad1 (GtkTextTag * cptr) 
    {
        return cptr->pad1;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getPad1
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getPad1 (JNIEnv *env, jclass cls, jint cptr)
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_pad1 (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_pad2 (GtkTextTag * cptr) 
    {
        return cptr->pad2;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getPad2
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getPad2 (JNIEnv *env, jclass cls, jint cptr)
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_pad2 (cptr_g));
            return result_j;
        }
    }

    gboolean GtkTextTag_get_pad3 (GtkTextTag * cptr) 
    {
        return cptr->pad3;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    getPad3
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_getPad3 (JNIEnv *env, jclass cls, jint cptr)
    {
        GtkTextTag *cptr_g = (GtkTextTag *)cptr;
        {
            jboolean result_j = (jboolean) (GtkTextTag_get_pad3 (cptr_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    gtk_text_tag_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextTag_gtk_1text_1tag_1get_1type (JNIEnv *env, jclass 
        cls) 
    {
        {
            return (jint)gtk_text_tag_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    gtk_text_tag_new
     * Signature: ([B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextTag_gtk_1text_1tag_1new (JNIEnv *env, jclass cls, 
        jstring name) 
    {
        const char *utf = (*env)->GetStringUTFChars(env, name, NULL);
	jint handle = (jint)gtk_text_tag_new (utf);
        (*env)->ReleaseStringUTFChars(env, name, utf);
	return handle;
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    gtk_text_tag_get_priority
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_TextTag_gtk_1text_1tag_1get_1priority (JNIEnv *env, 
        jclass cls, jint tag) 
    {
        GtkTextTag *tag_g = (GtkTextTag *)tag;
        {
            jint result_j = (jint) (gtk_text_tag_get_priority (tag_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    gtk_text_tag_set_priority
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_TextTag_gtk_1text_1tag_1set_1priority (JNIEnv *env, 
        jclass cls, jint tag, jint priority) 
    {
        GtkTextTag *tag_g = (GtkTextTag *)tag;
        gint32 priority_g = (gint32) priority;
        {
            gtk_text_tag_set_priority (tag_g, priority_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.TextTag
     * Method:    gtk_text_tag_event
     * Signature: (IIII)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_TextTag_gtk_1text_1tag_1event (JNIEnv *env, jclass 
        cls, jint tag, jint eventObject, jint event, jint iter) 
    {
        GtkTextTag *tag_g = (GtkTextTag *)tag;
        GObject *eventObject_g = (GObject *)eventObject;
        GdkEvent *event_g = (GdkEvent *)event;
        GtkTextIter *iter_g = (GtkTextIter *)iter;
        {
            jboolean result_j = (jboolean) (gtk_text_tag_event (tag_g, eventObject_g, event_g, 
                    iter_g));
            return result_j;
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
