/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.GObject;

/**
 *	In addition to the normal keyboard and mouse input devices, 
 *	GTK+ also contains support for extended input devices.
 *	In particular, this support is targeted at graphics tablets. Graphics tablets typically 
 *	return sub-pixel positioning information 
 *	and possibly information about the pressure and tilt of the stylus. 
 *	Under X, the support for extended devices is done through the XInput extension.
 *
 *	This class represents a generic device, allowing the programmer to configure
 *	various aspects of each device.
 */
public class Device extends GObject 
{	
	public Device(int handle){
		super(handle);
	}
	
	/**
	*	Returns the name of this device.
	*/
	public String getName(){
		return Device.getName(getHandle());
	}
	
	
	/**
	*	Returns the type of this device.
	*/
	public org.gnu.gdk.InputSource getSource(){
		int value=Device.getSource(getHandle());
		return org.gnu.gdk.InputSource.intern(value);
	}
	
	
	/**
	*	Returns the mode of an input device.
	*/
	public org.gnu.gdk.InputMode getMode(){
		int value=Device.getMode(getHandle());
		return org.gnu.gdk.InputMode.intern(value);
	}
	
	/**
	*	TRUE if the X pointer follows device motion.
	*/
	public boolean hasCursor(){
		return Device.getHasCursor(getHandle());
	}
	
	public static org.gnu.glib.List getDevicesList(){
		org.gnu.glib.List l;
		l=new org.gnu.glib.List(Device.gdk_devices_list());
		return l;
	}
	
	/**
	*	Sets the source type for an input device.
	*/
	public void setSource(org.gnu.gdk.InputSource source){
		Device.gdk_device_set_source(getHandle(),source.getValue());
	}
	
	/**
	*	Sets a the mode of an input device. 
	*	The mode controls if the device is active and whether the device's range is mapped to the entire screen or to a single window.
	*/
	
	public void setMode(org.gnu.gdk.InputMode mode){
		Device.gdk_device_set_mode(getHandle(),mode.getValue());
	}
	
	/**
	*	Specifies the X key event to generate when a macro button of a device is pressed.
	*/
	public void setKeyValue(int btnIndex, int keyVal, org.gnu.gdk.ModifierType modifier){
		Device.gdk_device_set_key(getHandle(), btnIndex, keyVal, modifier.getValue());
	}
	
	/**
	*	Specifies how an axis of a device is used.
	*/
	public void setAxisUse(int axisIndex, AxisUse use){
		Device.gdk_device_set_axis_use(getHandle(), axisIndex, use.getValue());
	}
	
	/**
	*	Returns the device for the core pointer.
	*/
	public static org.gnu.gdk.Device getCorePointer(){
		return new Device(Device.gdk_device_get_core_pointer());
	}
	
	
	
		
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected String getName (int obj);
    native static final protected int getSource (int obj);
    native static final protected int getMode (int obj);
    native static final protected boolean getHasCursor (int obj);
    native static final protected int gdk_device_get_type ();
    native static final protected int gdk_devices_list ();
    native static final protected void gdk_device_set_source (int device, int source);
    native static final protected void gdk_device_set_mode (int device, int mode);
    native static final protected void gdk_device_set_key (int device, int index, int keyval, int 
        modifiers);
    native static final protected void gdk_device_set_axis_use (int device, int index, int use);
    native static final protected boolean gdk_device_get_axis (int device, double [] axes, int use, 
        double [] value);
    native static final protected int gdk_device_get_core_pointer ();
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

