// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/iostream.h>
#include <giomm/private/iostream_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>
#include <giomm/asyncresult.h>
#include "slot_async.h"

namespace Gio
{


#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool IOStream::close()
#else
bool IOStream::close(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_io_stream_close(gobj(), NULL, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}


void
IOStream::close_async(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_io_stream_close_async(gobj(),
                          io_priority,
                          cancellable->gobj(),
                          &SignalProxy_async_callback,
                          slot_copy);
}

void
IOStream::close_async(const SlotAsyncReady& slot, int io_priority)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_io_stream_close_async(gobj(),
                          io_priority,
                          NULL,
                          &SignalProxy_async_callback,
                          slot_copy);
}


} // namespace Gio

namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::IOStream> wrap(GIOStream* object, bool take_copy)
{
  return Glib::RefPtr<Gio::IOStream>( dynamic_cast<Gio::IOStream*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gio
{


/* The *_Class implementation: */

const Glib::Class& IOStream_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &IOStream_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(g_io_stream_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void IOStream_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* IOStream_Class::wrap_new(GObject* object)
{
  return new IOStream((GIOStream*)object);
}


/* The implementation: */

GIOStream* IOStream::gobj_copy()
{
  reference();
  return gobj();
}

IOStream::IOStream(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

IOStream::IOStream(GIOStream* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


IOStream::~IOStream()
{}


IOStream::CppClassType IOStream::iostream_class_; // initialize static member

GType IOStream::get_type()
{
  return iostream_class_.init().get_type();
}


GType IOStream::get_base_type()
{
  return g_io_stream_get_type();
}


Glib::RefPtr<InputStream> IOStream::get_input_stream()
{
  return Glib::wrap(g_io_stream_get_input_stream(gobj()));
}

Glib::RefPtr<OutputStream> IOStream::get_output_stream()
{
  return Glib::wrap(g_io_stream_get_output_stream(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool IOStream::close(const Glib::RefPtr<Cancellable>& cancellable)
#else
bool IOStream::close(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_io_stream_close(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool IOStream::close_finish(const Glib::RefPtr<AsyncResult>& result)
#else
bool IOStream::close_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_io_stream_close_finish(gobj(), Glib::unwrap(result), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

bool IOStream::is_closed() const
{
  return g_io_stream_is_closed(const_cast<GIOStream*>(gobj()));
}

bool IOStream::has_pending() const
{
  return g_io_stream_has_pending(const_cast<GIOStream*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool IOStream::set_pending()
#else
bool IOStream::set_pending(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_io_stream_set_pending(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

void IOStream::clear_pending()
{
g_io_stream_clear_pending(gobj()); 
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gio


