/* gcp-c-document.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-c-document.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <gedit/gedit-document.h>
#include <clang-c/Index.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define GCP_TYPE_DOCUMENT (gcp_document_get_type ())
#define GCP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DOCUMENT, GcpDocument))
#define GCP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DOCUMENT, GcpDocumentClass))
#define GCP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DOCUMENT))
#define GCP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DOCUMENT))
#define GCP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DOCUMENT, GcpDocumentClass))

typedef struct _GcpDocument GcpDocument;
typedef struct _GcpDocumentClass GcpDocumentClass;
typedef struct _GcpDocumentPrivate GcpDocumentPrivate;

#define GCP_TYPE_SYMBOL_BROWSER_SUPPORT (gcp_symbol_browser_support_get_type ())
#define GCP_SYMBOL_BROWSER_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SYMBOL_BROWSER_SUPPORT, GcpSymbolBrowserSupport))
#define GCP_IS_SYMBOL_BROWSER_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SYMBOL_BROWSER_SUPPORT))
#define GCP_SYMBOL_BROWSER_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SYMBOL_BROWSER_SUPPORT, GcpSymbolBrowserSupportIface))

typedef struct _GcpSymbolBrowserSupport GcpSymbolBrowserSupport;
typedef struct _GcpSymbolBrowserSupportIface GcpSymbolBrowserSupportIface;

#define GCP_TYPE_SYMBOL_BROWSER (gcp_symbol_browser_get_type ())
#define GCP_SYMBOL_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SYMBOL_BROWSER, GcpSymbolBrowser))
#define GCP_SYMBOL_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SYMBOL_BROWSER, GcpSymbolBrowserClass))
#define GCP_IS_SYMBOL_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SYMBOL_BROWSER))
#define GCP_IS_SYMBOL_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SYMBOL_BROWSER))
#define GCP_SYMBOL_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SYMBOL_BROWSER, GcpSymbolBrowserClass))

typedef struct _GcpSymbolBrowser GcpSymbolBrowser;
typedef struct _GcpSymbolBrowserClass GcpSymbolBrowserClass;

#define GCP_TYPE_DIAGNOSTIC_SUPPORT (gcp_diagnostic_support_get_type ())
#define GCP_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupport))
#define GCP_IS_DIAGNOSTIC_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT))
#define GCP_DIAGNOSTIC_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_DIAGNOSTIC_SUPPORT, GcpDiagnosticSupportIface))

typedef struct _GcpDiagnosticSupport GcpDiagnosticSupport;
typedef struct _GcpDiagnosticSupportIface GcpDiagnosticSupportIface;

#define GCP_TYPE_DIAGNOSTIC_TAGS (gcp_diagnostic_tags_get_type ())
#define GCP_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTags))
#define GCP_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))
#define GCP_IS_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_IS_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_TAGS))
#define GCP_DIAGNOSTIC_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_TAGS, GcpDiagnosticTagsClass))

typedef struct _GcpDiagnosticTags GcpDiagnosticTags;
typedef struct _GcpDiagnosticTagsClass GcpDiagnosticTagsClass;

#define GCP_TYPE_SOURCE_INDEX (gcp_source_index_get_type ())
#define GCP_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndex))
#define GCP_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))
#define GCP_IS_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_INDEX))
#define GCP_IS_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_INDEX))
#define GCP_SOURCE_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_INDEX, GcpSourceIndexClass))

typedef struct _GcpSourceIndex GcpSourceIndex;
typedef struct _GcpSourceIndexClass GcpSourceIndexClass;

#define GCP_TYPE_DIAGNOSTIC (gcp_diagnostic_get_type ())
#define GCP_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnostic))
#define GCP_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))
#define GCP_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC))
#define GCP_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC))
#define GCP_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))

typedef struct _GcpDiagnostic GcpDiagnostic;
typedef struct _GcpDiagnosticClass GcpDiagnosticClass;

#define GCP_TYPE_SEMANTIC_VALUE_SUPPORT (gcp_semantic_value_support_get_type ())
#define GCP_SEMANTIC_VALUE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SEMANTIC_VALUE_SUPPORT, GcpSemanticValueSupport))
#define GCP_IS_SEMANTIC_VALUE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SEMANTIC_VALUE_SUPPORT))
#define GCP_SEMANTIC_VALUE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SEMANTIC_VALUE_SUPPORT, GcpSemanticValueSupportIface))

typedef struct _GcpSemanticValueSupport GcpSemanticValueSupport;
typedef struct _GcpSemanticValueSupportIface GcpSemanticValueSupportIface;

#define GCP_TYPE_SEMANTIC_VALUE (gcp_semantic_value_get_type ())
#define GCP_SEMANTIC_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SEMANTIC_VALUE, GcpSemanticValue))
#define GCP_SEMANTIC_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SEMANTIC_VALUE, GcpSemanticValueClass))
#define GCP_IS_SEMANTIC_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SEMANTIC_VALUE))
#define GCP_IS_SEMANTIC_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SEMANTIC_VALUE))
#define GCP_SEMANTIC_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SEMANTIC_VALUE, GcpSemanticValueClass))

typedef struct _GcpSemanticValue GcpSemanticValue;
typedef struct _GcpSemanticValueClass GcpSemanticValueClass;

#define GCP_C_TYPE_DOCUMENT (gcp_c_document_get_type ())
#define GCP_C_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_DOCUMENT, GcpCDocument))
#define GCP_C_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_DOCUMENT, GcpCDocumentClass))
#define GCP_C_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_DOCUMENT))
#define GCP_C_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_DOCUMENT))
#define GCP_C_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_DOCUMENT, GcpCDocumentClass))

typedef struct _GcpCDocument GcpCDocument;
typedef struct _GcpCDocumentClass GcpCDocumentClass;
typedef struct _GcpCDocumentPrivate GcpCDocumentPrivate;

#define GCP_C_TYPE_TRANSLATION_UNIT (gcp_c_translation_unit_get_type ())
#define GCP_C_TRANSLATION_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_TRANSLATION_UNIT, GcpCTranslationUnit))
#define GCP_C_TRANSLATION_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_TRANSLATION_UNIT, GcpCTranslationUnitClass))
#define GCP_C_IS_TRANSLATION_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_TRANSLATION_UNIT))
#define GCP_C_IS_TRANSLATION_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_TRANSLATION_UNIT))
#define GCP_C_TRANSLATION_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_TRANSLATION_UNIT, GcpCTranslationUnitClass))

typedef struct _GcpCTranslationUnit GcpCTranslationUnit;
typedef struct _GcpCTranslationUnitClass GcpCTranslationUnitClass;

#define GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER (gcp_c_document_cursor_wrapper_get_type ())
#define GCP_C_DOCUMENT_CURSOR_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER, GcpCDocumentCursorWrapper))
#define GCP_C_DOCUMENT_CURSOR_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER, GcpCDocumentCursorWrapperClass))
#define GCP_C_DOCUMENT_IS_CURSOR_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER))
#define GCP_C_DOCUMENT_IS_CURSOR_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER))
#define GCP_C_DOCUMENT_CURSOR_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER, GcpCDocumentCursorWrapperClass))

typedef struct _GcpCDocumentCursorWrapper GcpCDocumentCursorWrapper;
typedef struct _GcpCDocumentCursorWrapperClass GcpCDocumentCursorWrapperClass;

#define GCP_C_TYPE_SEMANTIC_VALUE (gcp_c_semantic_value_get_type ())
#define GCP_C_SEMANTIC_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_SEMANTIC_VALUE, GcpCSemanticValue))
#define GCP_C_SEMANTIC_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_SEMANTIC_VALUE, GcpCSemanticValueClass))
#define GCP_C_IS_SEMANTIC_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_SEMANTIC_VALUE))
#define GCP_C_IS_SEMANTIC_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_SEMANTIC_VALUE))
#define GCP_C_SEMANTIC_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_SEMANTIC_VALUE, GcpCSemanticValueClass))

typedef struct _GcpCSemanticValue GcpCSemanticValue;
typedef struct _GcpCSemanticValueClass GcpCSemanticValueClass;
#define _gcp_diagnostic_tags_unref0(var) ((var == NULL) ? NULL : (var = (gcp_diagnostic_tags_unref (var), NULL)))
#define _gcp_c_translation_unit_unref0(var) ((var == NULL) ? NULL : (var = (gcp_c_translation_unit_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;

#define GCP_DIAGNOSTIC_TYPE_SEVERITY (gcp_diagnostic_severity_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _clang_disposeDiagnostic0(var) ((var == NULL) ? NULL : (var = (clang_disposeDiagnostic (var), NULL)))

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;

#define GCP_DIAGNOSTIC_TYPE_FIXIT (gcp_diagnostic_fixit_get_type ())
typedef struct _GcpDiagnosticFixit GcpDiagnosticFixit;

#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;
#define _gcp_c_document_cursor_wrapper_unref0(var) ((var == NULL) ? NULL : (var = (gcp_c_document_cursor_wrapper_unref (var), NULL)))
typedef struct _GcpCDocumentCursorWrapperPrivate GcpCDocumentCursorWrapperPrivate;
typedef struct _GcpCDocumentParamSpecCursorWrapper GcpCDocumentParamSpecCursorWrapper;

struct _GcpDocument {
	GObject parent_instance;
	GcpDocumentPrivate * priv;
};

struct _GcpDocumentClass {
	GObjectClass parent_class;
	gboolean (*get_tainted) (GcpDocument* self);
	void (*set_tainted) (GcpDocument* self, gboolean value);
};

struct _GcpSymbolBrowserSupportIface {
	GTypeInterface parent_iface;
	GcpSymbolBrowser* (*get_symbol_browser) (GcpSymbolBrowserSupport* self);
};

struct _GcpDiagnosticSupportIface {
	GTypeInterface parent_iface;
	GcpDiagnosticTags* (*get_tags) (GcpDiagnosticSupport* self);
	void (*set_tags) (GcpDiagnosticSupport* self, GcpDiagnosticTags* value);
	GcpSourceIndex* (*get_diagnostics) (GcpDiagnosticSupport* self);
};

struct _GcpSemanticValueSupportIface {
	GTypeInterface parent_iface;
	GcpSourceIndex* (*get_semantics) (GcpSemanticValueSupport* self);
};

struct _GcpCDocument {
	GcpDocument parent_instance;
	GcpCDocumentPrivate * priv;
};

struct _GcpCDocumentClass {
	GcpDocumentClass parent_class;
};

struct _GcpCDocumentPrivate {
	GcpDiagnosticTags* _tags;
	GcpCTranslationUnit* d_tu;
	GcpSymbolBrowser* d_symbols;
	GcpSourceIndex* d_diagnostics;
	GeeHashMap* d_semanticsMap;
	GcpSourceIndex* d_semantics;
};

typedef enum  {
	GCP_DIAGNOSTIC_SEVERITY_NONE,
	GCP_DIAGNOSTIC_SEVERITY_INFO,
	GCP_DIAGNOSTIC_SEVERITY_WARNING,
	GCP_DIAGNOSTIC_SEVERITY_ERROR,
	GCP_DIAGNOSTIC_SEVERITY_FATAL,
	GCP_DIAGNOSTIC_SEVERITY_NUM
} GcpDiagnosticSeverity;

struct _GcpDiagnosticFixit {
	GcpSourceRange* range;
	gchar* replacement;
};

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};

typedef void (*GcpCSemanticValueCursorMappedFunc) (CXCursor cursor, GcpCSemanticValue* val, void* user_data);
typedef void (*GcpCTranslationUnitWithTranslationUnitCallback) (void* tu, void* user_data);
struct _GcpCDocumentCursorWrapper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcpCDocumentCursorWrapperPrivate * priv;
	CXCursor cursor;
};

struct _GcpCDocumentCursorWrapperClass {
	GTypeClass parent_class;
	void (*finalize) (GcpCDocumentCursorWrapper *self);
};

struct _GcpCDocumentParamSpecCursorWrapper {
	GParamSpec parent_instance;
};


static gpointer gcp_c_document_parent_class = NULL;
static gpointer gcp_c_document_cursor_wrapper_parent_class = NULL;
static GType gcp_c_document_cursor_wrapper_type_id = 0;
static GcpSymbolBrowserSupportIface* gcp_c_document_gcp_symbol_browser_support_parent_iface = NULL;
static GcpDiagnosticSupportIface* gcp_c_document_gcp_diagnostic_support_parent_iface = NULL;
static GcpSemanticValueSupportIface* gcp_c_document_gcp_semantic_value_support_parent_iface = NULL;
static GType gcp_c_document_type_id = 0;

GType gcp_document_get_type (void) G_GNUC_CONST;
GType gcp_document_register_type (GTypeModule * module);
GType gcp_symbol_browser_get_type (void) G_GNUC_CONST;
GType gcp_symbol_browser_register_type (GTypeModule * module);
GType gcp_symbol_browser_support_get_type (void) G_GNUC_CONST;
GType gcp_symbol_browser_support_register_type (GTypeModule * module);
gpointer gcp_diagnostic_tags_ref (gpointer instance);
void gcp_diagnostic_tags_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_tags (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_tags (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_tags (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_tags (const GValue* value);
GType gcp_diagnostic_tags_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_tags_register_type (GTypeModule * module);
GType gcp_source_index_get_type (void) G_GNUC_CONST;
GType gcp_source_index_register_type (GTypeModule * module);
GType gcp_diagnostic_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_register_type (GTypeModule * module);
GType gcp_diagnostic_support_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_support_register_type (GTypeModule * module);
GType gcp_semantic_value_get_type (void) G_GNUC_CONST;
GType gcp_semantic_value_register_type (GTypeModule * module);
GType gcp_semantic_value_support_get_type (void) G_GNUC_CONST;
GType gcp_semantic_value_support_register_type (GTypeModule * module);
GType gcp_c_document_get_type (void) G_GNUC_CONST;
GType gcp_c_document_register_type (GTypeModule * module);
gpointer gcp_c_translation_unit_ref (gpointer instance);
void gcp_c_translation_unit_unref (gpointer instance);
GParamSpec* gcp_c_param_spec_translation_unit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_c_value_set_translation_unit (GValue* value, gpointer v_object);
void gcp_c_value_take_translation_unit (GValue* value, gpointer v_object);
gpointer gcp_c_value_get_translation_unit (const GValue* value);
GType gcp_c_translation_unit_get_type (void) G_GNUC_CONST;
GType gcp_c_translation_unit_register_type (GTypeModule * module);
static gpointer gcp_c_document_cursor_wrapper_ref (gpointer instance);
static void gcp_c_document_cursor_wrapper_unref (gpointer instance);
static GParamSpec* gcp_c_document_param_spec_cursor_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gcp_c_document_value_set_cursor_wrapper (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gcp_c_document_value_take_cursor_wrapper (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gcp_c_document_value_get_cursor_wrapper (const GValue* value) G_GNUC_UNUSED;
GType gcp_c_document_cursor_wrapper_get_type (void) G_GNUC_CONST;
GType gcp_c_document_cursor_wrapper_register_type (GTypeModule * module);
GType gcp_c_semantic_value_get_type (void) G_GNUC_CONST;
GType gcp_c_semantic_value_register_type (GTypeModule * module);
#define GCP_C_DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_C_TYPE_DOCUMENT, GcpCDocumentPrivate))
enum  {
	GCP_C_DOCUMENT_DUMMY_PROPERTY,
	GCP_C_DOCUMENT_TAGS,
	GCP_C_DOCUMENT_SYMBOL_BROWSER,
	GCP_C_DOCUMENT_DIAGNOSTICS,
	GCP_C_DOCUMENT_SEMANTICS,
	GCP_C_DOCUMENT_TRANSLATION_UNIT
};
GcpCDocument* gcp_c_document_new (GeditDocument* document);
GcpCDocument* gcp_c_document_construct (GType object_type, GeditDocument* document);
GcpDocument* gcp_document_new (GeditDocument* document);
GcpDocument* gcp_document_construct (GType object_type, GeditDocument* document);
GcpCTranslationUnit* gcp_c_translation_unit_new (void);
GcpCTranslationUnit* gcp_c_translation_unit_construct (GType object_type);
GcpSymbolBrowser* gcp_symbol_browser_new (void);
GcpSymbolBrowser* gcp_symbol_browser_construct (GType object_type);
GcpSourceIndex* gcp_source_index_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
GcpSourceIndex* gcp_source_index_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
static void gcp_c_document_on_tu_update (GcpCDocument* self);
static void _gcp_c_document_on_tu_update_gcp_c_translation_unit_update (GcpCTranslationUnit* _sender, gpointer self);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
static void gcp_c_document_clip_location (GcpCDocument* self, GcpSourceLocation* location);
gint gcp_source_location_get_line (GcpSourceLocation* self);
GeditDocument* gcp_document_get_document (GcpDocument* self);
void gcp_source_location_set_line (GcpSourceLocation* self, gint value);
static void gcp_c_document_update_diagnostics (GcpCDocument* self, void* tu);
void gcp_source_index_clear (GcpSourceIndex* self);
void gcp_log_debug (const gchar* format, ...);
GType gcp_diagnostic_severity_get_type (void) G_GNUC_CONST;
GcpDiagnosticSeverity gcp_c_translator_severity (enum CXDiagnosticSeverity severity);
GcpSourceLocation* gcp_c_translator_source_location (CXSourceLocation location);
GFile* gcp_source_location_get_file (GcpSourceLocation* self);
GFile* gcp_document_get_location (GcpDocument* self);
GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
GcpSourceRange* gcp_c_translator_source_range (CXSourceRange range);
GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self);
GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self);
GType gcp_diagnostic_fixit_get_type (void) G_GNUC_CONST;
GcpDiagnosticFixit* gcp_diagnostic_fixit_dup (const GcpDiagnosticFixit* self);
void gcp_diagnostic_fixit_free (GcpDiagnosticFixit* self);
void gcp_diagnostic_fixit_copy (const GcpDiagnosticFixit* self, GcpDiagnosticFixit* dest);
void gcp_diagnostic_fixit_destroy (GcpDiagnosticFixit* self);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
void gcp_source_index_add (GcpSourceIndex* self, GcpSourceRangeSupport* range);
GcpDiagnostic* gcp_diagnostic_new (GcpDiagnosticSeverity severity, GcpSourceLocation* location, GcpSourceRange** ranges, int ranges_length1, GcpDiagnosticFixit* fixits, int fixits_length1, const gchar* message);
GcpDiagnostic* gcp_diagnostic_construct (GType object_type, GcpDiagnosticSeverity severity, GcpSourceLocation* location, GcpSourceRange** ranges, int ranges_length1, GcpDiagnosticFixit* fixits, int fixits_length1, const gchar* message);
static void _vala_GcpDiagnosticFixit_array_free (GcpDiagnosticFixit* array, gint array_length);
static void gcp_c_document_update_semantics (GcpCDocument* self, void* tu);
static guint gcp_c_document_cursor_wrapper_hash (GcpCDocumentCursorWrapper* self);
static guint _gcp_c_document_cursor_wrapper_hash_ghash_func (gconstpointer key);
static gboolean gcp_c_document_cursor_wrapper_equal (GcpCDocumentCursorWrapper* self, GcpCDocumentCursorWrapper* other);
GcpCSemanticValue* gcp_c_semantic_value_translate (CXCursor cursor, GFile* source, GcpCSemanticValueCursorMappedFunc mapped, void* mapped_target);
static void _lambda9_ (CXCursor cursor, GcpCSemanticValue* val, GcpCDocument* self);
static GcpCDocumentCursorWrapper* gcp_c_document_cursor_wrapper_new (CXCursor c);
static GcpCDocumentCursorWrapper* gcp_c_document_cursor_wrapper_construct (GType object_type, CXCursor c);
gboolean gcp_c_translator_is_reference (CXCursor cursor);
GcpCSemanticValue* gcp_c_semantic_value_new (CXCursor cursor);
GcpCSemanticValue* gcp_c_semantic_value_construct (GType object_type, CXCursor cursor);
gint gcp_semantic_value_get_num_references (GcpSemanticValue* self);
GcpSemanticValue* gcp_semantic_value_reference (GcpSemanticValue* self, gint idx);
void gcp_c_semantic_value_add_reference (GcpCSemanticValue* self, GcpCSemanticValue* val);
static void __lambda9__gcp_csemantic_value_cursor_mapped_func (CXCursor cursor, GcpCSemanticValue* val, gpointer self);
void gcp_c_translation_unit_with_translation_unit (GcpCTranslationUnit* self, GcpCTranslationUnitWithTranslationUnitCallback callback, void* callback_target);
static void _lambda8_ (void* tu, GcpCDocument* self);
static void __lambda8__gcp_ctranslation_unit_with_translation_unit_callback (void* tu, gpointer self);
GcpCTranslationUnit* gcp_c_document_get_translation_unit (GcpCDocument* self);
enum  {
	GCP_C_DOCUMENT_CURSOR_WRAPPER_DUMMY_PROPERTY
};
static void gcp_c_document_cursor_wrapper_finalize (GcpCDocumentCursorWrapper* obj);
static void gcp_c_document_finalize (GObject* obj);
GcpDiagnosticTags* gcp_diagnostic_support_get_tags (GcpDiagnosticSupport* self);
GcpSymbolBrowser* gcp_symbol_browser_support_get_symbol_browser (GcpSymbolBrowserSupport* self);
GcpSourceIndex* gcp_diagnostic_support_get_diagnostics (GcpDiagnosticSupport* self);
GcpSourceIndex* gcp_semantic_value_support_get_semantics (GcpSemanticValueSupport* self);
static void _vala_gcp_c_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gcp_diagnostic_support_set_tags (GcpDiagnosticSupport* self, GcpDiagnosticTags* value);
static void _vala_gcp_c_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _gcp_c_document_on_tu_update_gcp_c_translation_unit_update (GcpCTranslationUnit* _sender, gpointer self) {
	gcp_c_document_on_tu_update (self);
}


GcpCDocument* gcp_c_document_construct (GType object_type, GeditDocument* document) {
	GcpCDocument * self = NULL;
	GcpCTranslationUnit* _tmp0_ = NULL;
	GcpSymbolBrowser* _tmp1_ = NULL;
	GcpSourceIndex* _tmp2_ = NULL;
	GcpSourceIndex* _tmp3_ = NULL;
	g_return_val_if_fail (document != NULL, NULL);
	self = (GcpCDocument*) gcp_document_construct (object_type, document);
	_tmp0_ = gcp_c_translation_unit_new ();
	_gcp_c_translation_unit_unref0 (self->priv->d_tu);
	self->priv->d_tu = _tmp0_;
	_tmp1_ = gcp_symbol_browser_new ();
	_g_object_unref0 (self->priv->d_symbols);
	self->priv->d_symbols = _tmp1_;
	_tmp2_ = gcp_source_index_new (GCP_TYPE_DIAGNOSTIC, (GBoxedCopyFunc) g_object_ref, g_object_unref);
	_g_object_unref0 (self->priv->d_diagnostics);
	self->priv->d_diagnostics = _tmp2_;
	_tmp3_ = gcp_source_index_new (GCP_C_TYPE_SEMANTIC_VALUE, (GBoxedCopyFunc) g_object_ref, g_object_unref);
	_g_object_unref0 (self->priv->d_semantics);
	self->priv->d_semantics = _tmp3_;
	g_signal_connect_object (self->priv->d_tu, "update", (GCallback) _gcp_c_document_on_tu_update_gcp_c_translation_unit_update, self, 0);
	return self;
}


GcpCDocument* gcp_c_document_new (GeditDocument* document) {
	return gcp_c_document_construct (GCP_C_TYPE_DOCUMENT, document);
}


static void gcp_c_document_clip_location (GcpCDocument* self, GcpSourceLocation* location) {
	gint _tmp0_;
	GeditDocument* _tmp1_ = NULL;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = gcp_source_location_get_line (location);
	_tmp1_ = gcp_document_get_document ((GcpDocument*) self);
	_tmp2_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) _tmp1_);
	if (_tmp0_ > _tmp2_) {
		GeditDocument* _tmp3_ = NULL;
		gint _tmp4_;
		_tmp3_ = gcp_document_get_document ((GcpDocument*) self);
		_tmp4_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) _tmp3_);
		gcp_source_location_set_line (location, _tmp4_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_GcpDiagnosticFixit_array_free (GcpDiagnosticFixit* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gcp_diagnostic_fixit_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void gcp_c_document_update_diagnostics (GcpCDocument* self, void* tu) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tu != NULL);
	gcp_source_index_clear (self->priv->d_diagnostics);
	_tmp0_ = clang_getNumDiagnostics (tu);
	gcp_log_debug ("New diagnostics: %d", _tmp0_, NULL);
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				CXDiagnostic* _tmp3_ = NULL;
				CXDiagnostic* d;
				enum CXDiagnosticSeverity _tmp4_;
				GcpDiagnosticSeverity _tmp5_;
				GcpDiagnosticSeverity severity;
				CXSourceLocation _tmp6_;
				GcpSourceLocation* _tmp7_ = NULL;
				GcpSourceLocation* loc;
				gchar* _tmp8_ = NULL;
				GFile* _tmp9_ = NULL;
				gboolean _tmp12_ = FALSE;
				GFile* _tmp13_ = NULL;
				GeeLinkedList* _tmp19_ = NULL;
				GeeLinkedList* ranges;
				guint _tmp41_;
				GcpDiagnosticFixit* _tmp42_ = NULL;
				GcpDiagnosticFixit* fixits;
				gint fixits_length1;
				gint _fixits_size_;
				gint _tmp73_;
				gpointer* _tmp74_ = NULL;
				GcpSourceRange** _tmp75_;
				gint _tmp75__length1;
				CXString _tmp76_;
				const gchar* _tmp77_ = NULL;
				GcpDiagnostic* _tmp78_ = NULL;
				GcpDiagnostic* _tmp79_;
				if (!_tmp1_) {
					i = i + 1;
				}
				_tmp1_ = FALSE;
				_tmp2_ = clang_getNumDiagnostics (tu);
				if (!(i < _tmp2_)) {
					break;
				}
				_tmp3_ = clang_getDiagnostic (tu, i);
				d = _tmp3_;
				_tmp4_ = clang_getDiagnosticSeverity (d);
				_tmp5_ = gcp_c_translator_severity (_tmp4_);
				severity = _tmp5_;
				_tmp6_ = clang_getDiagnosticLocation (d);
				_tmp7_ = gcp_c_translator_source_location (_tmp6_);
				loc = _tmp7_;
				_tmp9_ = gcp_source_location_get_file (loc);
				if (_tmp9_ == NULL) {
					_g_free0 (_tmp8_);
					_tmp8_ = NULL;
				} else {
					GFile* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					_tmp10_ = gcp_source_location_get_file (loc);
					_tmp11_ = g_file_get_path (_tmp10_);
					_g_free0 (_tmp8_);
					_tmp8_ = _tmp11_;
				}
				gcp_log_debug ("Diagnostic location [%d]: %s", i, _tmp8_, NULL);
				_tmp13_ = gcp_source_location_get_file (loc);
				if (_tmp13_ == NULL) {
					_tmp12_ = TRUE;
				} else {
					GFile* _tmp14_ = NULL;
					GFile* _tmp15_ = NULL;
					gboolean _tmp16_;
					_tmp14_ = gcp_source_location_get_file (loc);
					_tmp15_ = gcp_document_get_location ((GcpDocument*) self);
					_tmp16_ = g_file_equal (_tmp14_, _tmp15_);
					_tmp12_ = !_tmp16_;
				}
				if (_tmp12_) {
					CXString _tmp17_;
					const gchar* _tmp18_ = NULL;
					_tmp17_ = clang_getDiagnosticSpelling (d);
					_tmp18_ = clang_getCString (_tmp17_);
					gcp_log_debug ("Diagnostic not for this file: %s", _tmp18_, NULL);
					_g_free0 (_tmp8_);
					_g_object_unref0 (loc);
					_clang_disposeDiagnostic0 (d);
					continue;
				}
				gcp_c_document_clip_location (self, loc);
				_tmp19_ = gee_linked_list_new (GCP_TYPE_SOURCE_RANGE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
				ranges = _tmp19_;
				{
					guint j;
					j = (guint) 0;
					{
						gboolean _tmp20_;
						_tmp20_ = TRUE;
						while (TRUE) {
							guint _tmp21_;
							CXSourceRange _tmp22_;
							GcpSourceRange* _tmp23_ = NULL;
							GcpSourceRange* range;
							gboolean _tmp24_ = FALSE;
							gboolean _tmp25_ = FALSE;
							gboolean _tmp26_ = FALSE;
							GcpSourceLocation* _tmp27_ = NULL;
							GFile* _tmp28_ = NULL;
							if (!_tmp20_) {
								j = j + 1;
							}
							_tmp20_ = FALSE;
							_tmp21_ = clang_getDiagnosticNumRanges (d);
							if (!(j < _tmp21_)) {
								break;
							}
							_tmp22_ = clang_getDiagnosticRange (d, j);
							_tmp23_ = gcp_c_translator_source_range (_tmp22_);
							range = _tmp23_;
							_tmp27_ = gcp_source_range_get_start (range);
							_tmp28_ = gcp_source_location_get_file (_tmp27_);
							if (_tmp28_ != NULL) {
								GcpSourceLocation* _tmp29_ = NULL;
								GFile* _tmp30_ = NULL;
								_tmp29_ = gcp_source_range_get_end (range);
								_tmp30_ = gcp_source_location_get_file (_tmp29_);
								_tmp26_ = _tmp30_ != NULL;
							} else {
								_tmp26_ = FALSE;
							}
							if (_tmp26_) {
								GcpSourceLocation* _tmp31_ = NULL;
								GFile* _tmp32_ = NULL;
								GFile* _tmp33_ = NULL;
								gboolean _tmp34_;
								_tmp31_ = gcp_source_range_get_start (range);
								_tmp32_ = gcp_source_location_get_file (_tmp31_);
								_tmp33_ = gcp_document_get_location ((GcpDocument*) self);
								_tmp34_ = g_file_equal (_tmp32_, _tmp33_);
								_tmp25_ = _tmp34_;
							} else {
								_tmp25_ = FALSE;
							}
							if (_tmp25_) {
								GcpSourceLocation* _tmp35_ = NULL;
								GFile* _tmp36_ = NULL;
								GFile* _tmp37_ = NULL;
								gboolean _tmp38_;
								_tmp35_ = gcp_source_range_get_end (range);
								_tmp36_ = gcp_source_location_get_file (_tmp35_);
								_tmp37_ = gcp_document_get_location ((GcpDocument*) self);
								_tmp38_ = g_file_equal (_tmp36_, _tmp37_);
								_tmp24_ = _tmp38_;
							} else {
								_tmp24_ = FALSE;
							}
							if (_tmp24_) {
								GcpSourceLocation* _tmp39_ = NULL;
								GcpSourceLocation* _tmp40_ = NULL;
								_tmp39_ = gcp_source_range_get_start (range);
								gcp_c_document_clip_location (self, _tmp39_);
								_tmp40_ = gcp_source_range_get_end (range);
								gcp_c_document_clip_location (self, _tmp40_);
								gee_abstract_collection_add ((GeeAbstractCollection*) ranges, range);
							}
							_g_object_unref0 (range);
						}
					}
				}
				_tmp41_ = clang_getDiagnosticNumFixIts (d);
				_tmp42_ = g_new0 (GcpDiagnosticFixit, _tmp41_);
				fixits = _tmp42_;
				fixits_length1 = _tmp41_;
				_fixits_size_ = _tmp41_;
				{
					guint j;
					j = (guint) 0;
					{
						gboolean _tmp43_;
						_tmp43_ = TRUE;
						while (TRUE) {
							guint _tmp44_;
							CXSourceRange range;
							CXSourceRange _tmp45_;
							CXString _tmp46_;
							CXString _tmp47_;
							const gchar* _tmp48_ = NULL;
							gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* repl;
							GcpSourceRange* _tmp51_ = NULL;
							GcpSourceRange* r;
							gboolean _tmp52_ = FALSE;
							gboolean _tmp53_ = FALSE;
							gboolean _tmp54_ = FALSE;
							GcpSourceLocation* _tmp55_ = NULL;
							GFile* _tmp56_ = NULL;
							if (!_tmp43_) {
								j = j + 1;
							}
							_tmp43_ = FALSE;
							_tmp44_ = clang_getDiagnosticNumFixIts (d);
							if (!(j < _tmp44_)) {
								break;
							}
							_tmp46_ = clang_getDiagnosticFixIt (d, j, &_tmp45_);
							range = _tmp45_;
							_tmp47_ = _tmp46_;
							_tmp48_ = clang_getCString (_tmp47_);
							_tmp49_ = g_strdup (_tmp48_);
							_tmp50_ = _tmp49_;
							clang_disposeString (_tmp47_);
							repl = _tmp50_;
							_tmp51_ = gcp_c_translator_source_range (range);
							r = _tmp51_;
							_tmp55_ = gcp_source_range_get_start (r);
							_tmp56_ = gcp_source_location_get_file (_tmp55_);
							if (_tmp56_ != NULL) {
								GcpSourceLocation* _tmp57_ = NULL;
								GFile* _tmp58_ = NULL;
								_tmp57_ = gcp_source_range_get_end (r);
								_tmp58_ = gcp_source_location_get_file (_tmp57_);
								_tmp54_ = _tmp58_ != NULL;
							} else {
								_tmp54_ = FALSE;
							}
							if (_tmp54_) {
								GcpSourceLocation* _tmp59_ = NULL;
								GFile* _tmp60_ = NULL;
								GFile* _tmp61_ = NULL;
								gboolean _tmp62_;
								_tmp59_ = gcp_source_range_get_start (r);
								_tmp60_ = gcp_source_location_get_file (_tmp59_);
								_tmp61_ = gcp_document_get_location ((GcpDocument*) self);
								_tmp62_ = g_file_equal (_tmp60_, _tmp61_);
								_tmp53_ = _tmp62_;
							} else {
								_tmp53_ = FALSE;
							}
							if (_tmp53_) {
								GcpSourceLocation* _tmp63_ = NULL;
								GFile* _tmp64_ = NULL;
								GFile* _tmp65_ = NULL;
								gboolean _tmp66_;
								_tmp63_ = gcp_source_range_get_end (r);
								_tmp64_ = gcp_source_location_get_file (_tmp63_);
								_tmp65_ = gcp_document_get_location ((GcpDocument*) self);
								_tmp66_ = g_file_equal (_tmp64_, _tmp65_);
								_tmp52_ = _tmp66_;
							} else {
								_tmp52_ = FALSE;
							}
							if (_tmp52_) {
								GcpSourceLocation* _tmp67_ = NULL;
								GcpSourceLocation* _tmp68_ = NULL;
								GcpSourceRange* _tmp69_;
								gchar* _tmp70_;
								GcpDiagnosticFixit _tmp71_ = {0};
								GcpDiagnosticFixit _tmp72_;
								_tmp67_ = gcp_source_range_get_start (r);
								gcp_c_document_clip_location (self, _tmp67_);
								_tmp68_ = gcp_source_range_get_end (r);
								gcp_c_document_clip_location (self, _tmp68_);
								_tmp69_ = _g_object_ref0 (r);
								_tmp70_ = g_strdup (repl);
								_tmp71_.range = _tmp69_;
								_tmp71_.replacement = _tmp70_;
								_tmp72_ = _tmp71_;
								gcp_diagnostic_fixit_destroy (&fixits[j]);
								fixits[j] = _tmp72_;
							}
							_g_object_unref0 (r);
							_g_free0 (repl);
						}
					}
				}
				_tmp74_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) ranges, &_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp75__length1 = _tmp73_;
				_tmp76_ = clang_getDiagnosticSpelling (d);
				_tmp77_ = clang_getCString (_tmp76_);
				_tmp78_ = gcp_diagnostic_new (severity, loc, _tmp75_, _tmp73_, fixits, fixits_length1, _tmp77_);
				_tmp79_ = _tmp78_;
				gcp_source_index_add (self->priv->d_diagnostics, (GcpSourceRangeSupport*) _tmp79_);
				_g_object_unref0 (_tmp79_);
				_tmp75_ = (_vala_array_free (_tmp75_, _tmp75__length1, (GDestroyNotify) g_object_unref), NULL);
				fixits = (_vala_GcpDiagnosticFixit_array_free (fixits, fixits_length1), NULL);
				_g_object_unref0 (ranges);
				_g_free0 (_tmp8_);
				_g_object_unref0 (loc);
				_clang_disposeDiagnostic0 (d);
			}
		}
	}
	g_signal_emit_by_name ((GcpDiagnosticSupport*) self, "diagnostics-updated");
}


static guint _gcp_c_document_cursor_wrapper_hash_ghash_func (gconstpointer key) {
	guint result;
	result = gcp_c_document_cursor_wrapper_hash (key);
	return result;
}


static void _lambda9_ (CXCursor cursor, GcpCSemanticValue* val, GcpCDocument* self) {
	GcpCDocumentCursorWrapper* _tmp0_ = NULL;
	GcpCDocumentCursorWrapper* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (val != NULL);
	gcp_source_index_add (self->priv->d_semantics, (GcpSourceRangeSupport*) val);
	_tmp0_ = gcp_c_document_cursor_wrapper_new (cursor);
	_tmp1_ = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->d_semanticsMap, _tmp1_, val);
	_gcp_c_document_cursor_wrapper_unref0 (_tmp1_);
	_tmp2_ = gcp_c_translator_is_reference (cursor);
	if (_tmp2_) {
		CXCursor _tmp3_;
		GcpCDocumentCursorWrapper* _tmp4_ = NULL;
		GcpCDocumentCursorWrapper* wrapper;
		gboolean _tmp5_;
		gpointer _tmp9_ = NULL;
		GcpCSemanticValue* rr;
		_tmp3_ = clang_getCursorReferenced (cursor);
		_tmp4_ = gcp_c_document_cursor_wrapper_new (_tmp3_);
		wrapper = _tmp4_;
		_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_semanticsMap, wrapper);
		if (!_tmp5_) {
			CXCursor _tmp6_;
			GcpCSemanticValue* _tmp7_ = NULL;
			GcpCSemanticValue* _tmp8_;
			_tmp6_ = clang_getCursorReferenced (cursor);
			_tmp7_ = gcp_c_semantic_value_new (_tmp6_);
			_tmp8_ = _tmp7_;
			gee_abstract_map_set ((GeeAbstractMap*) self->priv->d_semanticsMap, wrapper, _tmp8_);
			_g_object_unref0 (_tmp8_);
		}
		_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_semanticsMap, wrapper);
		rr = (GcpCSemanticValue*) _tmp9_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp10_;
				_tmp10_ = TRUE;
				while (TRUE) {
					gint _tmp11_;
					GcpSemanticValue* _tmp12_ = NULL;
					GcpCSemanticValue* mr;
					if (!_tmp10_) {
						i = i + 1;
					}
					_tmp10_ = FALSE;
					_tmp11_ = gcp_semantic_value_get_num_references ((GcpSemanticValue*) rr);
					if (!(i < _tmp11_)) {
						break;
					}
					_tmp12_ = gcp_semantic_value_reference ((GcpSemanticValue*) rr, i);
					mr = GCP_C_SEMANTIC_VALUE (_tmp12_);
					gcp_c_semantic_value_add_reference (val, mr);
					gcp_c_semantic_value_add_reference (mr, val);
					_g_object_unref0 (mr);
				}
			}
		}
		gcp_c_semantic_value_add_reference (rr, val);
		gcp_c_semantic_value_add_reference (val, rr);
		_g_object_unref0 (rr);
		_gcp_c_document_cursor_wrapper_unref0 (wrapper);
	}
}


static void __lambda9__gcp_csemantic_value_cursor_mapped_func (CXCursor cursor, GcpCSemanticValue* val, gpointer self) {
	_lambda9_ (cursor, val, self);
}


static void gcp_c_document_update_semantics (GcpCDocument* self, void* tu) {
	GeeHashMap* _tmp0_ = NULL;
	CXCursor _tmp1_;
	GFile* _tmp2_ = NULL;
	GcpCSemanticValue* _tmp3_ = NULL;
	GcpCSemanticValue* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tu != NULL);
	_tmp0_ = gee_hash_map_new (GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER, (GBoxedCopyFunc) gcp_c_document_cursor_wrapper_ref, gcp_c_document_cursor_wrapper_unref, GCP_C_TYPE_SEMANTIC_VALUE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _gcp_c_document_cursor_wrapper_hash_ghash_func, (GEqualFunc) gcp_c_document_cursor_wrapper_equal, NULL);
	_g_object_unref0 (self->priv->d_semanticsMap);
	self->priv->d_semanticsMap = _tmp0_;
	gcp_source_index_clear (self->priv->d_semantics);
	_tmp1_ = clang_getTranslationUnitCursor (tu);
	_tmp2_ = gcp_document_get_location ((GcpDocument*) self);
	_tmp3_ = gcp_c_semantic_value_translate (_tmp1_, _tmp2_, __lambda9__gcp_csemantic_value_cursor_mapped_func, self);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	g_signal_emit_by_name ((GcpSemanticValueSupport*) self, "semantic-values-updated");
}


static void _lambda8_ (void* tu, GcpCDocument* self) {
	g_return_if_fail (tu != NULL);
	gcp_c_document_update_diagnostics (self, tu);
	gcp_c_document_update_semantics (self, tu);
}


static void __lambda8__gcp_ctranslation_unit_with_translation_unit_callback (void* tu, gpointer self) {
	_lambda8_ (tu, self);
}


static void gcp_c_document_on_tu_update (GcpCDocument* self) {
	g_return_if_fail (self != NULL);
	gcp_c_translation_unit_with_translation_unit (self->priv->d_tu, __lambda8__gcp_ctranslation_unit_with_translation_unit_callback, self);
}


static GcpDiagnosticTags* gcp_c_document_real_get_tags (GcpDiagnosticSupport* base) {
	GcpDiagnosticTags* result;
	GcpCDocument* self;
	self = (GcpCDocument*) base;
	result = self->priv->_tags;
	return result;
}


static gpointer _gcp_diagnostic_tags_ref0 (gpointer self) {
	return self ? gcp_diagnostic_tags_ref (self) : NULL;
}


static void gcp_c_document_real_set_tags (GcpDiagnosticSupport* base, GcpDiagnosticTags* value) {
	GcpCDocument* self;
	GcpDiagnosticTags* _tmp0_;
	self = (GcpCDocument*) base;
	_tmp0_ = _gcp_diagnostic_tags_ref0 (value);
	_gcp_diagnostic_tags_unref0 (self->priv->_tags);
	self->priv->_tags = _tmp0_;
	g_object_notify ((GObject *) self, "tags");
}


static GcpSymbolBrowser* gcp_c_document_real_get_symbol_browser (GcpSymbolBrowserSupport* base) {
	GcpSymbolBrowser* result;
	GcpCDocument* self;
	self = (GcpCDocument*) base;
	result = self->priv->d_symbols;
	return result;
}


static GcpSourceIndex* gcp_c_document_real_get_diagnostics (GcpDiagnosticSupport* base) {
	GcpSourceIndex* result;
	GcpCDocument* self;
	self = (GcpCDocument*) base;
	result = self->priv->d_diagnostics;
	return result;
}


static GcpSourceIndex* gcp_c_document_real_get_semantics (GcpSemanticValueSupport* base) {
	GcpSourceIndex* result;
	GcpCDocument* self;
	self = (GcpCDocument*) base;
	result = self->priv->d_semantics;
	return result;
}


GcpCTranslationUnit* gcp_c_document_get_translation_unit (GcpCDocument* self) {
	GcpCTranslationUnit* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_tu;
	return result;
}


static GcpCDocumentCursorWrapper* gcp_c_document_cursor_wrapper_construct (GType object_type, CXCursor c) {
	GcpCDocumentCursorWrapper* self = NULL;
	self = (GcpCDocumentCursorWrapper*) g_type_create_instance (object_type);
	self->cursor = c;
	return self;
}


static GcpCDocumentCursorWrapper* gcp_c_document_cursor_wrapper_new (CXCursor c) {
	return gcp_c_document_cursor_wrapper_construct (GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER, c);
}


static gboolean gcp_c_document_cursor_wrapper_equal (GcpCDocumentCursorWrapper* self, GcpCDocumentCursorWrapper* other) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp0_ = clang_equalCursors (self->cursor, other->cursor);
	result = _tmp0_;
	return result;
}


static guint gcp_c_document_cursor_wrapper_hash (GcpCDocumentCursorWrapper* self) {
	guint result = 0U;
	guint sline = 0U;
	guint scolumn = 0U;
	CXSourceRange _tmp0_;
	CXSourceLocation _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint eline = 0U;
	guint ecolumn = 0U;
	CXSourceRange _tmp4_;
	CXSourceLocation _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint cmp1;
	guint cmp2;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = clang_getCursorExtent (self->cursor);
	_tmp1_ = clang_getRangeStart (_tmp0_);
	clang_getInstantiationLocation (_tmp1_, NULL, &_tmp2_, &_tmp3_, NULL);
	sline = _tmp2_;
	scolumn = _tmp3_;
	_tmp4_ = clang_getCursorExtent (self->cursor);
	_tmp5_ = clang_getRangeEnd (_tmp4_);
	clang_getInstantiationLocation (_tmp5_, NULL, &_tmp6_, &_tmp7_, NULL);
	eline = _tmp6_;
	ecolumn = _tmp7_;
	cmp1 = (guint) (((0.5 * (sline + scolumn)) * ((sline + scolumn) + 1)) + scolumn);
	cmp2 = (guint) (((0.5 * (eline + ecolumn)) * ((eline + ecolumn) + 1)) + ecolumn);
	result = (guint) (((0.5 * (cmp1 + cmp2)) * ((cmp1 + cmp2) + 1)) + cmp2);
	return result;
}


static void gcp_c_document_value_cursor_wrapper_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gcp_c_document_value_cursor_wrapper_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gcp_c_document_cursor_wrapper_unref (value->data[0].v_pointer);
	}
}


static void gcp_c_document_value_cursor_wrapper_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gcp_c_document_cursor_wrapper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gcp_c_document_value_cursor_wrapper_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gcp_c_document_value_cursor_wrapper_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcpCDocumentCursorWrapper* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gcp_c_document_cursor_wrapper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gcp_c_document_value_cursor_wrapper_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcpCDocumentCursorWrapper** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gcp_c_document_cursor_wrapper_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gcp_c_document_param_spec_cursor_wrapper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcpCDocumentParamSpecCursorWrapper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gcp_c_document_value_get_cursor_wrapper (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER), NULL);
	return value->data[0].v_pointer;
}


static void gcp_c_document_value_set_cursor_wrapper (GValue* value, gpointer v_object) {
	GcpCDocumentCursorWrapper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gcp_c_document_cursor_wrapper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_c_document_cursor_wrapper_unref (old);
	}
}


static void gcp_c_document_value_take_cursor_wrapper (GValue* value, gpointer v_object) {
	GcpCDocumentCursorWrapper* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_C_DOCUMENT_TYPE_CURSOR_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_c_document_cursor_wrapper_unref (old);
	}
}


static void gcp_c_document_cursor_wrapper_class_init (GcpCDocumentCursorWrapperClass * klass) {
	gcp_c_document_cursor_wrapper_parent_class = g_type_class_peek_parent (klass);
	GCP_C_DOCUMENT_CURSOR_WRAPPER_CLASS (klass)->finalize = gcp_c_document_cursor_wrapper_finalize;
}


static void gcp_c_document_cursor_wrapper_instance_init (GcpCDocumentCursorWrapper * self) {
	self->ref_count = 1;
}


static void gcp_c_document_cursor_wrapper_finalize (GcpCDocumentCursorWrapper* obj) {
	GcpCDocumentCursorWrapper * self;
	self = GCP_C_DOCUMENT_CURSOR_WRAPPER (obj);
}


GType gcp_c_document_cursor_wrapper_get_type (void) {
	return gcp_c_document_cursor_wrapper_type_id;
}


GType gcp_c_document_cursor_wrapper_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { gcp_c_document_value_cursor_wrapper_init, gcp_c_document_value_cursor_wrapper_free_value, gcp_c_document_value_cursor_wrapper_copy_value, gcp_c_document_value_cursor_wrapper_peek_pointer, "p", gcp_c_document_value_cursor_wrapper_collect_value, "p", gcp_c_document_value_cursor_wrapper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GcpCDocumentCursorWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_c_document_cursor_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpCDocumentCursorWrapper), 0, (GInstanceInitFunc) gcp_c_document_cursor_wrapper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	gcp_c_document_cursor_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcpCDocumentCursorWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gcp_c_document_cursor_wrapper_type_id;
}


static gpointer gcp_c_document_cursor_wrapper_ref (gpointer instance) {
	GcpCDocumentCursorWrapper* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gcp_c_document_cursor_wrapper_unref (gpointer instance) {
	GcpCDocumentCursorWrapper* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCP_C_DOCUMENT_CURSOR_WRAPPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void gcp_c_document_class_init (GcpCDocumentClass * klass) {
	gcp_c_document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpCDocumentPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_c_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gcp_c_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_c_document_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), GCP_C_DOCUMENT_TAGS, "tags");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GCP_C_DOCUMENT_SYMBOL_BROWSER, "symbol-browser");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GCP_C_DOCUMENT_DIAGNOSTICS, "diagnostics");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GCP_C_DOCUMENT_SEMANTICS, "semantics");
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_C_DOCUMENT_TRANSLATION_UNIT, gcp_c_param_spec_translation_unit ("translation-unit", "translation-unit", "translation-unit", GCP_C_TYPE_TRANSLATION_UNIT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gcp_c_document_gcp_symbol_browser_support_interface_init (GcpSymbolBrowserSupportIface * iface) {
	gcp_c_document_gcp_symbol_browser_support_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_symbol_browser = gcp_c_document_real_get_symbol_browser;
}


static void gcp_c_document_gcp_diagnostic_support_interface_init (GcpDiagnosticSupportIface * iface) {
	gcp_c_document_gcp_diagnostic_support_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_tags = gcp_c_document_real_get_tags;
	iface->set_tags = gcp_c_document_real_set_tags;
	iface->get_diagnostics = gcp_c_document_real_get_diagnostics;
}


static void gcp_c_document_gcp_semantic_value_support_interface_init (GcpSemanticValueSupportIface * iface) {
	gcp_c_document_gcp_semantic_value_support_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_semantics = gcp_c_document_real_get_semantics;
}


static void gcp_c_document_instance_init (GcpCDocument * self) {
	self->priv = GCP_C_DOCUMENT_GET_PRIVATE (self);
}


static void gcp_c_document_finalize (GObject* obj) {
	GcpCDocument * self;
	self = GCP_C_DOCUMENT (obj);
	_gcp_diagnostic_tags_unref0 (self->priv->_tags);
	_gcp_c_translation_unit_unref0 (self->priv->d_tu);
	_g_object_unref0 (self->priv->d_symbols);
	_g_object_unref0 (self->priv->d_diagnostics);
	_g_object_unref0 (self->priv->d_semanticsMap);
	_g_object_unref0 (self->priv->d_semantics);
	G_OBJECT_CLASS (gcp_c_document_parent_class)->finalize (obj);
}


GType gcp_c_document_get_type (void) {
	return gcp_c_document_type_id;
}


GType gcp_c_document_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpCDocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_c_document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpCDocument), 0, (GInstanceInitFunc) gcp_c_document_instance_init, NULL };
	static const GInterfaceInfo gcp_symbol_browser_support_info = { (GInterfaceInitFunc) gcp_c_document_gcp_symbol_browser_support_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gcp_diagnostic_support_info = { (GInterfaceInitFunc) gcp_c_document_gcp_diagnostic_support_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gcp_semantic_value_support_info = { (GInterfaceInitFunc) gcp_c_document_gcp_semantic_value_support_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	gcp_c_document_type_id = g_type_module_register_type (module, GCP_TYPE_DOCUMENT, "GcpCDocument", &g_define_type_info, 0);
	g_type_module_add_interface (module, gcp_c_document_type_id, GCP_TYPE_SYMBOL_BROWSER_SUPPORT, &gcp_symbol_browser_support_info);
	g_type_module_add_interface (module, gcp_c_document_type_id, GCP_TYPE_DIAGNOSTIC_SUPPORT, &gcp_diagnostic_support_info);
	g_type_module_add_interface (module, gcp_c_document_type_id, GCP_TYPE_SEMANTIC_VALUE_SUPPORT, &gcp_semantic_value_support_info);
	return gcp_c_document_type_id;
}


static void _vala_gcp_c_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpCDocument * self;
	self = GCP_C_DOCUMENT (object);
	switch (property_id) {
		case GCP_C_DOCUMENT_TAGS:
		gcp_value_set_diagnostic_tags (value, gcp_diagnostic_support_get_tags ((GcpDiagnosticSupport*) self));
		break;
		case GCP_C_DOCUMENT_SYMBOL_BROWSER:
		g_value_set_object (value, gcp_symbol_browser_support_get_symbol_browser ((GcpSymbolBrowserSupport*) self));
		break;
		case GCP_C_DOCUMENT_DIAGNOSTICS:
		g_value_set_object (value, gcp_diagnostic_support_get_diagnostics ((GcpDiagnosticSupport*) self));
		break;
		case GCP_C_DOCUMENT_SEMANTICS:
		g_value_set_object (value, gcp_semantic_value_support_get_semantics ((GcpSemanticValueSupport*) self));
		break;
		case GCP_C_DOCUMENT_TRANSLATION_UNIT:
		gcp_c_value_set_translation_unit (value, gcp_c_document_get_translation_unit (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gcp_c_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GcpCDocument * self;
	self = GCP_C_DOCUMENT (object);
	switch (property_id) {
		case GCP_C_DOCUMENT_TAGS:
		gcp_diagnostic_support_set_tags ((GcpDiagnosticSupport*) self, gcp_value_get_diagnostic_tags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



