/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;
import org.gnu.glib.Handle;

/**
 * VBox is a container widget that organizes its contained widgets vertically.
 * Most manipulation methods are part of the super class, Box
 * 
 * @see Box
 * @see HBox
 *
 * @deprecated This class is part of the java-gnome 2.x family of libraries,
 *             which, due to their inefficiency and complexity, are no longer
 *             being maintained and have been abandoned by the java-gnome
 *             project. This class may in the future have an equivalent in
 *             java-gnome 4.0, try looking for
 *             <code>org.gnome.gtk.VBox</code>.
 *             You should be aware that there is a considerably different API
 *             in the new library: the architecture is completely different
 *             and most notably internals are no longer exposed to public view.
 */
public class VBox extends Box {
    /**
     * Constructs a new VBox widget
     * 
     * @param homogenous
     *            TRUE if all children are to be given equal space allotments.
     * @param spacing
     *            The number of pixels to place by default between children.
     * @deprecated Superceeded by java-gnome 4.0; a method along these lines
     *             may well exist in the new bindings, but if it does it likely
     *             has a different name or signature due to the shift to an
     *             algorithmic mapping of the underlying native libraries.
     */
    public VBox(boolean homogenous, int spacing) {
        super(gtk_vbox_new(homogenous, spacing));
    }

    /**
     * Construct a VBox widget from a handle to a native resource.
     * @deprecated Superceeded by java-gnome 4.0; a method along these lines
     *             may well exist in the new bindings, but if it does it likely
     *             has a different name or signature due to the shift to an
     *             algorithmic mapping of the underlying native libraries.
     */
    public VBox(Handle handle) {
        super(handle);
    }

    /**
     * Construct a VBox widget from a handle to a native resource.
     * @deprecated Superceeded by java-gnome 4.0; a method along these lines
     *             may well exist in the new bindings, but if it does it likely
     *             has a different name or signature due to the shift to an
     *             algorithmic mapping of the underlying native libraries.
     */
    public static VBox getVBox(Handle handle) {
        if (handle == null)
            return null;

        VBox obj = (VBox) getGObjectFromHandle(handle);
        if (obj == null)
            obj = new VBox(handle);

        return obj;
    }

    /**
     * Retrieve the runtime type used by the GLib library.
     * @deprecated Superceeded by java-gnome 4.0; a method along these lines
     *             may well exist in the new bindings, but if it does it likely
     *             has a different name or signature due to the shift to an
     *             algorithmic mapping of the underlying native libraries.
     */
    public static Type getType() {
        return new Type(gtk_vbox_get_type());
    }

    native static final protected int gtk_vbox_get_type();

    native static final protected Handle gtk_vbox_new(boolean homogenous,
            int spacing);
}
