/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.netbeans.core.output2.BufferResource;
import org.netbeans.core.output2.FileMapStorage;
import org.netbeans.core.output2.Storage;

class HeapStorage
implements Storage {
    private boolean closed = true;
    private byte[] bytes = new byte[2048];
    private int size = 0;

    HeapStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage toFileMapStorage() throws IOException {
        FileMapStorage fileMapStorage = new FileMapStorage();
        BufferResource<ByteBuffer> bufferResource = this.getReadBuffer(0, this.size);
        try {
            fileMapStorage.write(bufferResource.getBuffer());
            FileMapStorage fileMapStorage2 = fileMapStorage;
            return fileMapStorage2;
        }
        finally {
            if (bufferResource != null) {
                bufferResource.releaseBuffer();
            }
        }
    }

    @Override
    public BufferResource<ByteBuffer> getReadBuffer(int n, int n2) throws IOException {
        return new HeapBufferResource(ByteBuffer.wrap(this.bytes, n, Math.min(n2, this.bytes.length - n)));
    }

    @Override
    public ByteBuffer getWriteBuffer(int n) throws IOException {
        return ByteBuffer.allocate(n);
    }

    @Override
    public synchronized int write(ByteBuffer byteBuffer) throws IOException {
        this.closed = false;
        int n = this.size;
        this.size += byteBuffer.limit();
        if (this.size > this.bytes.length) {
            byte[] byArray = this.bytes;
            this.bytes = new byte[Math.max(n * 2, byteBuffer.limit() * 2 + n)];
            System.arraycopy(byArray, 0, this.bytes, 0, n);
        }
        byteBuffer.flip();
        byteBuffer.get(this.bytes, n, byteBuffer.limit());
        return n;
    }

    @Override
    public void removeBytesFromEnd(int n) throws IOException {
        this.size -= n;
    }

    @Override
    public synchronized void dispose() {
        this.bytes = new byte[0];
        this.size = 0;
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void shiftStart(int n) {
        this.size -= n;
        System.arraycopy(this.bytes, n, this.bytes, 0, this.size);
    }

    private class HeapBufferResource
    implements BufferResource<ByteBuffer> {
        private ByteBuffer buffer;

        public HeapBufferResource(ByteBuffer byteBuffer) {
            this.buffer = byteBuffer;
        }

        @Override
        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void releaseBuffer() {
            this.buffer = null;
        }
    }
}

