/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer {
    private static final Attributes EMPTY_ATTS = new AttributesImpl();
    private final TransformerHandler transformer;
    private OutputStream outStream;
    private Writer outWriter;
    private final LinkedList<QName> elementStack = new LinkedList();
    private AttributesImpl openAttributes;
    private boolean openStartElement;

    private XMLSerializer(OutputStream out) {
        this.outStream = out;
        this.transformer = this.initializeTransformerHandler();
        this.transformer.setResult(new StreamResult(out));
    }

    private XMLSerializer(Writer out) {
        this.outWriter = out;
        this.transformer = this.initializeTransformerHandler();
        this.transformer.setResult(new StreamResult(out));
    }

    private TransformerHandler initializeTransformerHandler() throws TransformerFactoryConfigurationError {
        TransformerFactory tf = TransformerFactory.newInstance();
        if (tf.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            SAXTransformerFactory stf = (SAXTransformerFactory)tf;
            try {
                return stf.newTransformerHandler();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Unable to create an XML serializer: " + e.getMessage(), e);
            }
        }
        throw new RuntimeException("Unable to create an XML serializer: transformer factor does not support transformer handler");
    }

    public static XMLSerializer newInstance(OutputStream out) {
        return new XMLSerializer(out);
    }

    public static XMLSerializer newInstance(Writer out) {
        return new XMLSerializer(out);
    }

    public TransformerHandler getTransformerHandler() {
        return this.transformer;
    }

    public void close() throws IOException {
        if (this.outStream == null && this.outWriter == null) {
            throw new IllegalStateException();
        }
        if (this.outStream != null) {
            this.outStream.close();
        }
        if (this.outWriter != null) {
            this.outWriter.close();
        }
    }

    public void writeStartDocument() throws SAXException {
        this.transformer.startDocument();
    }

    public void writeEndDocument() throws SAXException {
        while (!this.elementStack.isEmpty()) {
            this.writeEndElement();
        }
        this.transformer.endDocument();
    }

    public void writeStartElement(String qName) throws SAXException {
        this.writeStartElement(null, qName);
    }

    public void writeStartElement(String uri, String qName) throws SAXException {
        this.processStartElement();
        QName res = new QName(uri, qName);
        this.addNamespace(res.uri, res.prefix, res);
        this.elementStack.addFirst(res);
        this.openStartElement = true;
    }

    public void writeNamespace(String prefix, String uri) {
        if (!this.openStartElement) {
            throw new IllegalStateException("Current state does not allow Namespace writing");
        }
        QName qName = this.elementStack.getFirst();
        for (NamespaceMapping p : qName.mappings) {
            if (p.prefix.equals(prefix) && p.uri.equals(uri)) {
                return;
            }
            if (!p.prefix.equals(prefix)) continue;
            throw new IllegalArgumentException("Prefix " + prefix + " already bound to " + uri);
        }
        qName.mappings.add(new NamespaceMapping(prefix, uri, true));
    }

    public void writeAttribute(String qName, String value) {
        this.writeAttribute("", qName, value);
    }

    public void writeAttribute(String uri, String qName, String value) {
        if (!this.openStartElement) {
            throw new IllegalStateException("Current state does not allow Attribute writing");
        }
        if (this.openAttributes == null) {
            this.openAttributes = new AttributesImpl();
        }
        QName att = new QName(uri, qName);
        this.addNamespace(uri, att.prefix, this.elementStack.getFirst());
        this.openAttributes.addAttribute(uri, att.localName, qName, "CDATA", value);
    }

    public void writeEndElement() throws SAXException {
        this.processStartElement();
        QName qName = this.elementStack.remove();
        this.transformer.endElement(qName.uri, qName.localName, qName.qName);
        for (NamespaceMapping p : qName.mappings) {
            if (!p.newMapping) continue;
            this.transformer.endPrefixMapping(p.prefix);
        }
    }

    public void writeCharacters(String text) throws SAXException {
        if (this.elementStack.isEmpty()) {
            throw new IllegalStateException("Current state does not allow Character writing");
        }
        char[] ch = text.toCharArray();
        this.writeCharacters(ch, 0, ch.length);
    }

    public void writeCharacters(char[] ch, int start, int length) throws SAXException {
        if (this.elementStack.isEmpty()) {
            throw new IllegalStateException("Current state does not allow Character writing");
        }
        this.processStartElement();
        this.transformer.characters(ch, start, length);
    }

    public void writeProcessingInstruction(String target, String data) throws SAXException {
        this.processStartElement();
        this.transformer.processingInstruction(target, data != null ? data : "");
    }

    public void writeComment(String data) throws SAXException {
        this.processStartElement();
        char[] ch = data.toCharArray();
        this.transformer.comment(ch, 0, ch.length);
    }

    private void processStartElement() throws SAXException {
        if (this.openStartElement) {
            QName qName = this.elementStack.getFirst();
            for (NamespaceMapping p : qName.mappings) {
                if (!p.newMapping) continue;
                this.transformer.startPrefixMapping(p.prefix, p.uri);
            }
            Attributes atts = this.openAttributes != null ? this.openAttributes : EMPTY_ATTS;
            this.transformer.startElement(qName.uri, qName.localName, qName.qName, atts);
            this.openStartElement = false;
            this.openAttributes = null;
        }
    }

    private void addNamespace(String uri, String prefix, QName current) {
        if (uri != null && uri.equals("") && !prefix.equals("")) {
            throw new IllegalArgumentException("Undeclaring prefix " + prefix + " not allowed");
        }
        if (uri != null) {
            boolean found = false;
            block0: for (QName e : this.elementStack) {
                for (NamespaceMapping m : e.mappings) {
                    if (m.uri.equals(uri) && m.prefix.equals(prefix)) {
                        found = true;
                        break block0;
                    }
                    if (!m.prefix.equals(prefix)) continue;
                    break block0;
                }
            }
            if (!found && uri.equals("") && prefix.equals("")) {
                return;
            }
            current.mappings.add(new NamespaceMapping(prefix, uri, !found));
        }
    }

    private static final class QName {
        final String uri;
        final String localName;
        final String prefix;
        final String qName;
        final List<NamespaceMapping> mappings;

        QName(String uri, String qName) {
            int i = qName.indexOf(58);
            this.uri = uri != null ? uri : "";
            this.localName = i != -1 ? qName.substring(i + 1) : qName;
            this.prefix = i != -1 ? qName.substring(0, i) : "";
            this.qName = qName;
            this.mappings = new ArrayList<NamespaceMapping>(5);
        }
    }

    private record NamespaceMapping(String prefix, String uri, boolean newMapping) {
    }
}

