"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveModuleName = resolveModuleName;
function resolveModuleName(ts, languageServiceHost, fileName, moduleName) {
    const compilerOptions = languageServiceHost.getCompilationSettings();
    const ext = moduleName.split('.').pop();
    const result = ts.resolveModuleName(moduleName, fileName, {
        ...compilerOptions,
        allowArbitraryExtensions: true,
    }, {
        fileExists(fileName) {
            fileName = transformFileName(fileName, ext);
            return languageServiceHost.fileExists(fileName);
        },
    });
    const resolveFileName = result.resolvedModule?.resolvedFileName;
    if (resolveFileName) {
        return transformFileName(resolveFileName, ext);
    }
}
function transformFileName(fileName, ext) {
    if (ext && fileName.endsWith(`.d.${ext}.ts`)) {
        return fileName.slice(0, -`.d.${ext}.ts`.length) + `.${ext}`;
    }
    return fileName;
}
//# sourceMappingURL=resolveModuleName.js.map