"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.startLanguageServer = exports.createConnection = exports.createFs = exports.fileNameToUri = exports.uriToFileName = void 0;
const fs = require("fs");
const vscode = require("vscode-languageserver/node");
const vscode_uri_1 = require("vscode-uri");
const http_1 = require("./lib/common/schemaRequestHandlers/http");
const server_1 = require("./lib/common/server");
const language_service_1 = require("@volar/language-service");
const cancellationPipe_1 = require("./lib/node/cancellationPipe");
__exportStar(require("./index"), exports);
const uriToFileName = (uri) => vscode_uri_1.URI.parse(uri).fsPath.replace(/\\/g, '/');
exports.uriToFileName = uriToFileName;
const fileNameToUri = (fileName) => vscode_uri_1.URI.file(fileName).toString();
exports.fileNameToUri = fileNameToUri;
function createFs(options) {
    return {
        stat(uri) {
            if (uri.startsWith('file://')) {
                try {
                    const stats = fs.statSync((0, exports.uriToFileName)(uri), { throwIfNoEntry: false });
                    if (stats) {
                        return {
                            type: stats.isFile() ? language_service_1.FileType.File
                                : stats.isDirectory() ? language_service_1.FileType.Directory
                                    : stats.isSymbolicLink() ? language_service_1.FileType.SymbolicLink
                                        : language_service_1.FileType.Unknown,
                            ctime: stats.ctimeMs,
                            mtime: stats.mtimeMs,
                            size: stats.size,
                        };
                    }
                }
                catch {
                    return undefined;
                }
            }
        },
        readFile(uri, encoding) {
            if (uri.startsWith('file://')) {
                try {
                    if (options.maxFileSize) {
                        const stats = fs.statSync((0, exports.uriToFileName)(uri), { throwIfNoEntry: false });
                        if (stats && stats.size > options.maxFileSize) {
                            console.warn(`[volar] file size exceeded limit: ${uri} (${stats.size} > ${options.maxFileSize})`);
                            return undefined;
                        }
                    }
                    return fs.readFileSync((0, exports.uriToFileName)(uri), { encoding: encoding ?? 'utf-8' });
                }
                catch {
                    return undefined;
                }
            }
            if (uri.startsWith('http://') || uri.startsWith('https://')) {
                return (0, http_1.default)(uri);
            }
        },
        readDirectory(uri) {
            if (uri.startsWith('file://')) {
                try {
                    const dirName = (0, exports.uriToFileName)(uri);
                    const files = fs.readdirSync(dirName, { withFileTypes: true });
                    return files.map(file => {
                        return [file.name, file.isFile() ? language_service_1.FileType.File
                                : file.isDirectory() ? language_service_1.FileType.Directory
                                    : file.isSymbolicLink() ? language_service_1.FileType.SymbolicLink
                                        : language_service_1.FileType.Unknown];
                    });
                }
                catch {
                    return [];
                }
            }
            return [];
        },
    };
}
exports.createFs = createFs;
function createConnection() {
    return vscode.createConnection(vscode.ProposedFeatures.all);
}
exports.createConnection = createConnection;
function startLanguageServer(connection, ...plugins) {
    (0, server_1.startCommonLanguageServer)(connection, plugins, (_, options) => ({
        uriToFileName: exports.uriToFileName,
        fileNameToUri: exports.fileNameToUri,
        console: connection.console,
        timer: {
            setImmediate(callback, ...args) {
                const handle = setImmediate(callback, ...args);
                return { dispose: () => clearImmediate(handle) };
            },
        },
        loadTypeScript(options) {
            const tsdk = options.typescript && 'tsdk' in options.typescript
                ? options.typescript.tsdk
                : undefined;
            if (!tsdk) {
                return;
            }
            for (const name of ['./typescript.js', './tsserverlibrary.js']) {
                try {
                    return require(require.resolve(name, { paths: [tsdk] }));
                }
                catch { }
            }
            // for bun
            for (const name of ['typescript.js', 'tsserverlibrary.js']) {
                try {
                    return require(tsdk + '/' + name);
                }
                catch { }
            }
            throw new Error(`Can't find typescript.js or tsserverlibrary.js in ${tsdk}`);
        },
        async loadTypeScriptLocalized(options, locale) {
            const tsdk = options.typescript && 'tsdk' in options.typescript
                ? options.typescript.tsdk
                : undefined;
            if (!tsdk) {
                return;
            }
            try {
                const path = require.resolve(`./${locale}/diagnosticMessages.generated.json`, { paths: [tsdk] });
                return require(path);
            }
            catch { }
        },
        fs: createFs(options),
        getCancellationToken: (0, cancellationPipe_1.createGetCancellationToken)(options.cancellationPipeName),
    }));
}
exports.startLanguageServer = startLanguageServer;
//# sourceMappingURL=node.js.map