/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.debug.node.NodeRunDebugLaunchShortcut;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.eclipse.wildwebdeveloper.tests.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestDebug {
    protected ILaunchManager launchManager;

    @BeforeEach
    public void setUpLaunch() throws DebugException {
        this.launchManager = DebugPlugin.getDefault().getLaunchManager();
        this.removeAllLaunches();
        ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.debug.ui");
        prefs.setValue("org.eclipse.debug.ui.switch_perspective_on_suspend", "always");
    }

    private void removeAllLaunches() throws DebugException {
        ILaunch[] iLaunchArray = this.launchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            try {
                launch.terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
            int n3 = iDebugTargetArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IDebugTarget debugTarget = iDebugTargetArray[n4];
                try {
                    debugTarget.terminate();
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
                launch.removeDebugTarget(debugTarget);
                ++n4;
            }
            iDebugTargetArray = launch.getProcesses();
            n3 = iDebugTargetArray.length;
            n4 = 0;
            while (n4 < n3) {
                IDebugTarget process2 = iDebugTargetArray[n4];
                process2.terminate();
                ++n4;
            }
            ProcessHandle.current().descendants().filter(process -> process.info().commandLine().filter(command -> command.contains("node") && command.contains("debug")).isPresent()).forEach(ProcessHandle::destroyForcibly);
            this.launchManager.removeLaunch(launch);
            ++n2;
        }
    }

    @AfterEach
    public void tearDownLaunch() throws DebugException {
        this.removeAllLaunches();
    }

    @Test
    public void testRunExpandEnv() throws Exception {
        File f = File.createTempFile("testEnv", ".js");
        f.deleteOnExit();
        Files.write(f.toPath(), "console.log(process.env.ECLIPSE_HOME);".getBytes(), new OpenOption[0]);
        ILaunchConfigurationWorkingCopy launchConfig = this.launchManager.getLaunchConfigurationType("org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebug").newInstance((IContainer)ResourcesPlugin.getWorkspace().getRoot(), f.getName());
        launchConfig.setAttribute("program", f.getAbsolutePath());
        launchConfig.setAttribute(LaunchManager.ATTR_ENVIRONMENT_VARIABLES, Map.of("ECLIPSE_HOME", "${eclipse_home}"));
        launchConfig.setAttribute("org.eclipse.debug.core.capture_output", true);
        ILaunch launch = launchConfig.launch("run", (IProgressMonitor)new NullProgressMonitor());
        while (!launch.isTerminated()) {
            DisplayHelper.sleep((Display)Display.getDefault(), (long)50L);
        }
        Assertions.assertFalse((boolean)DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)1000L, () -> Arrays.stream(ConsolePlugin.getDefault().getConsoleManager().getConsoles()).filter(IOConsole.class::isInstance).map(IOConsole.class::cast).map(TextConsole::getDocument).map(IDocument::get).anyMatch(content -> content.contains("${eclipse_home}"))), (String)"env variable is not replaced in subprocess");
    }

    @Test
    public void testRunExpandDebugVars() throws Exception {
        IProject project = Utils.provisionTestProject("helloWorldJS");
        IFile f = project.getFile("hello.js");
        ILaunchConfigurationWorkingCopy launchConfig = this.launchManager.getLaunchConfigurationType("org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebug").newInstance((IContainer)ResourcesPlugin.getWorkspace().getRoot(), f.getName());
        launchConfig.setAttribute("program", "${workspace_loc:" + String.valueOf(f.getFullPath()) + "}");
        launchConfig.setAttribute("org.eclipse.debug.core.capture_output", true);
        ILaunch launch = launchConfig.launch("run", (IProgressMonitor)new NullProgressMonitor());
        while (!launch.isTerminated()) {
            DisplayHelper.sleep((Display)Display.getDefault(), (long)50L);
        }
        Assertions.assertTrue((boolean)DisplayHelper.waitForCondition((Display)Display.getDefault(), (long)1000L, () -> Arrays.stream(ConsolePlugin.getDefault().getConsoleManager().getConsoles()).filter(IOConsole.class::isInstance).map(IOConsole.class::cast).map(TextConsole::getDocument).map(IDocument::get).anyMatch(content -> content.contains("Hello"))), (String)"Missing log output");
    }

    @Test
    public void testFindThreadsAndHitsBreakpoint() throws Exception {
        IProject project = Utils.provisionTestProject("helloWorldJS");
        IFile jsFile = project.getFile("hello.js");
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)jsFile);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        TextSelection selection = new TextSelection(doc, doc.getLineOffset(1) + 1, 0);
        IToggleBreakpointsTarget toggleBreakpointsTarget = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget((IWorkbenchPart)editor, (ISelection)selection);
        toggleBreakpointsTarget.toggleLineBreakpoints((IWorkbenchPart)editor, (ISelection)selection);
        final HashSet<IDebugTarget> before = new HashSet<IDebugTarget>(Arrays.asList(this.launchManager.getDebugTargets()));
        DisplayHelper.sleep((long)1000L);
        new NodeRunDebugLaunchShortcut().launch((IEditorPart)editor, "debug");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            public boolean condition() {
                return TestDebug.this.launchManager.getDebugTargets().length > before.size();
            }
        }.waitForCondition(Display.getDefault(), 30000L), (String)"New Debug Target not created");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            public boolean condition() {
                try {
                    return TestDebug.this.debugTargetWithThreads(before) != null;
                }
                catch (DebugException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 30000L), (String)"Debug Target shows no threads");
        final IDebugTarget target = this.debugTargetWithThreads(before);
        Assertions.assertTrue((boolean)new DisplayHelper(){

            public boolean condition() {
                try {
                    return Arrays.stream(target.getThreads()).anyMatch(ISuspendResume::isSuspended);
                }
                catch (DebugException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 3000L), (String)"No thread is suspended");
        final IThread suspendedThread = Arrays.stream(target.getThreads()).filter(ISuspendResume::isSuspended).findFirst().get();
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return suspendedThread.getStackFrames().length > 0 && suspendedThread.getStackFrames()[0].getVariables().length > 0;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 3000L), (String)"Suspended Thread doesn't show variables");
        IVariable localVariable = suspendedThread.getStackFrames()[0].getVariables()[0];
        Assertions.assertEquals((Object)"Local", (Object)localVariable.getName());
        IVariable nVariable = Arrays.stream(localVariable.getValue().getVariables()).filter(var -> {
            try {
                return "n".equals(var.getName());
            }
            catch (DebugException e) {
                return false;
            }
        }).findAny().get();
        Assertions.assertEquals((Object)"1605", (Object)nVariable.getValue().getValueString());
    }

    private IDebugTarget debugTargetWithThreads(Collection<IDebugTarget> toExclude) throws DebugException {
        HashSet<IDebugTarget> current = new HashSet<IDebugTarget>(Arrays.asList(this.launchManager.getDebugTargets()));
        current.removeAll(toExclude);
        for (IDebugTarget target : current) {
            if (target.getThreads().length <= 0) continue;
            return target;
        }
        return null;
    }

    @Test
    public void testFindThreadsAndHitsBreakpointTypeScript() throws Exception {
        IProject project = Utils.provisionTestProject("HelloWorldTS");
        IFile tsFile = project.getFile("index.ts");
        ITextEditor editor = (ITextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)tsFile);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        TextSelection selection = new TextSelection(doc, doc.getLineOffset(2) + 1, 0);
        IToggleBreakpointsTarget toggleBreakpointsTarget = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget((IWorkbenchPart)editor, (ISelection)selection);
        toggleBreakpointsTarget.toggleLineBreakpoints((IWorkbenchPart)editor, (ISelection)selection);
        final HashSet<IDebugTarget> before = new HashSet<IDebugTarget>(Arrays.asList(this.launchManager.getDebugTargets()));
        DisplayHelper.sleep((long)1000L);
        new NodeRunDebugLaunchShortcut().launch((IEditorPart)editor, "debug");
        Assertions.assertTrue((boolean)new DisplayHelper(){

            public boolean condition() {
                try {
                    return TestDebug.this.debugTargetWithThreads(before) != null;
                }
                catch (DebugException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 30000L), (String)"Debug Target shows no threads");
        final IDebugTarget target = this.debugTargetWithThreads(before);
        Assertions.assertTrue((boolean)new DisplayHelper(){

            public boolean condition() {
                try {
                    return Arrays.stream(target.getThreads()).anyMatch(ISuspendResume::isSuspended);
                }
                catch (DebugException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 3000L), (String)"No thread is suspended");
        final IThread suspendedThread = Arrays.stream(target.getThreads()).filter(ISuspendResume::isSuspended).findFirst().get();
        Assertions.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                try {
                    return suspendedThread.getStackFrames().length > 0 && suspendedThread.getStackFrames()[0].getVariables().length > 0;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 3000L), (String)"Suspended Thread doesn't show variables");
        IVariable closureVar = null;
        IVariable[] iVariableArray = suspendedThread.getStackFrames()[0].getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable variable = iVariableArray[n2];
            if ("Closure".equals(variable.getName())) {
                closureVar = variable;
            }
            ++n2;
        }
        IVariable userVariable = null;
        IVariable[] iVariableArray2 = closureVar.getValue().getVariables();
        int n3 = iVariableArray2.length;
        n = 0;
        while (n < n3) {
            IVariable variable = iVariableArray2[n];
            if ("user".equals(variable.getName())) {
                userVariable = variable;
            }
            ++n;
        }
        Assertions.assertEquals((Object)"'Eclipse User'", (Object)userVariable.getValue().getValueString());
    }
}

