/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.documentLink;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class LSPDocumentLinkPresentationReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextViewer viewer;
    private CompletableFuture<Void> request;
    private IDocument document;

    public void install(@Nullable ITextViewer viewer) {
        this.viewer = viewer;
    }

    public void uninstall() {
        this.viewer = null;
        this.cancel();
    }

    private void underline() {
        if (this.viewer == null) {
            return;
        }
        IDocument document = this.viewer.getDocument();
        if (document == null) {
            return;
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return;
        }
        this.cancel();
        DocumentLinkParams params = new DocumentLinkParams(new TextDocumentIdentifier(uri.toString()));
        this.request = LanguageServiceAccessor.getLanguageServers(document, capabilities -> capabilities.getDocumentLinkProvider() != null).thenAcceptAsync(languageServers -> {
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf((CompletableFuture[])languageServers.stream().map(languageServer -> languageServer.getTextDocumentService().documentLink(params)).map(request -> request.thenAcceptAsync(links -> {
                StyledText control = this.viewer.getTextWidget();
                if (control != null) {
                    control.getDisplay().asyncExec(() -> this.underline((List<DocumentLink>)links));
                }
            })).toArray(CompletableFuture[]::new));
        });
    }

    private void underline(List<DocumentLink> links) {
        if (this.document == null || links == null) {
            return;
        }
        for (DocumentLink link : links) {
            try {
                TextPresentation presentation;
                int start = LSPEclipseUtils.toOffset(link.getRange().getStart(), this.document);
                int end = LSPEclipseUtils.toOffset(link.getRange().getEnd(), this.document);
                int length = end - start;
                Region linkRegion = new Region(start, length);
                StyleRange styleRange = null;
                StyleRange[] styleRanges = this.viewer.getTextWidget().getStyleRanges(start, length);
                if (styleRanges != null && styleRanges.length > 0) {
                    StyleRange[] styleRangeArray = styleRanges;
                    int n = styleRanges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StyleRange s = styleRangeArray[n2];
                        s.underline = true;
                        ++n2;
                    }
                    presentation = new TextPresentation((IRegion)linkRegion, 100);
                    presentation.replaceStyleRanges(styleRanges);
                    this.viewer.changeTextPresentation(presentation, false);
                    continue;
                }
                styleRange = new StyleRange();
                styleRange.underline = true;
                styleRange.start = start;
                styleRange.length = length;
                presentation = new TextPresentation((IRegion)linkRegion, 100);
                presentation.replaceStyleRange(styleRange);
                this.viewer.changeTextPresentation(presentation, false);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public void initialReconcile() {
        this.underline();
    }

    private void cancel() {
        if (this.request != null) {
            this.request.cancel(true);
            this.request = null;
        }
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
        this.underline();
    }
}

