/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.driver;

import java.util.ArrayList;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.internal.driver.AbstractDTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.CatalogStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapterFactory;
import org.eclipse.jpt.jpa.db.internal.driver.FoldingStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.UnknownCatalogStrategy;
import org.eclipse.jpt.jpa.db.internal.driver.UpperCaseFoldingStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HSQLDB
extends AbstractDTPDriverAdapter {
    private static final String PUBLIC_SCHEMA_NAME = "PUBLIC";

    HSQLDB(Database database) {
        super(database);
    }

    @Override
    CatalogStrategy buildCatalogStrategy() {
        return new UnknownCatalogStrategy(this.database.getDTPDatabase());
    }

    @Override
    FoldingStrategy buildFoldingStrategy() {
        return UpperCaseFoldingStrategy.instance();
    }

    @Override
    void addDefaultSchemaNamesTo(ArrayList<String> names) {
        names.add(PUBLIC_SCHEMA_NAME);
    }

    static class Factory
    implements DTPDriverAdapterFactory {
        private static final String[] VENDORS = new String[]{"HSQLDB"};

        Factory() {
        }

        public String[] getSupportedVendors() {
            return VENDORS;
        }

        public DTPDriverAdapter buildAdapter(Database database) {
            return new HSQLDB(database);
        }
    }
}

