/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLTemplateCompletionProcessor;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;
import org.eclipse.wst.xml.ui.internal.templates.TemplateContextTypeIdsXML;

public class XMLContentAssistProcessor
extends AbstractContentAssistProcessor
implements IPropertyChangeListener {
    protected IPreferenceStore fPreferenceStore = null;
    protected IResource fResource = null;
    private XMLTemplateCompletionProcessor fTemplateProcessor = null;
    private List fTemplateContexts = new ArrayList();

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXML.ATTRIBUTE);
        super.addAttributeNameProposals(contentAssistRequest);
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXML.ATTRIBUTE_VALUE);
        super.addAttributeValueProposals(contentAssistRequest);
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXML.NEW);
        super.addEmptyDocumentProposals(contentAssistRequest);
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsXML.TAG);
        super.addTagInsertionProposals(contentAssistRequest, childPosition);
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String context) {
        this.addTemplates(contentAssistRequest, context, contentAssistRequest.getReplacementBeginPosition());
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String context, int startOffset) {
        if (contentAssistRequest == null) {
            return;
        }
        if (!this.fTemplateContexts.contains(context)) {
            boolean useProposalList;
            this.fTemplateContexts.add(context);
            boolean bl = useProposalList = !contentAssistRequest.shouldSeparate();
            if (this.getTemplateCompletionProcessor() != null) {
                this.getTemplateCompletionProcessor().setContextType(context);
                ICompletionProposal[] proposals = this.getTemplateCompletionProcessor().computeCompletionProposals(this.fTextViewer, startOffset);
                int i = 0;
                while (i < proposals.length) {
                    if (useProposalList) {
                        contentAssistRequest.addProposal(proposals[i]);
                    } else {
                        contentAssistRequest.addMacro(proposals[i]);
                    }
                    ++i;
                }
            }
        }
    }

    protected ContentAssistRequest computeCompletionProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode treeNode, IDOMNode xmlnode) {
        ContentAssistRequest request = super.computeCompletionProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
        this.addTemplates(request, TemplateContextTypeIdsXML.ALL, documentPosition);
        return request;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        this.fTemplateContexts.clear();
        return super.computeCompletionProposals(textViewer, documentPosition);
    }

    protected IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            this.fPreferenceStore = XMLUIPlugin.getDefault().getPreferenceStore();
        }
        return this.fPreferenceStore;
    }

    private XMLTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new XMLTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }

    protected void init() {
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.reinit();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.compareTo(XMLUIPreferenceNames.AUTO_PROPOSE) == 0 || property.compareTo(XMLUIPreferenceNames.AUTO_PROPOSE_CODE) == 0) {
            this.reinit();
        }
    }

    protected void reinit() {
        String key = XMLUIPreferenceNames.AUTO_PROPOSE;
        boolean doAuto = this.getPreferenceStore().getBoolean(key);
        if (doAuto) {
            key = XMLUIPreferenceNames.AUTO_PROPOSE_CODE;
            this.completionProposalAutoActivationCharacters = this.getPreferenceStore().getString(key).toCharArray();
        } else {
            this.completionProposalAutoActivationCharacters = null;
        }
    }

    public void release() {
        super.release();
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

