/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.internal.xml;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.internal.core.util.ExtensionPointUtil;
import org.eclipse.jst.server.generic.internal.servertype.definition.util.ServerTypeResourceFactoryImpl;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.osgi.framework.Bundle;

public class XMLUtils {
    private ArrayList<ServerRuntime> serverDefinitions;
    private ArrayList<ServerRuntime> runtimeDefinitions;

    public XMLUtils() {
        this.refresh();
    }

    private void refresh() {
        this.serverDefinitions = new ArrayList();
        IExtension[] serverDefExtensions = ExtensionPointUtil.getGenericServerDefinitionExtensions();
        int i = 0;
        while (serverDefExtensions != null && i < serverDefExtensions.length) {
            java.net.URI definitionFile = null;
            IExtension extension = serverDefExtensions[i];
            IConfigurationElement[] elements = ExtensionPointUtil.getConfigurationElements(extension);
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                definitionFile = this.getDefinitionFile(element);
                ServerRuntime runtime = this.readFile(definitionFile);
                if (runtime != null) {
                    runtime.setId(element.getAttribute("id"));
                    runtime.setConfigurationElementNamespace(element.getNamespaceIdentifier());
                    this.serverDefinitions.add(runtime);
                }
                ++j;
            }
            ++i;
        }
        this.runtimeDefinitions = new ArrayList();
        IExtension[] runtimeDefExtensions = ExtensionPointUtil.getGenericServerRuntimeDefinitionExtensions();
        int i2 = 0;
        while (runtimeDefExtensions != null && i2 < runtimeDefExtensions.length) {
            java.net.URI definitionFile = null;
            IExtension extension = runtimeDefExtensions[i2];
            IConfigurationElement[] elements = ExtensionPointUtil.getConfigurationElements(extension);
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                definitionFile = this.getDefinitionFile(element);
                ServerRuntime runtime = this.readFile(definitionFile);
                if (runtime != null) {
                    runtime.setId(element.getAttribute("id"));
                    runtime.setConfigurationElementNamespace(element.getNamespaceIdentifier());
                    this.runtimeDefinitions.add(runtime);
                }
                ++j;
            }
            ++i2;
        }
    }

    private java.net.URI getDefinitionFile(IConfigurationElement element) {
        Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
        String definitionFile = element.getAttribute("definitionfile");
        Trace.trace((byte)3, "Loading serverdef file " + definitionFile + " from bundle " + bundle.getSymbolicName());
        URL url = bundle.getEntry(definitionFile);
        if (url == null) {
            CorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.server.generic.core", 1, "Definition file " + definitionFile + " can not be resolved in bundle " + bundle.getSymbolicName(), null));
            return null;
        }
        try {
            java.net.URI uri = new java.net.URI(url.toExternalForm());
            return uri;
        }
        catch (URISyntaxException e) {
            CorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.server.generic.core", 1, "Error loading the definition file", (Throwable)e));
            return null;
        }
    }

    private ServerRuntime readFile(java.net.URI file) {
        ServerRuntime def;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ServerTypeResourceFactoryImpl());
        URI fileURI = URI.createURI((String)file.toString());
        Resource resource = null;
        try {
            resource = resourceSet.getResource(fileURI, true);
        }
        catch (WrappedException e) {
            CorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.server.generic.core", 1, "Error loading the server type definition", (Throwable)e));
        }
        if (resource != null && (def = (ServerRuntime)resource.getContents().get(0)) != null) {
            def.setFilename(file.toString());
            return def;
        }
        return null;
    }

    public List getServerTypeDefinitions() {
        return this.serverDefinitions;
    }

    public ServerRuntime getServerTypeDefinition(String id) {
        Iterator defs = this.getServerTypeDefinitions().iterator();
        while (id != null && defs.hasNext()) {
            ServerRuntime elem = (ServerRuntime)defs.next();
            if (!elem.getId().equals(id)) continue;
            return elem;
        }
        return null;
    }

    public List getRuntimeTypeDefinitions() {
        return this.runtimeDefinitions;
    }

    public ServerRuntime getRuntimeTypeDefinition(String id) {
        for (ServerRuntime elem : this.getRuntimeTypeDefinitions()) {
            if (!elem.getId().equals(id)) continue;
            return elem;
        }
        return null;
    }
}

