/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.binary;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.resource.java.binary.BinaryNode;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NestableAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryAnnotatedElement
extends BinaryNode
implements JavaResourceAnnotatedElement {
    final Adapter adapter;
    final Vector<Annotation> annotations = new Vector();
    private final HashMap<String, Annotation> nullAnnotationsCache = new HashMap();
    private static final IAnnotation[] EMPTY_JDT_ANNOTATION_ARRAY = new IAnnotation[0];

    public BinaryAnnotatedElement(JavaResourceNode parent, Adapter adapter) {
        super(parent);
        this.adapter = adapter;
        this.initializeAnnotations();
    }

    private void initializeAnnotations() {
        IAnnotation[] iAnnotationArray = this.getJdtAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            this.addAnnotation(annotation);
            ++n2;
        }
    }

    private void addAnnotation(IAnnotation jdtAnnotation) {
        if (this.annotationIsValid(jdtAnnotation)) {
            this.annotations.add(this.buildAnnotation(jdtAnnotation));
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateAnnotations();
    }

    private void updateAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Annotation> annotations() {
        return this.getAnnotations().iterator();
    }

    private Iterable<Annotation> getAnnotations() {
        return new LiveCloneIterable(this.annotations);
    }

    @Override
    public int annotationsSize() {
        return this.annotations.size();
    }

    @Override
    public Annotation getAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getAnnotations(), annotationName);
    }

    @Override
    public Annotation getNonNullAnnotation(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        return annotation != null ? annotation : this.getNullAnnotation(annotationName);
    }

    private synchronized Annotation getNullAnnotation(String annotationName) {
        Annotation annotation = this.nullAnnotationsCache.get(annotationName);
        if (annotation == null) {
            annotation = this.buildNullAnnotation(annotationName);
            this.nullAnnotationsCache.put(annotationName, annotation);
        }
        return annotation;
    }

    @Override
    public Iterator<NestableAnnotation> annotations(String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return containerAnnotation.getNestedAnnotations().iterator();
        }
        NestableAnnotation nestableAnnotation = this.getNestableAnnotation(nestableAnnotationName);
        return nestableAnnotation == null ? EmptyListIterator.instance() : new SingleElementIterator((Object)nestableAnnotation);
    }

    private NestableAnnotation getNestableAnnotation(String annotationName) {
        return (NestableAnnotation)this.getAnnotation(annotationName);
    }

    private ContainerAnnotation<NestableAnnotation> getContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.getAnnotation(annotationName);
    }

    private boolean annotationIsValid(IAnnotation jdtAnnotation) {
        return CollectionTools.contains(this.validAnnotationNames(), (Object)jdtAnnotation.getElementName());
    }

    abstract Iterator<String> validAnnotationNames();

    abstract Annotation buildAnnotation(IAnnotation var1);

    abstract Annotation buildNullAnnotation(String var1);

    @Override
    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    IJavaElement getAnnotatedElement() {
        return this.adapter.getElement();
    }

    private Annotation selectAnnotationNamed(Iterable<Annotation> annotationList, String annotationName) {
        for (Annotation annotation : annotationList) {
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    private IAnnotation[] getJdtAnnotations() {
        try {
            return this.adapter.getAnnotations();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return EMPTY_JDT_ANNOTATION_ARRAY;
        }
    }

    @Override
    public Annotation addAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NestableAnnotation addAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveAnnotation(int targetIndex, int sourceIndex, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addStandAloneAnnotation(NestableAnnotation standAloneAnnotation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    static interface Adapter {
        public IJavaElement getElement();

        public IAnnotation[] getAnnotations() throws JavaModelException;
    }
}

