/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Map;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNamedColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceDiscriminatorColumnAnnotation
extends SourceNamedColumnAnnotation
implements DiscriminatorColumnAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.DiscriminatorColumn");
    private static final DeclarationAnnotationElementAdapter<String> DISCRIMINATOR_TYPE_DECLARATION_ADAPTER = SourceDiscriminatorColumnAnnotation.buildDiscriminatorTypeDeclarationAdapter();
    private AnnotationElementAdapter<String> discriminatorTypeAdapter = this.buildDiscriminatorTypeAdapter();
    private DiscriminatorType discriminatorType;
    private DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter = this.buildLengthDeclarationAdapter();
    private AnnotationElementAdapter<Integer> lengthAdapter = this.buildLengthAdapter();
    private Integer length;

    public SourceDiscriminatorColumnAnnotation(JavaResourcePersistentType parent, Type type) {
        super((JavaResourceNode)parent, (Member)type, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.DiscriminatorColumn";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.discriminatorType = this.buildDiscriminatorType(astRoot);
        this.length = this.buildLength(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncLength(this.buildLength(astRoot));
        this.syncDiscriminatorType(this.buildDiscriminatorType(astRoot));
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    protected String getColumnDefinitionElementName() {
        return "columnDefinition";
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public void setDiscriminatorType(DiscriminatorType discriminatorType) {
        if (this.attributeValueHasChanged((Object)this.discriminatorType, (Object)discriminatorType)) {
            this.discriminatorType = discriminatorType;
            this.discriminatorTypeAdapter.setValue((Object)DiscriminatorType.toJavaAnnotationValue(discriminatorType));
        }
    }

    private void syncDiscriminatorType(DiscriminatorType astDiscriminatorType) {
        DiscriminatorType old = this.discriminatorType;
        this.discriminatorType = astDiscriminatorType;
        this.firePropertyChanged("discriminatorType", (Object)old, (Object)astDiscriminatorType);
    }

    private DiscriminatorType buildDiscriminatorType(CompilationUnit astRoot) {
        return DiscriminatorType.fromJavaAnnotationValue(this.discriminatorTypeAdapter.getValue(astRoot));
    }

    private AnnotationElementAdapter<String> buildDiscriminatorTypeAdapter() {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, DISCRIMINATOR_TYPE_DECLARATION_ADAPTER);
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        if (this.attributeValueHasChanged(this.length, length)) {
            this.length = length;
            this.lengthAdapter.setValue((Object)length);
        }
    }

    private void syncLength(Integer astLength) {
        Integer old = this.length;
        this.length = astLength;
        this.firePropertyChanged("length", old, astLength);
    }

    private Integer buildLength(CompilationUnit astRoot) {
        return (Integer)this.lengthAdapter.getValue(astRoot);
    }

    private DeclarationAnnotationElementAdapter<Integer> buildLengthDeclarationAdapter() {
        return this.buildIntegerElementAdapter("length");
    }

    private AnnotationElementAdapter<Integer> buildLengthAdapter() {
        return this.buildIntegerElementAdapter(this.lengthDeclarationAdapter);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.discriminatorType == null && this.length == null;
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.discriminatorTypeAdapter = this.buildDiscriminatorTypeAdapter();
        this.lengthDeclarationAdapter = this.buildLengthDeclarationAdapter();
        this.lengthAdapter = this.buildLengthAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        map.put("discriminatorType", (Object)this.discriminatorType);
        this.discriminatorType = null;
        map.put("length", this.length);
        this.length = null;
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        this.setDiscriminatorType((DiscriminatorType)((Object)map.get("discriminatorType")));
        this.setLength((Integer)map.get("length"));
    }

    private static DeclarationAnnotationElementAdapter<String> buildDiscriminatorTypeDeclarationAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "discriminatorType");
    }
}

