/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceRelationshipMappingAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToOne2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceOneToOneAnnotation
extends SourceRelationshipMappingAnnotation
implements OneToOne2_0Annotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.OneToOne");
    static final DeclarationAnnotationElementAdapter<String> TARGET_ENTITY_ADAPTER = SourceOneToOneAnnotation.buildTargetEntityAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceOneToOneAnnotation.buildFetchAdapter();
    private static final DeclarationAnnotationElementAdapter<String[]> CASCADE_ADAPTER = SourceOneToOneAnnotation.buildCascadeAdapter();
    private static final DeclarationAnnotationElementAdapter<String> MAPPED_BY_ADAPTER = SourceOneToOneAnnotation.buildMappedByAdapter();
    private final AnnotationElementAdapter<String> mappedByAdapter = this.buildAnnotationElementAdapter(MAPPED_BY_ADAPTER);
    private String mappedBy;
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = SourceOneToOneAnnotation.buildOptionalAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter = this.buildBooleanAnnotationElementAdapter(OPTIONAL_ADAPTER);
    private Boolean optional;
    private static final DeclarationAnnotationElementAdapter<Boolean> ORPHAN_REMOVAL_ADAPTER = SourceOneToOneAnnotation.buildOrphanRemovalAdapter();
    private final AnnotationElementAdapter<Boolean> orphanRemovalAdapter = this.buildBooleanAnnotationElementAdapter(ORPHAN_REMOVAL_ADAPTER);
    private Boolean orphanRemoval;

    public SourceOneToOneAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.OneToOne";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.mappedBy = this.buildMappedBy(astRoot);
        this.optional = this.buildOptional(astRoot);
        this.orphanRemoval = this.buildOrphanRemoval(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncMappedBy(this.buildMappedBy(astRoot));
        this.syncOptional(this.buildOptional(astRoot));
        this.syncOrphanRemoval(this.buildOrphanRemoval(astRoot));
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.mappedBy == null && this.optional == null && this.orphanRemoval == null;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter() {
        return TARGET_ENTITY_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String> getFetchAdapter() {
        return FETCH_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter() {
        return CASCADE_ADAPTER;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String mappedBy) {
        if (this.attributeValueHasChanged(this.mappedBy, mappedBy)) {
            this.mappedBy = mappedBy;
            this.mappedByAdapter.setValue((Object)mappedBy);
        }
    }

    private void syncMappedBy(String astMappedBy) {
        String old = this.mappedBy;
        this.mappedBy = astMappedBy;
        this.firePropertyChanged("mappedBy", old, astMappedBy);
    }

    private String buildMappedBy(CompilationUnit astRoot) {
        return (String)this.mappedByAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getMappedByTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(MAPPED_BY_ADAPTER, astRoot);
    }

    @Override
    public boolean mappedByTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(MAPPED_BY_ADAPTER, pos, astRoot);
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        if (this.attributeValueHasChanged(this.optional, optional)) {
            this.optional = optional;
            this.optionalAdapter.setValue((Object)optional);
        }
    }

    private void syncOptional(Boolean astOptional) {
        Boolean old = this.optional;
        this.optional = astOptional;
        this.firePropertyChanged("optional", old, astOptional);
    }

    private Boolean buildOptional(CompilationUnit astRoot) {
        return (Boolean)this.optionalAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    @Override
    public Boolean getOrphanRemoval() {
        return this.orphanRemoval;
    }

    @Override
    public void setOrphanRemoval(Boolean orphanRemoval) {
        if (this.attributeValueHasChanged(this.orphanRemoval, orphanRemoval)) {
            this.orphanRemoval = orphanRemoval;
            this.orphanRemovalAdapter.setValue((Object)orphanRemoval);
        }
    }

    private void syncOrphanRemoval(Boolean astOrphanRemoval) {
        Boolean old = this.orphanRemoval;
        this.orphanRemoval = astOrphanRemoval;
        this.firePropertyChanged("orphanRemoval", old, astOrphanRemoval);
    }

    @Override
    public TextRange getOrphanRemovalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(ORPHAN_REMOVAL_ADAPTER, astRoot);
    }

    private Boolean buildOrphanRemoval(CompilationUnit astRoot) {
        return (Boolean)this.orphanRemovalAdapter.getValue(astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter() {
        return SourceOneToOneAnnotation.buildTargetEntityAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetEntity");
    }

    private static DeclarationAnnotationElementAdapter<String> buildMappedByAdapter() {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)"mappedBy");
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return SourceOneToOneAnnotation.buildFetchAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return SourceOneToOneAnnotation.buildOptionalAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildCascadeAdapter() {
        return SourceOneToOneAnnotation.buildEnumArrayAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "cascade");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOrphanRemovalAdapter() {
        return SourceOneToOneAnnotation.buildOrphanRemovalAdapter(DECLARATION_ANNOTATION_ADAPTER, "orphanRemoval");
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOrphanRemovalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, BooleanExpressionConverter.instance());
    }
}

