/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EnumType;
import org.eclipse.jpt.jpa.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceBaseEnumeratedAnnotation
extends SourceAnnotation<Attribute>
implements EnumeratedAnnotation {
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private EnumType value;

    protected SourceBaseEnumeratedAnnotation(JavaResourceNode parent, Attribute attribute, DeclarationAnnotationAdapter daa) {
        super(parent, attribute, daa);
        this.valueDeclarationAdapter = new EnumDeclarationAnnotationElementAdapter(daa, this.getValueElementName());
        this.valueAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)attribute, this.valueDeclarationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncValue(this.buildValue(astRoot));
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.value == null;
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.value);
    }

    @Override
    public EnumType getValue() {
        return this.value;
    }

    @Override
    public void setValue(EnumType value) {
        if (this.attributeValueHasChanged((Object)this.value, (Object)value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)EnumType.toJavaAnnotationValue(value));
        }
    }

    private void syncValue(EnumType astValue) {
        EnumType old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", (Object)old, (Object)astValue);
    }

    private EnumType buildValue(CompilationUnit astRoot) {
        return EnumType.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astRoot);
    }

    protected abstract String getValueElementName();
}

