/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyReferenceTable;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmReferenceTable;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlReferenceTable;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericOrmReferenceTable<X extends AbstractXmlReferenceTable>
extends AbstractOrmTable<X>
implements OrmReferenceTable {
    protected final Vector<OrmJoinColumn> specifiedJoinColumns = new Vector();
    protected final SpecifiedJoinColumnContainerAdapter specifiedJoinColumnContainerAdapter = new SpecifiedJoinColumnContainerAdapter();
    protected final OrmJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected OrmJoinColumn defaultJoinColumn;

    protected GenericOrmReferenceTable(XmlContextNode parent, Table.Owner owner) {
        super(parent, owner);
        this.initializeSpecifiedJoinColumns();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.getJoinColumns().iterator();
    }

    protected ListIterable<OrmJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public void convertDefaultToSpecifiedJoinColumn() {
        MappingTools.convertReferenceTableDefaultToSpecifiedJoinColumn(this);
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return this.getSpecifiedJoinColumns().iterator();
    }

    protected ListIterable<OrmJoinColumn> getSpecifiedJoinColumns() {
        return new LiveCloneListIterable(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.specifiedJoinColumns.size() != 0;
    }

    @Override
    public OrmJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumns.get(index);
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size());
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        AbstractXmlReferenceTable xmlTable = (AbstractXmlReferenceTable)this.getXmlTableForUpdate();
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmJoinColumn joinColumn = this.addSpecifiedJoinColumn_(index, xmlJoinColumn);
        xmlTable.getJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    protected XmlJoinColumn buildXmlJoinColumn() {
        return OrmFactory.eINSTANCE.createXmlJoinColumn();
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        this.removeSpecifiedJoinColumn_(index);
        ((AbstractXmlReferenceTable)this.getXmlTable()).getJoinColumns().remove(index);
        this.removeXmlTableIfUnset();
    }

    protected void removeSpecifiedJoinColumn_(int index) {
        this.removeItemFromList(index, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedJoinColumns, "specifiedJoinColumns");
        ((AbstractXmlReferenceTable)this.getXmlTable()).getJoinColumns().move(targetIndex, sourceIndex);
    }

    protected void initializeSpecifiedJoinColumns() {
        for (XmlJoinColumn xmlJoinColumn : this.getXmlJoinColumns()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(xmlJoinColumn));
        }
    }

    protected void syncSpecifiedJoinColumns() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedJoinColumnContainerAdapter);
    }

    protected Iterable<XmlJoinColumn> getXmlJoinColumns() {
        AbstractXmlReferenceTable xmlTable = (AbstractXmlReferenceTable)this.getXmlTable();
        return xmlTable == null ? EmptyIterable.instance() : new LiveCloneIterable(xmlTable.getJoinColumns());
    }

    protected void moveSpecifiedJoinColumn_(int index, OrmJoinColumn joinColumn) {
        this.moveItemInList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected OrmJoinColumn addSpecifiedJoinColumn_(int index, XmlJoinColumn xmlJoinColumn) {
        OrmJoinColumn joinColumn = this.buildJoinColumn(xmlJoinColumn);
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
        return joinColumn;
    }

    protected void removeSpecifiedJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn_(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    protected abstract OrmJoinColumn.Owner buildJoinColumnOwner();

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn joinColumn) {
        OrmJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected void initializeFrom(ReadOnlyReferenceTable oldTable) {
        super.initializeFrom(oldTable);
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(oldTable.specifiedJoinColumns())) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    protected void initializeFromVirtual(ReadOnlyReferenceTable virtualTable) {
        super.initializeFromVirtual(virtualTable);
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(virtualTable.joinColumns())) {
            this.addSpecifiedJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextNodeFactory().buildOrmJoinColumn(this, this.joinColumnOwner, xmlJoinColumn);
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        boolean continueValidating = this.buildTableValidator().validate(messages, reporter);
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        this.validateJoinColumns((Iterable<OrmJoinColumn>)this.getJoinColumns(), messages, reporter);
    }

    protected void validateJoinColumns(Iterable<OrmJoinColumn> joinColumns, List<IMessage> messages, IReporter reporter) {
        for (OrmJoinColumn joinColumn : joinColumns) {
            joinColumn.validate(messages, reporter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<OrmJoinColumn, XmlJoinColumn> {
        protected SpecifiedJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<OrmJoinColumn> getContextElements() {
            return GenericOrmReferenceTable.this.getSpecifiedJoinColumns();
        }

        @Override
        public Iterable<XmlJoinColumn> getResourceElements() {
            return GenericOrmReferenceTable.this.getXmlJoinColumns();
        }

        @Override
        public XmlJoinColumn getResourceElement(OrmJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }

        @Override
        public void moveContextElement(int index, OrmJoinColumn element) {
            GenericOrmReferenceTable.this.moveSpecifiedJoinColumn_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlJoinColumn resourceElement) {
            GenericOrmReferenceTable.this.addSpecifiedJoinColumn_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmJoinColumn element) {
            GenericOrmReferenceTable.this.removeSpecifiedJoinColumn_(element);
        }
    }
}

