/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.dnd;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.internal.VariableItemHelper;
import org.eclipse.wst.common.snippets.internal.ui.EntryDeserializer;

public class SnippetTextDropAction {
    static /* synthetic */ Class class$0;

    protected String getInsertString(Shell host, ISnippetItem item) {
        return VariableItemHelper.getInsertString(host, item, false);
    }

    protected ISnippetItem getItemData(DropTargetEvent event) {
        ISnippetItem item = null;
        if (event.data instanceof byte[]) {
            item = (ISnippetItem)EntryDeserializer.getInstance().fromXML((byte[])event.data);
        }
        return item;
    }

    public boolean run(DropTargetEvent event, IEditorPart targetEditor) {
        boolean success = false;
        if (event.data instanceof byte[]) {
            final ISnippetItem item = this.getItemData(event);
            final Shell shell = event.display.getActiveShell();
            final IEditorPart editor = targetEditor;
            if (item != null) {
                Runnable inserter = new Runnable(){

                    public void run() {
                        String insertion = SnippetTextDropAction.this.getInsertString(shell, item);
                        SnippetTextDropAction.this.insert(insertion, editor);
                        editor.setFocus();
                    }
                };
                shell.getDisplay().asyncExec(inserter);
                success = true;
            } else {
                success = this.insert(new String((byte[])event.data), targetEditor);
            }
        } else if (event.data instanceof String) {
            success = this.insert((String)event.data, targetEditor);
        }
        return success;
    }

    protected boolean insert(String text, IEditorPart targetEditor) {
        if (text == null || text.length() == 0) {
            return true;
        }
        ITextSelection textSelection = null;
        IDocument doc = null;
        ISelection selection = null;
        ITextEditor textEditor = null;
        if (targetEditor instanceof ITextEditor) {
            textEditor = (ITextEditor)targetEditor;
        }
        if (textEditor == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            textEditor = (ITextEditor)targetEditor.getAdapter((Class)clazz);
        }
        if (selection == null && textEditor != null) {
            selection = textEditor.getSelectionProvider().getSelection();
        }
        if (doc == null && textEditor != null) {
            doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        }
        if (selection instanceof ITextSelection) {
            textSelection = (ITextSelection)selection;
            try {
                doc.replace(textSelection.getOffset(), textSelection.getLength(), text);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        if (textEditor != null && textSelection != null) {
            ISelectionProvider sp = textEditor.getSelectionProvider();
            TextSelection sel = new TextSelection(textSelection.getOffset(), text.length());
            sp.setSelection((ISelection)sel);
            textEditor.selectAndReveal(sel.getOffset(), sel.getLength());
        }
        return true;
    }
}

