/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.cnf;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Trace;

public class CompositeServerImageDescriptor
extends CompositeImageDescriptor {
    private Image fBaseImage;
    private Point fSize;
    private Image overlay;

    public CompositeServerImageDescriptor(IServer server, Image overlay) {
        this.setBaseImage(ImageResource.getImage(server.getServerType().getId()));
        if (overlay == null) {
            Trace.trace((byte)4, "Invalid overlay icon");
        }
        this.overlay = overlay;
    }

    public CompositeServerImageDescriptor(Image baseImage, Image overlay) {
        this.setBaseImage(baseImage);
        if (overlay == null) {
            Trace.trace((byte)4, "Invalid overlay icon");
        }
        this.overlay = overlay;
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompositeServerImageDescriptor)) {
            return false;
        }
        CompositeServerImageDescriptor other = (CompositeServerImageDescriptor)((Object)object);
        return this.getBaseImage().equals((Object)other.getBaseImage());
    }

    public int hashCode() {
        return this.getBaseImage().hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        if (this.overlay == null) {
            return;
        }
        ImageData data = this.overlay.getImageData();
        int x = this.getSize().x - data.width;
        int y = this.getSize().y - data.height;
        this.drawImage(data, x, y);
    }

    protected Image getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(Image baseImage) {
        this.fBaseImage = baseImage;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

