/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.Member;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class Initializer
extends Member
implements IInitializer {
    protected Initializer(JavaElement parent, int count) {
        super(parent);
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        this.occurrenceCount = count;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Initializer)) {
            return false;
        }
        return super.equals(o);
    }

    public int getElementType() {
        return 10;
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.occurrenceCount);
    }

    protected char getHandleMementoDelimiter() {
        return '|';
    }

    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.occurrenceCount);
    }

    public String readableName() {
        return ((JavaElement)((Object)this.getDeclaringType())).readableName();
    }

    public void rename(String newName, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        throw new JavaScriptModelException(new JavaModelStatus(967, this));
    }

    public ISourceRange getNameRange() {
        return null;
    }

    public IJavaScriptElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && ((cu = (CompilationUnit)this.getAncestor(5)) == null || cu.isPrimary())) {
            return this;
        }
        IJavaScriptElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IType)primaryParent).getInitializer(this.occurrenceCount);
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append("<initializer #");
            buffer.append(this.occurrenceCount);
            buffer.append("> (not open)");
        } else if (info == NO_INFO) {
            buffer.append("<initializer #");
            buffer.append(this.occurrenceCount);
            buffer.append(">");
        } else {
            try {
                buffer.append("<");
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                buffer.append("initializer #");
                buffer.append(this.occurrenceCount);
                buffer.append(">");
            }
            catch (JavaScriptModelException javaScriptModelException) {
                buffer.append("<JavaScriptModelException in toString of " + this.getElementName());
            }
        }
    }
}

