/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaScriptElementImageDescriptor;

public class OverrideIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;

    public OverrideIndicatorLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public OverrideIndicatorLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : JavaScriptPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object element) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new JavaScriptElementImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    public int computeAdornmentFlags(Object element) {
        block6: {
            if (element instanceof IFunction) {
                IFunction method;
                block5: {
                    method = (IFunction)element;
                    if (method.getJavaScriptProject().isOnIncludepath((IJavaScriptElement)method)) break block5;
                    return 0;
                }
                try {
                    int flags = method.getFlags();
                    if (!(method.isConstructor() || Flags.isPrivate((int)flags) || Flags.isStatic((int)flags))) {
                        int res = this.getOverrideIndicators(method);
                        return res;
                    }
                }
                catch (JavaScriptModelException e) {
                    if (e.isDoesNotExist()) break block6;
                    JavaScriptPlugin.log(e);
                }
            }
        }
        return 0;
    }

    protected int getOverrideIndicators(IFunction method) throws JavaScriptModelException {
        int res;
        JavaScriptUnit astRoot = JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)method.getOpenable(), ASTProvider.WAIT_ACTIVE_ONLY, null);
        if (astRoot != null && (res = this.findInHierarchyWithAST(astRoot, method)) != -1) {
            return res;
        }
        IType type = method.getDeclaringType();
        if (type == null) {
            return 0;
        }
        MethodOverrideTester methodOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        IFunction defining = methodOverrideTester.findOverriddenMethod(method, true);
        if (defining != null) {
            if (JdtFlags.isAbstract((IMember)defining)) {
                return 256;
            }
            return 128;
        }
        return 0;
    }

    private int findInHierarchyWithAST(JavaScriptUnit astRoot, IFunction method) throws JavaScriptModelException {
        IFunctionBinding binding;
        ASTNode node = NodeFinder.perform((ASTNode)astRoot, method.getNameRange());
        if (node instanceof SimpleName && node.getParent() instanceof FunctionDeclaration && (binding = ((FunctionDeclaration)node.getParent()).resolveBinding()) != null) {
            IFunctionBinding defining = Bindings.findOverriddenMethod(binding, true);
            if (defining != null) {
                if (JdtFlags.isAbstract(defining)) {
                    return 256;
                }
                return 128;
            }
            return 0;
        }
        return -1;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if ((adornmentFlags & 0x100) != 0) {
            if ((adornmentFlags & 4) != 0) {
                decoration.addOverlay(JavaPluginImages.DESC_OVR_SYNCH_AND_IMPLEMENTS);
            } else {
                decoration.addOverlay(JavaPluginImages.DESC_OVR_IMPLEMENTS);
            }
        } else if ((adornmentFlags & 0x80) != 0) {
            if ((adornmentFlags & 4) != 0) {
                decoration.addOverlay(JavaPluginImages.DESC_OVR_SYNCH_AND_OVERRIDES);
            } else {
                decoration.addOverlay(JavaPluginImages.DESC_OVR_OVERRIDES);
            }
        }
    }
}

