/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IIfStatement;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.EqualExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.impl.StringConstant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class IfStatement
extends Statement
implements IIfStatement {
    public Expression condition;
    public Statement thenStatement;
    public Statement elseStatement;
    boolean thenExit;
    int thenInitStateIndex = -1;
    int elseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public IfStatement(Expression condition, Statement thenStatement, int sourceStart, int sourceEnd) {
        this.condition = condition;
        this.thenStatement = thenStatement;
        if (thenStatement instanceof EmptyStatement) {
            thenStatement.bits |= 1;
        }
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public IfStatement(Expression condition, Statement thenStatement, Statement elseStatement, int sourceStart, int sourceEnd) {
        this.condition = condition;
        this.thenStatement = thenStatement;
        if (thenStatement instanceof EmptyStatement) {
            thenStatement.bits |= 1;
        }
        this.elseStatement = elseStatement;
        if (elseStatement instanceof IfStatement) {
            elseStatement.bits |= 0x20000000;
        }
        if (elseStatement instanceof EmptyStatement) {
            elseStatement.bits |= 1;
        }
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo conditionFlowInfo = this.condition.analyseCode(currentScope, flowContext, flowInfo);
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != Constant.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != Constant.NotAConstant && !cst.booleanValue();
        FlowInfo thenFlowInfo = conditionFlowInfo.safeInitsWhenTrue();
        if (isConditionOptimizedFalse) {
            thenFlowInfo.setReachMode(1);
        }
        FlowInfo elseFlowInfo = conditionFlowInfo.initsWhenFalse();
        if (isConditionOptimizedTrue) {
            elseFlowInfo.setReachMode(1);
        }
        if (this.thenStatement != null && !this.thenStatement.complainIfUnreachable(thenFlowInfo, currentScope, false)) {
            thenFlowInfo = this.thenStatement.analyseCode(currentScope, flowContext, thenFlowInfo);
        }
        boolean bl = this.thenExit = (thenFlowInfo.tagBits & 1) != 0;
        if (this.elseStatement != null) {
            if (thenFlowInfo == FlowInfo.DEAD_END && (this.bits & 0x20000000) == 0 && !(this.elseStatement instanceof IfStatement)) {
                currentScope.problemReporter().unnecessaryElse(this.elseStatement);
            }
            if (!this.elseStatement.complainIfUnreachable(elseFlowInfo, currentScope, false)) {
                elseFlowInfo = this.elseStatement.analyseCode(currentScope, flowContext, elseFlowInfo);
            }
        }
        if (this.condition instanceof EqualExpression) {
            EqualExpression equalExpression = (EqualExpression)this.condition;
            int operator = (equalExpression.bits & 0xFC0) >> 6;
            if (operator == 18 || operator == 29) {
                boolean[] isDefined = new boolean[1];
                SingleNameReference snr = this.getTypeofExpressionVar(equalExpression.left, equalExpression.right, isDefined);
                if (snr == null) {
                    snr = this.getTypeofExpressionVar(equalExpression.right, equalExpression.left, isDefined);
                }
                if (snr != null) {
                    LocalVariableBinding local = snr.localVariableBinding();
                    if (local == null) {
                        snr.resolveType(currentScope, true, null);
                    }
                    if ((local = snr.localVariableBinding()) != null) {
                        if (isDefined[0]) {
                            thenFlowInfo.markAsDefinitelyAssigned(local);
                        } else {
                            elseFlowInfo.markAsDefinitelyAssigned(local);
                        }
                    }
                }
            }
        }
        UnconditionalFlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches(thenFlowInfo, isConditionOptimizedTrue, elseFlowInfo, isConditionOptimizedFalse, true);
        return mergedInfo;
    }

    private SingleNameReference getTypeofExpressionVar(Expression expression1, Expression expression2, boolean[] isDefined) {
        if (expression1 instanceof UnaryExpression && expression2.constant instanceof StringConstant) {
            UnaryExpression unaryExpression = (UnaryExpression)expression1;
            if (unaryExpression.expression instanceof SingleNameReference && (unaryExpression.bits & 0xFC0) >> 6 == 22) {
                isDefined[0] = !((StringConstant)expression2.constant).stringValue().equals("undefined");
                return (SingleNameReference)unaryExpression.expression;
            }
        }
        return null;
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        IfStatement.printIndent(indent, output).append("if (");
        this.condition.printExpression(0, output).append(")\n");
        this.thenStatement.printStatement(indent + 2, output);
        if (this.elseStatement != null) {
            output.append('\n');
            IfStatement.printIndent(indent, output);
            output.append("else\n");
            this.elseStatement.printStatement(indent + 2, output);
        }
        return output;
    }

    public void resolve(BlockScope scope) {
        this.condition.resolveTypeExpecting(scope, TypeBinding.BOOLEAN);
        if (this.thenStatement != null) {
            this.thenStatement.resolve(scope);
        }
        if (this.elseStatement != null) {
            this.elseStatement.resolve(scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.condition.traverse(visitor, blockScope);
            if (this.thenStatement != null) {
                this.thenStatement.traverse(visitor, blockScope);
            }
            if (this.elseStatement != null) {
                this.elseStatement.traverse(visitor, blockScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public int getASTType() {
        return 45;
    }
}

