/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public class CorrectMainTypeNameProposal
extends ASTRewriteCorrectionProposal {
    private final String fOldName;
    private final String fNewName;
    private final IInvocationContext fContext;

    public CorrectMainTypeNameProposal(IJavaScriptUnit cu, IInvocationContext context, String oldTypeName, String newTypeName, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fContext = context;
        this.setDisplayName(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renametype_description, newTypeName));
        this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        this.fOldName = oldTypeName;
        this.fNewName = newTypeName;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        JavaScriptUnit astRoot = this.fContext.getASTRoot();
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        AbstractTypeDeclaration decl = this.findTypeDeclaration(astRoot.types(), this.fOldName);
        if (decl != null) {
            SimpleName[] sameNodes = LinkedNodeFinder.findByNode((ASTNode)astRoot, decl.getName());
            int i = 0;
            while (i < sameNodes.length) {
                rewrite.replace((ASTNode)sameNodes[i], (ASTNode)ast.newSimpleName(this.fNewName), null);
                ++i;
            }
        }
        return rewrite;
    }

    private AbstractTypeDeclaration findTypeDeclaration(List types, String name) {
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            AbstractTypeDeclaration decl = (AbstractTypeDeclaration)iter.next();
            if (!name.equals(decl.getName().getIdentifier())) continue;
            return decl;
        }
        return null;
    }
}

