/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaHistoryActionImpl;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaNode;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaTextBufferNode;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

class JavaAddElementFromHistoryImpl
extends JavaHistoryActionImpl {
    private static final String BUNDLE_NAME = "org.eclipse.wst.jsdt.internal.ui.compare.AddFromHistoryAction";

    JavaAddElementFromHistoryImpl() {
        super(true);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(ISelection selection) {
        block36: {
            block35: {
                block38: {
                    block37: {
                        errorTitle = CompareMessages.AddFromHistory_title;
                        errorMessage = CompareMessages.AddFromHistory_internalErrorMessage;
                        shell = this.getShell();
                        cu = null;
                        parent = null;
                        input = null;
                        if (!selection.isEmpty()) break block37;
                        editor = this.getEditor();
                        if (editor != null) {
                            editorInput = editor.getEditorInput();
                            manager = JavaScriptPlugin.getDefault().getWorkingCopyManager();
                            if (manager != null) {
                                cu = manager.getWorkingCopy(editorInput);
                                parent = cu;
                            }
                        }
                        break block38;
                    }
                    input = this.getEditionElement(selection);
                    if (input != null) {
                        cu = input.getJavaScriptUnit();
                        parent = input;
                        input = null;
                    } else if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IJavaScriptUnit) {
                        cu = (IJavaScriptUnit)o;
                        parent = cu;
                    }
                }
                if (parent == null || cu == null) {
                    invalidSelectionMessage = CompareMessages.AddFromHistory_invalidSelectionMessage;
                    MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)invalidSelectionMessage);
                    return;
                }
                file = this.getFile(parent);
                if (file == null) {
                    MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                    return;
                }
                inEditor = this.beingEdited(file);
                status = Resources.makeCommittable((IResource)file, (Object)shell);
                if (!status.isOK()) {
                    return;
                }
                path = file.getFullPath();
                bufferManager = FileBuffers.getTextFileBufferManager();
                textFileBuffer = null;
                try {
                    try {
                        bufferManager.connect(path, LocationKind.IFILE, null);
                        textFileBuffer = bufferManager.getTextFileBuffer(path, LocationKind.IFILE);
                        document = textFileBuffer.getDocument();
                        target = new JavaTextBufferNode(file, document, inEditor);
                        editions = this.buildEditions(target, file);
                        bundle = ResourceBundle.getBundle("org.eclipse.wst.jsdt.internal.ui.compare.AddFromHistoryAction");
                        d = new EditionSelectionDialog(shell, bundle);
                        d.setAddMode(true);
                        d.setHelpContextId("org.eclipse.wst.jsdt.ui.add_element_from_history_dialog_context");
                        selected = d.selectEdition((ITypedElement)target, editions, (Object)parent);
                        if (selected == null) {
lbl57:
                            // 2 sources

                            while (true) {
                                var30_23 = null;
                                break block35;
                                break;
                            }
                        }
                        cu2 = cu;
                        if (parent instanceof IMember) {
                            cu2 = parent.getJavaScriptUnit();
                        }
                        root = JavaAddElementFromHistoryImpl.parsePartialCompilationUnit(cu2);
                        rewriter = ASTRewrite.create((AST)root.getAST());
                        results = d.getSelection();
                        i = 0;
                        while (true) {
                            if (i >= results.length) {
                                options = null;
                                javaProject = cu2.getJavaScriptProject();
                                if (javaProject != null) {
                                    options = javaProject.getOptions(true);
                                }
                                this.applyChanges(rewriter, document, textFileBuffer, shell, inEditor, options);
                                break block36;
                            }
                            newNode = this.createASTNode(rewriter, results[i], TextUtilities.getDefaultLineDelimiter((IDocument)document), cu.getJavaScriptProject());
                            if (newNode == null) {
                                MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                                ** continue;
                            }
                            if (newNode instanceof PackageDeclaration) {
                                rewriter.set((ASTNode)root, (StructuralPropertyDescriptor)JavaScriptUnit.PACKAGE_PROPERTY, (Object)newNode, null);
                            } else if (newNode instanceof ImportDeclaration) {
                                lw = rewriter.getListRewrite((ASTNode)root, JavaScriptUnit.IMPORTS_PROPERTY);
                                lw.insertFirst(newNode, null);
                            } else if (parent instanceof IJavaScriptUnit) {
                                lw = rewriter.getListRewrite((ASTNode)root, JavaScriptUnit.TYPES_PROPERTY);
                                index = ASTNodes.getInsertionIndex((BodyDeclaration)newNode, root.types());
                                lw.insertAt(newNode, index, null);
                            } else if (parent instanceof IType) {
                                declaration = this.getBodyContainer(root, (IMember)((IType)parent));
                                if (declaration instanceof TypeDeclaration) {
                                    container = ASTNodes.getBodyDeclarations(declaration);
                                    index = ASTNodes.getInsertionIndex((BodyDeclaration)newNode, container);
                                    lw = rewriter.getListRewrite(declaration, ASTNodes.getBodyDeclarationsProperty(declaration));
                                    lw.insertAt(newNode, index, null);
                                }
                            } else {
                                JavaScriptPlugin.logErrorMessage("JavaAddElementFromHistoryImpl: unknown container " + parent);
                            }
                            ++i;
                        }
                    }
                    catch (InvocationTargetException ex) {
                        ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                        break block36;
                    }
                    catch (InterruptedException v0) {
                        Assert.isTrue((boolean)false);
                        break block36;
                    }
                    catch (CoreException ex) {
                        ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
                        break block36;
                    }
                }
                catch (Throwable var31_41) {
                    var30_24 = null;
                    try {
                        if (textFileBuffer == null) throw var31_41;
                        bufferManager.disconnect(path, LocationKind.IFILE, null);
                        throw var31_41;
                    }
                    catch (CoreException e) {
                        JavaScriptPlugin.log(e);
                    }
                    throw var31_41;
                }
            }
            ** try [egrp 2[TRYBLOCK] [11 : 752->773)] { 
lbl124:
            // 1 sources

            if (textFileBuffer == null) return;
            bufferManager.disconnect(path, LocationKind.IFILE, null);
            return;
lbl127:
            // 1 sources

            catch (CoreException e) {
                JavaScriptPlugin.log(e);
            }
            return;
        }
        var30_25 = null;
        try {}
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
            return;
        }
        if (textFileBuffer == null) return;
        bufferManager.disconnect(path, LocationKind.IFILE, null);
    }

    private ASTNode createASTNode(ASTRewrite rewriter, ITypedElement element, String delimiter, IJavaScriptProject project) throws CoreException {
        int type;
        String content;
        if (element instanceof IStreamContentAccessor && (content = JavaCompareUtilities.readString((IStreamContentAccessor)element)) != null && (content = JavaAddElementFromHistoryImpl.trimTextBlock(content, delimiter, project)) != null && (type = this.getPlaceHolderType(element)) != -1) {
            return rewriter.createStringPlaceholder(content, type);
        }
        return null;
    }

    private int getPlaceHolderType(ITypedElement element) {
        if (element instanceof DocumentRangeNode) {
            JavaNode jn = (JavaNode)element;
            switch (jn.getTypeCode()) {
                case 1: {
                    return 35;
                }
                case 4: 
                case 5: {
                    return 55;
                }
                case 10: 
                case 11: {
                    return 31;
                }
                case 8: {
                    return 23;
                }
                case 9: {
                    return 28;
                }
                case 2: 
                case 3: {
                    return 26;
                }
                case 0: {
                    return 15;
                }
            }
        }
        return -1;
    }

    protected boolean isEnabled(ISelection selection) {
        Object o;
        if (selection.isEmpty()) {
            JavaEditor editor = this.getEditor();
            if (editor != null) {
                IEditorInput editorInput = editor.getEditorInput();
                WorkingCopyManager manager = JavaScriptPlugin.getDefault().getWorkingCopyManager();
                return manager.getWorkingCopy(editorInput) != null;
            }
            return false;
        }
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IJavaScriptUnit) {
            return true;
        }
        return super.isEnabled(selection);
    }
}

