/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceManipulation;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateTypeMemberOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class CreateFieldOperation
extends CreateTypeMemberOperation {
    public CreateFieldOperation(IJavaScriptElement parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, IJavaScriptUnit cu) throws JavaScriptModelException {
        ASTNode node = super.generateElementAST(rewriter, document, cu);
        if (node.getNodeType() != 23) {
            throw new JavaScriptModelException(new JavaModelStatus(984));
        }
        return node;
    }

    protected IJavaScriptElement generateResultHandle() {
        if (this.getType() != null) {
            return this.getType().getField(this.getASTNodeName());
        }
        return this.getCompilationUnit().getField(this.getASTNodeName());
    }

    public String getMainTaskName() {
        return Messages.operation_createFieldProgress;
    }

    private VariableDeclarationFragment getFragment(ASTNode node) {
        Iterator fragments = ((FieldDeclaration)node).fragments().iterator();
        if (this.anchorElement != null) {
            VariableDeclarationFragment fragment = null;
            String fragmentName = this.anchorElement.getElementName();
            while (fragments.hasNext()) {
                fragment = (VariableDeclarationFragment)fragments.next();
                if (!fragment.getName().getIdentifier().equals(fragmentName)) continue;
                return fragment;
            }
            return fragment;
        }
        return (VariableDeclarationFragment)fragments.next();
    }

    protected void initializeDefaultPosition() {
        IField[] fields = null;
        try {
            ISourceManipulation parentElement;
            if (this.getType() != null) {
                parentElement = this.getType();
                fields = this.getType().getFields();
            } else {
                parentElement = this.getCompilationUnit();
                fields = this.getCompilationUnit().getFields();
            }
            if (fields != null && fields.length > 0) {
                IField lastField = fields[fields.length - 1];
                this.createAfter(lastField);
            } else {
                IJavaScriptElement[] elements = parentElement.getChildren();
                if (elements != null && elements.length > 0) {
                    this.createBefore(elements[0]);
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    protected IJavaScriptModelStatus verifyNameCollision() {
        if (this.createdNode != null) {
            IType type = this.getType();
            String fieldName = this.getASTNodeName();
            if (type != null ? type.getField(fieldName).exists() : this.getCompilationUnit().getField(fieldName).exists()) {
                return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, fieldName));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    private String getASTNodeName() {
        if (this.alteredName != null) {
            return this.alteredName;
        }
        return this.getFragment(this.createdNode).getName().getIdentifier();
    }

    protected SimpleName rename(ASTNode node, SimpleName newName) {
        VariableDeclarationFragment fragment = this.getFragment(node);
        SimpleName oldName = fragment.getName();
        fragment.setName(newName);
        return oldName;
    }
}

