/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.breakpoints;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.Event;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.ScriptLoadEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ScriptLoadRequest;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptPreferencesManager;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptThread;

public class JavaScriptLoadBreakpoint
extends JavaScriptLineBreakpoint
implements IJavaScriptLoadBreakpoint {
    public static final String GLOBAL_SUSPEND = "org.eclipse.wst.jsdt.debug.core.global_suspend";

    public JavaScriptLoadBreakpoint() {
    }

    public JavaScriptLoadBreakpoint(final IResource resource, final int charstart, final int charend, final Map attributes, final boolean register) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = null;
                marker = resource == null ? ResourcesPlugin.getWorkspace().getRoot().createMarker("org.eclipse.wst.jsdt.debug.core.scriptload.breakpoint.marker") : resource.createMarker("org.eclipse.wst.jsdt.debug.core.scriptload.breakpoint.marker");
                JavaScriptLoadBreakpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.id", JavaScriptLoadBreakpoint.this.getModelIdentifier());
                attributes.put("org.eclipse.debug.core.enabled", true);
                attributes.put("charStart", new Integer(charstart));
                attributes.put("charEnd", new Integer(charend));
                JavaScriptLoadBreakpoint.this.ensureMarker().setAttributes(attributes);
                JavaScriptLoadBreakpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule((IResource)ResourcesPlugin.getWorkspace().getRoot()), wr);
    }

    public boolean handleEvent(Event event, JavaScriptDebugTarget target, boolean suspendVote, EventSet eventSet) {
        if (event instanceof ScriptLoadEvent) {
            ScriptLoadEvent sevent = (ScriptLoadEvent)event;
            ScriptReference script = sevent.script();
            JavaScriptThread thread = target.findThread(sevent.thread());
            if (thread != null) {
                if (this.isGlobalLoadSuspend()) {
                    JavaScriptPreferencesManager.setGlobalSuspendOn(script.sourceURI().toString());
                    thread.addBreakpoint(this);
                    return false;
                }
                if (this.isMatchedScriptLoadSuspend(script, thread, suspendVote)) {
                    thread.addBreakpoint(this);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isMatchedScriptLoadSuspend(ScriptReference script, JavaScriptThread thread, boolean suspendVote) {
        try {
            if (this.scriptPathMatches(script)) {
                int vote = thread.suspendForScriptLoad(this, script, suspendVote);
                return (vote & 1) > 0 || vote == 0;
            }
        }
        catch (CoreException ce) {
            JavaScriptDebugPlugin.log(ce);
        }
        return false;
    }

    private boolean isGlobalLoadSuspend() {
        try {
            return this.ensureMarker().getAttribute(GLOBAL_SUSPEND, false);
        }
        catch (CoreException ce) {
            JavaScriptDebugPlugin.log(ce);
            return false;
        }
    }

    protected void registerRequest(JavaScriptDebugTarget target, EventRequest request) {
        ArrayList requests = this.getRequests(target);
        if (requests == null || requests.isEmpty()) {
            this.addRequestForTarget(target, request);
            try {
                if (this.isRegistered()) {
                    this.incrementInstallCount();
                }
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
    }

    protected void deregisterRequest(JavaScriptDebugTarget target, EventRequest request) {
        target.removeJSDIEventListener(this, request);
        try {
            this.decrementInstallCount();
        }
        catch (CoreException ce) {
            JavaScriptDebugPlugin.log(ce);
        }
    }

    public void eventSetComplete(Event event, JavaScriptDebugTarget target, boolean suspend, EventSet eventSet) {
        JavaScriptThread thread;
        if (event instanceof ScriptLoadEvent && (thread = target.findThread(((ScriptLoadEvent)event).thread())) != null) {
            ScriptLoadEvent sevent = (ScriptLoadEvent)event;
            thread.suspendForScriptLoadComplete(this, sevent.script(), suspend, eventSet);
        }
    }

    protected boolean createRequest(JavaScriptDebugTarget target, ScriptReference script) throws CoreException {
        ScriptLoadRequest request = target.getEventRequestManager().createScriptLoadRequest();
        this.registerRequest(target, request);
        request.setEnabled(this.isEnabled());
        return false;
    }
}

