/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptFunctionBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLineBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptDebugUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.SWTFactory;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.BreakpointHelper;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors.AbstractJavaScriptBreakpointEditor;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors.CompositeBreakpointEditor;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors.FunctionBreakpointEditor;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors.JavaScriptBreakpointConditionEditor;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.editors.StandardJavaScriptBreakpointEditor;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;

public class JavaScriptBreakpointPropertyPage
extends PropertyPage {
    public static String PAGE_ID = "org.eclipse.wst.jsdt.debug.ui.breakpoints.propertypage";
    protected Button enabledbutton;
    protected Button hitcountbutton;
    protected Text hitcounttext;
    protected Combo suspendpolicycombo;
    protected List errors = new ArrayList();
    protected String fPrevMessage = null;
    AbstractJavaScriptBreakpointEditor editor = null;
    JavaScriptElementLabelProvider labelprovider = new JavaScriptElementLabelProvider(JavaScriptElementLabelProvider.SHOW_DEFAULT);

    protected IJavaScriptBreakpoint getBreakpoint() {
        return (IJavaScriptBreakpoint)this.getElement();
    }

    protected void createTypeSpecificLabels(Composite parent) {
        IJavaScriptBreakpoint jb = this.getBreakpoint();
        if (jb instanceof IJavaScriptLineBreakpoint) {
            IJavaScriptLineBreakpoint breakpoint = (IJavaScriptLineBreakpoint)jb;
            StringBuffer lineNumber = new StringBuffer(4);
            try {
                int lNumber = breakpoint.getLineNumber();
                if (lNumber > 0) {
                    lineNumber.append(lNumber);
                }
            }
            catch (CoreException ce) {
                JavaScriptDebugUIPlugin.log(ce);
            }
            if (lineNumber.length() > 0) {
                SWTFactory.createLabel(parent, Messages.line_number, 1);
                Text text = SWTFactory.createSingleText(parent, 8, 1, lineNumber.toString());
                GridData gd = (GridData)text.getLayoutData();
                gd.horizontalAlignment = 32;
                gd.grabExcessHorizontalSpace = false;
                gd.widthHint = 50;
                text.setBackground(parent.getBackground());
            }
            try {
                IMember member = BreakpointHelper.getMember(breakpoint);
                if (member == null) {
                    return;
                }
                String label = Messages.member;
                if (breakpoint instanceof IJavaScriptFunctionBreakpoint) {
                    label = Messages.fuction;
                }
                SWTFactory.createLabel(parent, label, 1);
                Text text = SWTFactory.createSingleText(parent, 8, 1, this.labelprovider.getText((Object)member));
                text.setBackground(parent.getBackground());
            }
            catch (CoreException exception) {
                JavaScriptDebugUIPlugin.log(exception);
            }
        }
    }

    protected void createTypeSpecificEditors(Composite parent) {
        try {
            String type = this.getBreakpoint().getMarker().getType();
            if ("org.eclipse.wst.jsdt.debug.core.scriptload.breakpoint.marker".equals(type)) {
                this.setTitle(Messages.script_load_breakpoint);
                this.editor = new StandardJavaScriptBreakpointEditor();
            } else if ("org.eclipse.wst.jsdt.debug.core.line.breakpoint.marker".equals(type)) {
                this.setTitle(Messages.line_breakpoint);
                this.editor = new CompositeBreakpointEditor(new AbstractJavaScriptBreakpointEditor[]{new StandardJavaScriptBreakpointEditor(), new JavaScriptBreakpointConditionEditor()});
            } else if ("org.eclipse.wst.jsdt.debug.core.function.breakpoint.marker".equals(type)) {
                this.setTitle(Messages.function_breakpoint);
                this.editor = new CompositeBreakpointEditor(new AbstractJavaScriptBreakpointEditor[]{new FunctionBreakpointEditor(), new JavaScriptBreakpointConditionEditor()});
            }
            this.editor.createControl(parent);
            this.editor.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    IStatus status = JavaScriptBreakpointPropertyPage.this.editor.getStatus();
                    if (status.isOK()) {
                        if (JavaScriptBreakpointPropertyPage.this.fPrevMessage != null) {
                            JavaScriptBreakpointPropertyPage.this.removeErrorMessage(JavaScriptBreakpointPropertyPage.this.fPrevMessage);
                            JavaScriptBreakpointPropertyPage.this.fPrevMessage = null;
                        }
                    } else {
                        JavaScriptBreakpointPropertyPage.this.fPrevMessage = status.getMessage();
                        JavaScriptBreakpointPropertyPage.this.addErrorMessage(JavaScriptBreakpointPropertyPage.this.fPrevMessage);
                    }
                }
            });
            this.editor.setInput(this.getBreakpoint());
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    protected void doStore() throws CoreException {
        IJavaScriptBreakpoint breakpoint = this.getBreakpoint();
        breakpoint.setEnabled(this.enabledbutton.getSelection());
        if (this.editor != null) {
            this.editor.doSave();
        }
    }

    protected void createEnabledButton(Composite parent) {
        this.enabledbutton = SWTFactory.createCheckButton(parent, Messages.enabled, null, false, 1);
        try {
            this.enabledbutton.setSelection(this.getBreakpoint().isEnabled());
        }
        catch (CoreException ce) {
            JavaScriptDebugUIPlugin.log(ce);
        }
    }

    protected void createLabels(Composite parent) {
        Composite labelComposite = SWTFactory.createComposite(parent, 2, 1, 768);
        try {
            Text text;
            String name = this.getBreakpoint().getTypeName();
            if (name != null) {
                SWTFactory.createLabel(labelComposite, Messages.type_name, 1);
                text = SWTFactory.createText(labelComposite, 12, 1, 768);
                text.setText(name);
                text.setBackground(parent.getBackground());
            }
            if ((name = this.getBreakpoint().getScriptPath()) != null) {
                SWTFactory.createLabel(labelComposite, Messages.script_path, 1);
                text = SWTFactory.createText(labelComposite, 8, 1, 768);
                text.setText(name);
                text.setBackground(parent.getBackground());
            }
            this.createTypeSpecificLabels(labelComposite);
        }
        catch (CoreException ce) {
            JavaScriptDebugUIPlugin.log(ce);
        }
    }

    protected void addErrorMessage(String message) {
        this.errors.remove(message);
        this.errors.add(message);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    protected void removeErrorMessage(String message) {
        this.errors.remove(message);
        if (this.errors.isEmpty()) {
            this.addErrorMessage(null);
        } else {
            this.addErrorMessage((String)this.errors.get(this.errors.size() - 1));
        }
    }

    protected Control createContents(Composite parent) {
        this.setTitle(Messages.script_load_bp);
        this.noDefaultAndApplyButton();
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808);
        this.createLabels(comp);
        SWTFactory.createHorizontalSpacer(comp, 1);
        this.createEnabledButton(comp);
        this.createTypeSpecificEditors(comp);
        this.setValid(true);
        this.setControl((Control)parent);
        return comp;
    }

    public boolean performOk() {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaScriptBreakpointPropertyPage.this.doStore();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 1, null);
        }
        catch (CoreException e) {
            JavaScriptDebugUIPlugin.log(e);
        }
        return super.performOk();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.jsdt.debug.ui.breakpoint_property_page");
    }
}

