/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.parser;

import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class ContextRegion
implements ITextRegion {
    protected int fLength;
    protected int fStart;
    protected int fTextLength;
    protected String fType;

    protected ContextRegion() {
    }

    public ContextRegion(String newContext, int newStart, int newTextLength, int newLength) {
        this.fType = newContext;
        this.fStart = newStart;
        this.fTextLength = newTextLength;
        this.fLength = newLength;
    }

    public void adjust(int i) {
        this.fStart += i;
    }

    public void adjustLength(int i) {
        this.fLength += i;
    }

    public void adjustStart(int i) {
        this.fStart += i;
    }

    public void adjustTextLength(int i) {
        this.fTextLength += i;
    }

    boolean allLetterOrDigit(String changes) {
        boolean result = true;
        int i = 0;
        while (i < changes.length()) {
            if (!Character.isLetterOrDigit(changes.charAt(i))) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    boolean allWhiteSpace(String changes) {
        boolean result = true;
        int i = 0;
        while (i < changes.length()) {
            if (!Character.isWhitespace(changes.charAt(i))) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    boolean canHandleAsLetterOrDigit(String changes, int requestStart, int lengthToReplace) {
        boolean result = false;
        if (requestStart <= this.getTextEnd() && this.allLetterOrDigit(changes)) {
            result = true;
        }
        return result;
    }

    boolean canHandleAsWhiteSpace(String changes, int requestStart, int lengthToReplace) {
        boolean result = false;
        if (this.getEnd() > this.getTextEnd() && requestStart > this.getTextEnd()) {
            result = this.allWhiteSpace(changes);
        }
        return result;
    }

    public boolean contains(int position) {
        return this.fStart <= position && position < this.fStart + this.fLength;
    }

    public void equatePositions(ITextRegion region) {
        this.fStart = region.getStart();
        this.fLength = region.getLength();
        this.fTextLength = region.getTextLength();
    }

    public int getEnd() {
        return this.fStart + this.fLength;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getTextEnd() {
        return this.fStart + this.fTextLength;
    }

    public int getTextLength() {
        return this.fTextLength;
    }

    public String getType() {
        return this.fType;
    }

    public void setLength(int i) {
        this.fLength = i;
    }

    public void setStart(int i) {
        this.fStart = i;
    }

    public void setTextLength(int i) {
        this.fTextLength = i;
    }

    public void setType(String string) {
        this.fType = string;
    }

    public String toString() {
        String className = this.getClass().getName();
        String shortClassName = className.substring(className.lastIndexOf(".") + 1);
        String result = String.valueOf(shortClassName) + "--> " + this.getType() + ": " + this.getStart() + "-" + this.getTextEnd() + (this.getTextEnd() != this.getEnd() ? "/" + this.getEnd() : "");
        return result;
    }

    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        return null;
    }
}

