/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.web.verifiers;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.ModuleImportDataModelVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebImportDataModelVerifier
extends ModuleImportDataModelVerifier {
    @Override
    public void verify(IDataModel model) throws Exception {
        super.verify(model);
    }

    @Override
    protected int getExportType() {
        return 4;
    }

    @Override
    protected void verifyImportedResources(Collection<IArchiveResource> sourceResources, Collection<IArchiveResource> importedClassesResources, Collection<IArchiveResource> otherResources, Collection<IArchive> nestedArchives, IFolder rootFolder, IFolder importedClassesFolder) {
        IPath resourcePath = null;
        IFile resourceFile = null;
        IFolder sourceFolder = this.project.getFolder("src");
        for (IArchiveResource sourceResource : sourceResources) {
            resourcePath = sourceResource.getPath();
            resourcePath = resourcePath.removeFirstSegments(2);
            resourceFile = sourceFolder.getFile(resourcePath);
            Assert.assertTrue((String)("The file " + resourcePath + " should exist in the project"), (boolean)resourceFile.exists());
        }
        for (IArchiveResource importedClassResource : importedClassesResources) {
            resourcePath = importedClassResource.getPath().removeFirstSegments(2);
            resourceFile = importedClassesFolder.getFile(resourcePath);
            if (resourceFile.exists()) continue;
            Assert.fail((String)("The imported class " + resourcePath + " should exist in the project"));
        }
        for (IArchiveResource otherResource : otherResources) {
            resourcePath = otherResource.getPath();
            resourceFile = rootFolder.getFile(resourcePath);
            Assert.assertTrue((String)("The resource " + resourcePath + " should exist in the project"), (boolean)resourceFile.exists());
        }
        Iterator<IArchive> iterator = nestedArchives.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    @Override
    protected boolean isClassWithoutSource(IArchive archive, IArchiveResource aFile) {
        String alternateJavaUri;
        Path alternateJavaPath;
        Path jspPath;
        int _index;
        String javaUri = ArchiveUtil.classUriToJavaUri((String)aFile.getPath().toString());
        if (javaUri == null) {
            return true;
        }
        Path javaPath = new Path(javaUri);
        if (archive.containsArchiveResource((IPath)javaPath)) {
            return false;
        }
        String jspUri = javaUri.substring(0, javaUri.indexOf(".java"));
        int lastSlash = jspUri.lastIndexOf(47);
        int n = _index = lastSlash == -1 ? "WEB-INF/classes/".length() : lastSlash + 1;
        if (jspUri.charAt(_index) == '_' && archive.containsArchiveResource((IPath)(jspPath = new Path(jspUri = String.valueOf(jspUri.substring("WEB-INF/classes/".length(), _index)) + jspUri.substring(_index + 1) + ".jsp")))) {
            return false;
        }
        if (javaPath.segmentCount() > 2 && javaPath.segment(0).equals("WEB-INF") && javaPath.segment(1).equals("classes") && archive.containsArchiveResource((IPath)(alternateJavaPath = new Path(alternateJavaUri = javaUri.replaceFirst("classes", "source"))))) {
            try {
                IArchiveResource sourceFile = archive.getArchiveResource((IPath)alternateJavaPath);
                if (sourceFile != null) {
                    return false;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return true;
    }
}

