/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wtp.j2ee.headless.tests.appclient.operations.AppClientExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.ejb.operations.EJBExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JEEExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.jca.operations.JCAExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.utility.operations.UtilityExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.web.operations.WebExportOperationTest;

public abstract class ModuleExportOperationTest
extends JEEExportOperationTest {
    protected static final String PACKAGE_NAME = "test";

    public ModuleExportOperationTest() {
        super("ModuleExportOperationTests");
    }

    public ModuleExportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("All Module ExportOperation Tests");
        suite.addTestSuite(JCAExportOperationTest.class);
        suite.addTestSuite(EJBExportOperationTest.class);
        suite.addTestSuite(WebExportOperationTest.class);
        suite.addTestSuite(AppClientExportOperationTest.class);
        suite.addTestSuite(UtilityExportOperationTest.class);
        return suite;
    }

    protected abstract void addJavaFilesToProject(String var1, String[] var2, String var3) throws Exception;

    protected abstract void verifyJavaFilesExported(String var1, String[] var2, String var3, boolean var4, boolean var5) throws Exception;

    protected void runExportTests_All(IDataModel creationModel) throws Exception {
        String projectName = creationModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        String archiveName = null;
        String archivePath = null;
        this.addJavaFilesToProject(projectName, JAVA_FILE_NAMES, PACKAGE_NAME);
        archiveName = this.runAndVerifyExport_Defaults(projectName);
        archivePath = ModuleExportOperationTest.getDataPath(archiveName);
        this.verifyJavaFilesExported(archivePath, JAVA_FILE_NAMES, PACKAGE_NAME, true, false);
        ModuleExportOperationTest.deleteExported(archivePath);
        archiveName = this.runAndVerifyExport_WithSource(projectName);
        archivePath = ModuleExportOperationTest.getDataPath(archiveName);
        this.verifyJavaFilesExported(archivePath, JAVA_FILE_NAMES, PACKAGE_NAME, true, true);
        ModuleExportOperationTest.deleteExported(archivePath);
        archiveName = this.runAndVerifyExport_DontRunBuild(projectName);
        archivePath = ModuleExportOperationTest.getDataPath(archiveName);
        ModuleExportOperationTest.deleteExported(archivePath);
        archiveName = this.runAndVerifyExport_WithSource_DontRunBuild(projectName);
        archivePath = ModuleExportOperationTest.getDataPath(archiveName);
        this.verifyJavaFilesExported(archivePath, JAVA_FILE_NAMES, PACKAGE_NAME, false, true);
        ModuleExportOperationTest.deleteExported(archivePath);
        this.runTest_AttemptToOverwriteButCant(projectName);
        this.runTest_AttemptToOverwriteSholdSucceed(projectName);
    }
}

