/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.internal.common.operations.CreateJavaEEArtifactTemplateModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportsCollection
implements Collection<String> {
    private Collection<String> collection = new TreeSet<String>();
    private CreateJavaEEArtifactTemplateModel model;

    public ImportsCollection(CreateJavaEEArtifactTemplateModel model) {
        this.model = model;
    }

    @Override
    public boolean add(String o) {
        if (!this.isImportInJavaLang(o) && !this.isImportInSamePackage(o)) {
            return this.collection.add(o);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean result = false;
        for (String string : c) {
            result |= this.add(string);
        }
        return result;
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return this.collection.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.collection.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.collection.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.collection.retainAll(c);
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collection.toArray(a);
    }

    private boolean isImportInJavaLang(String quilifiedName) {
        Signature.getQualifier((String)quilifiedName);
        return quilifiedName.startsWith("java.lang.");
    }

    private boolean isImportInSamePackage(String quilifiedName) {
        String qualifier = Signature.getQualifier((String)quilifiedName);
        return qualifier.equals(this.model.getJavaPackageName());
    }
}

