/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal.delegates;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.delegates.IDelegatingValidator;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IProjectValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class DelegatingValidator
extends AbstractValidator
implements IDelegatingValidator {
    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.validateInJob(helper, reporter);
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        ValidatorDelegateDescriptor delegateDescriptor;
        block9: {
            ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(this);
            String validatorName = vmd.getValidatorDisplayName();
            if (!(helper instanceof IProjectValidationContext)) {
                throw new ValidationException(new LocalizedMessage(1, ResourceHandler.getExternalizedMessage("VBF_WRONG_CONTEXT_FOR_DELEGATE", new String[]{validatorName})));
            }
            IProjectValidationContext projectContext = (IProjectValidationContext)helper;
            IProject project = projectContext.getProject();
            delegateDescriptor = null;
            try {
                try {
                    ProjectConfiguration projectConfig = ConfigurationManager.getManager().getProjectConfiguration(project);
                    delegateDescriptor = projectConfig.getDelegateDescriptor(vmd);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (delegateDescriptor == null) {
                        throw new ValidationException(new LocalizedMessage(1, ResourceHandler.getExternalizedMessage("VBF_NO_DELEGATE", new String[]{vmd.getValidatorDisplayName()})));
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (delegateDescriptor == null) {
                    throw new ValidationException(new LocalizedMessage(1, ResourceHandler.getExternalizedMessage("VBF_NO_DELEGATE", new String[]{vmd.getValidatorDisplayName()})));
                }
                throw throwable;
            }
            if (delegateDescriptor == null) {
                throw new ValidationException(new LocalizedMessage(1, ResourceHandler.getExternalizedMessage("VBF_NO_DELEGATE", new String[]{vmd.getValidatorDisplayName()})));
            }
        }
        IValidatorJob delegate = (IValidatorJob)delegateDescriptor.getValidator();
        DelegatingReporter delegatingReporter = new DelegatingReporter(this, reporter);
        IStatus status = delegate.validateInJob(helper, delegatingReporter);
        return status;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        return null;
    }

    private class DelegatingReporter
    implements IReporter {
        IReporter delegatingReporter;
        IValidator delegatingValidator;

        DelegatingReporter(IValidator validator, IReporter reporter) {
            this.delegatingReporter = reporter;
            this.delegatingValidator = validator;
        }

        public void addMessage(IValidator origin, IMessage message) {
            this.delegatingReporter.addMessage(this.delegatingValidator, message);
        }

        public void displaySubtask(IValidator validator, IMessage message) {
            this.delegatingReporter.displaySubtask(this.delegatingValidator, message);
        }

        public List getMessages() {
            return this.delegatingReporter.getMessages();
        }

        public boolean isCancelled() {
            return this.delegatingReporter.isCancelled();
        }

        public void removeAllMessages(IValidator origin) {
            this.delegatingReporter.removeAllMessages(this.delegatingValidator);
        }

        public void removeAllMessages(IValidator origin, Object object) {
            this.delegatingReporter.removeAllMessages(this.delegatingValidator, object);
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
            this.delegatingReporter.removeMessageSubset(this.delegatingValidator, obj, groupName);
        }
    }
}

