/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class AddTypeParameterProposal
extends LinkedCorrectionProposal {
    private IBinding fBinding;
    private JavaScriptUnit fAstRoot;
    private final String fTypeParamName;
    private final ITypeBinding[] fBounds;

    public AddTypeParameterProposal(IJavaScriptUnit targetCU, IBinding binding, JavaScriptUnit astRoot, String name, ITypeBinding[] bounds, int relevance) {
        super("", targetCU, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.field_public_obj.gif"));
        Assert.isTrue((binding != null && Bindings.isDeclarationBinding(binding) ? 1 : 0) != 0);
        Assert.isTrue((binding instanceof IFunctionBinding || binding instanceof ITypeBinding ? 1 : 0) != 0);
        this.fBinding = binding;
        this.fAstRoot = astRoot;
        this.fTypeParamName = name;
        this.fBounds = bounds;
        if (binding instanceof IFunctionBinding) {
            boolean isSameCU = this.fAstRoot.findDeclaringNode(binding) != null;
            Object[] args = new String[]{this.fTypeParamName, ASTResolving.getMethodSignature((IFunctionBinding)binding, isSameCU)};
            this.setDisplayName(Messages.format(CorrectionMessages.AddTypeParameterProposal_method_label, args));
        } else {
            Object[] args = new String[]{this.fTypeParamName, ASTResolving.getTypeSignature((ITypeBinding)binding)};
            this.setDisplayName(Messages.format(CorrectionMessages.AddTypeParameterProposal_type_label, args));
        }
    }

    protected ASTRewrite getRewrite() throws CoreException {
        JSdoc javadoc;
        List otherTypeParams;
        ListRewrite listRewrite;
        TypeDeclaration declaration;
        ASTNode boundNode = this.fAstRoot.findDeclaringNode(this.fBinding);
        ASTNode declNode = null;
        if (boundNode != null) {
            declNode = boundNode;
            this.createImportRewrite(this.fAstRoot);
        } else {
            JavaScriptUnit newRoot = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            declNode = newRoot.findDeclaringNode(this.fBinding.getKey());
            this.createImportRewrite(newRoot);
        }
        AST ast = declNode.getAST();
        TypeParameter newTypeParam = ast.newTypeParameter();
        newTypeParam.setName(ast.newSimpleName(this.fTypeParamName));
        if (this.fBounds != null && this.fBounds.length > 0) {
            List typeBounds = newTypeParam.typeBounds();
            int i = 0;
            while (i < this.fBounds.length) {
                Type newBound = this.getImportRewrite().addImport(this.fBounds[i], ast);
                typeBounds.add(newBound);
                ++i;
            }
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (declNode instanceof TypeDeclaration) {
            declaration = (TypeDeclaration)declNode;
            listRewrite = rewrite.getListRewrite((ASTNode)declaration, TypeDeclaration.TYPE_PARAMETERS_PROPERTY);
            otherTypeParams = declaration.typeParameters();
            javadoc = declaration.getJavadoc();
        } else {
            declaration = (FunctionDeclaration)declNode;
            listRewrite = rewrite.getListRewrite(declNode, FunctionDeclaration.TYPE_PARAMETERS_PROPERTY);
            otherTypeParams = declaration.typeParameters();
            javadoc = declaration.getJavadoc();
        }
        listRewrite.insertLast((ASTNode)newTypeParam, null);
        if (javadoc != null && otherTypeParams != null) {
            ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, JSdoc.TAGS_PROPERTY);
            Set previousNames = JavadocTagsSubProcessor.getPreviousTypeParamNames(otherTypeParams, null);
            String name = String.valueOf('<') + this.fTypeParamName + '>';
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@param");
            TextElement text = ast.newTextElement();
            text.setText(name);
            newTag.fragments().add(text);
            JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, previousNames);
        }
        return rewrite;
    }
}

