/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.inheritance.BeanInheritedMetaData;
import org.apache.webbeans.config.inheritance.IBeanInheritedMetaData;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.InjectableField;
import org.apache.webbeans.inject.InjectableMethods;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InvocationContextImpl;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInjectionTargetBean<T>
extends AbstractOwbBean<T>
implements InjectionTargetBean<T> {
    private Set<Method> observableMethods = new HashSet<Method>();
    private Set<Field> injectedFields = new HashSet<Field>();
    private Set<Method> injectedMethods = new HashSet<Method>();
    private Set<Field> injectedFromSuperFields = new HashSet<Field>();
    private Set<Method> injectedFromSuperMethods = new HashSet<Method>();
    private AnnotatedType<T> annotatedType;
    protected List<InterceptorData> interceptorStack = new ArrayList<InterceptorData>();
    protected List<Decorator<?>> decorators = new ArrayList();
    protected IBeanInheritedMetaData inheritedMetaData;

    protected AbstractInjectionTargetBean(WebBeansType webBeansType, Class<T> returnType, WebBeansContext webBeansContext) {
        super(webBeansType, returnType, webBeansContext);
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        T instance = this.createDefaultInstance(creationalContext);
        return instance;
    }

    protected T createDefaultInstance(CreationalContext<T> creationalContext) {
        Object result;
        this.beforeConstructor();
        T instance = this.createComponentInstance(creationalContext);
        Object dependentProxy = null;
        boolean isDependentProxy = false;
        if (this.getScope() == Dependent.class && !(this instanceof EnterpriseBeanMarker) && JavassistProxyFactory.isProxyInstance(result = this.getWebBeansContext().getJavassistProxyFactory().createDependentScopedBeanProxy(this, instance, creationalContext))) {
            this.injectResources(instance, creationalContext);
            this.injectSuperFields(instance, creationalContext);
            this.injectSuperMethods(instance, creationalContext);
            this.injectFields(instance, creationalContext);
            this.injectMethods(instance, creationalContext);
            dependentProxy = result;
            isDependentProxy = true;
        }
        if (isDependentProxy) {
            return (T)dependentProxy;
        }
        return instance;
    }

    @Override
    protected void destroyInstance(T instance, CreationalContext<T> creationalContext) {
        this.destroyComponentInstance(instance, creationalContext);
    }

    protected T createComponentInstance(CreationalContext<T> creationalContext) {
        return null;
    }

    protected void destroyComponentInstance(T instance, CreationalContext<T> creationalContext) {
        this.preDestroy(instance, creationalContext);
    }

    protected void beforeConstructor() {
    }

    protected void afterConstructor(T instance, CreationalContext<T> creationalContext) {
        this.injectResources(instance, creationalContext);
        this.injectSuperFields(instance, creationalContext);
        this.injectSuperMethods(instance, creationalContext);
        this.injectFields(instance, creationalContext);
        this.injectMethods(instance, creationalContext);
        this.postConstruct(instance, creationalContext);
    }

    @Override
    public void postConstruct(T instance, CreationalContext<T> cretionalContext) {
        this.postConstructDefault(instance, cretionalContext);
    }

    protected void postConstructDefault(T instance, CreationalContext<T> ownerCreationalContext) {
        if (this.getWebBeansType().equals((Object)WebBeansType.MANAGED) && WebBeansUtil.isContainsInterceptorMethod(this.getInterceptorStack(), InterceptorType.POST_CONSTRUCT)) {
            InvocationContextImpl impl = new InvocationContextImpl(this.getWebBeansContext(), null, instance, null, null, this.getWebBeansContext().getInterceptorUtil().getInterceptorMethods(this.getInterceptorStack(), InterceptorType.POST_CONSTRUCT), InterceptorType.POST_CONSTRUCT);
            impl.setCreationalContext(ownerCreationalContext);
            try {
                impl.proceed();
            }
            catch (Exception e) {
                this.getLogger().error("ERROR_0008", e, "@PostConstruct.");
                throw new WebBeansException(e);
            }
        }
    }

    @Override
    public void preDestroy(T instance, CreationalContext<T> creationalContext) {
        this.preDestroyDefault(instance, creationalContext);
    }

    protected void preDestroyDefault(T instance, CreationalContext<T> creationalContext) {
        if ((this.getWebBeansType().equals((Object)WebBeansType.MANAGED) || this.getWebBeansType().equals((Object)WebBeansType.DECORATOR)) && WebBeansUtil.isContainsInterceptorMethod(this.getInterceptorStack(), InterceptorType.PRE_DESTROY)) {
            InvocationContextImpl impl = new InvocationContextImpl(this.getWebBeansContext(), null, instance, null, null, this.getWebBeansContext().getInterceptorUtil().getInterceptorMethods(this.getInterceptorStack(), InterceptorType.PRE_DESTROY), InterceptorType.PRE_DESTROY);
            impl.setCreationalContext(creationalContext);
            try {
                impl.proceed();
            }
            catch (Exception e) {
                this.getLogger().error("ERROR_0008", e, "@PreDestroy.");
                throw new WebBeansException(e);
            }
        }
    }

    @Override
    public void injectFields(T instance, CreationalContext<T> creationalContext) {
        Set<Field> fields = this.getInjectedFields();
        for (Field field : fields) {
            if (field.getAnnotation(Delegate.class) != null) continue;
            if (!field.getType().equals(InjectionPoint.class)) {
                this.injectField(field, instance, creationalContext);
                continue;
            }
            Bean<?> injectionPointBean = this.getManager().getBeans((Type)((Object)InjectionPoint.class), new Annotation[]{new DefaultLiteral()}).iterator().next();
            Object reference = this.getManager().getReference(injectionPointBean, (Type)((Object)InjectionPoint.class), this.getManager().createCreationalContext(injectionPointBean));
            this.setField(instance, field, reference);
        }
    }

    private void setField(T instance, Field field, Object value) {
        if (!field.isAccessible()) {
            this.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)field, true);
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalArgumentException e) {
            throw new WebBeansException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebBeansException(e);
        }
    }

    @Override
    public void injectSuperFields(T instance, CreationalContext<T> creationalContext) {
        Set<Field> fields = this.getInjectedFromSuperFields();
        for (Field field : fields) {
            if (field.getAnnotation(Delegate.class) != null) continue;
            this.injectField(field, instance, creationalContext);
        }
    }

    @Override
    public void injectSuperMethods(T instance, CreationalContext<T> creationalContext) {
        Set<Method> methods = this.getInjectedFromSuperMethods();
        for (Method method : methods) {
            this.injectMethod(method, instance, creationalContext);
        }
    }

    private void injectField(Field field, Object instance, CreationalContext<?> creationalContext) {
        InjectableField f = new InjectableField(field, instance, this, creationalContext);
        f.doInjection();
    }

    @Override
    public void injectMethods(T instance, CreationalContext<T> creationalContext) {
        Set<Method> methods = this.getInjectedMethods();
        for (Method method : methods) {
            this.injectMethod(method, instance, creationalContext);
        }
    }

    private void injectMethod(Method method, Object instance, CreationalContext<?> creationalContext) {
        InjectableMethods m = new InjectableMethods(method, instance, this, creationalContext);
        m.doInjection();
    }

    @Override
    public void injectResources(T instance, CreationalContext<T> creationalContext) {
        if (this.getWebBeansType().equals((Object)WebBeansType.MANAGED)) {
            try {
                ResourceInjectionService service = null;
                try {
                    service = this.getWebBeansContext().getService(ResourceInjectionService.class);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (service != null) {
                    service.injectJavaEEResources(instance);
                }
            }
            catch (Exception e) {
                this.getLogger().error("ERROR_0023", instance);
                throw new WebBeansException(MessageFormat.format(this.getLogger().getTokenString("ERROR_0023"), instance), e);
            }
        }
    }

    @Override
    public void addObservableMethod(Method observerMethod) {
        this.observableMethods.add(observerMethod);
    }

    @Override
    public Set<Method> getObservableMethods() {
        return this.observableMethods;
    }

    @Override
    public Set<Field> getInjectedFields() {
        return this.injectedFields;
    }

    @Override
    public void addInjectedField(Field field) {
        this.injectedFields.add(field);
    }

    @Override
    public Set<Field> getInjectedFromSuperFields() {
        return this.injectedFromSuperFields;
    }

    @Override
    public void addInjectedFieldToSuper(Field field) {
        this.injectedFromSuperFields.add(field);
    }

    @Override
    public Set<Method> getInjectedMethods() {
        return this.injectedMethods;
    }

    @Override
    public void addInjectedMethod(Method method) {
        this.injectedMethods.add(method);
    }

    @Override
    public Set<Method> getInjectedFromSuperMethods() {
        return this.injectedFromSuperMethods;
    }

    @Override
    public void addInjectedMethodToSuper(Method method) {
        this.injectedFromSuperMethods.add(method);
    }

    @Override
    public List<InterceptorData> getInterceptorStack() {
        return this.interceptorStack;
    }

    @Override
    public List<Decorator<?>> getDecoratorStack() {
        return this.decorators;
    }

    @Override
    public IBeanInheritedMetaData getInheritedMetaData() {
        return this.inheritedMetaData;
    }

    protected void setInheritedMetaData() {
        this.inheritedMetaData = new BeanInheritedMetaData(this);
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return super.getInjectionPoints();
    }

    @Override
    public AnnotatedType<T> getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    public void setAnnotatedType(AnnotatedType<T> annotatedType) {
        this.annotatedType = annotatedType;
    }

    @Override
    public void validatePassivationDependencies() {
        super.validatePassivationDependencies();
        for (Decorator<?> dec : this.decorators) {
            WebBeansDecorator decorator = (WebBeansDecorator)dec;
            if (!decorator.isPassivationCapable()) {
                throw new WebBeansConfigurationException(MessageFormat.format(this.getLogger().getTokenString("EXCEPT_0015"), this.toString()));
            }
            decorator.validatePassivationDependencies();
        }
        for (InterceptorData interceptorData : this.interceptorStack) {
            if (interceptorData.isDefinedWithWebBeansInterceptor()) {
                WebBeansInterceptor interceptor = (WebBeansInterceptor)interceptorData.getWebBeansInterceptor();
                if (!interceptor.isPassivationCapable()) {
                    throw new WebBeansConfigurationException(MessageFormat.format(this.getLogger().getTokenString("EXCEPT_0016"), this.toString()));
                }
                interceptor.validatePassivationDependencies();
                continue;
            }
            if (!interceptorData.isDefinedInInterceptorClass()) continue;
            Class<?> interceptorClass = interceptorData.getInterceptorClass();
            if (!Serializable.class.isAssignableFrom(interceptorClass)) {
                throw new WebBeansConfigurationException(MessageFormat.format(this.getLogger().getTokenString("EXCEPT_0016"), this.toString()));
            }
            if (this.getWebBeansContext().getAnnotationManager().checkInjectionPointForInterceptorPassivation(interceptorClass)) continue;
            throw new WebBeansConfigurationException(MessageFormat.format(this.getLogger().getTokenString("EXCEPT_0017"), this.toString(), interceptorClass));
        }
    }
}

