/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.Resolver;
import org.eclipse.equinox.internal.ds.SCRManager;
import org.eclipse.equinox.internal.ds.SCRUtil;
import org.eclipse.equinox.internal.ds.impl.ComponentInstanceImpl;
import org.eclipse.equinox.internal.ds.model.ComponentReference;
import org.eclipse.equinox.internal.ds.model.DeclarationParser;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;

public class SCRCommandProvider
implements CommandProvider {
    private Resolver resolver;
    private SCRManager scrManager;
    private int curID = 1;
    private Hashtable componentRefsIDs = null;

    protected SCRCommandProvider(SCRManager scrManager) {
        this.scrManager = scrManager;
        this.resolver = InstanceProcess.resolver;
    }

    public String getHelp() {
        return this.getHelp(null);
    }

    private String getHelp(String commandName) {
        boolean all = commandName == null;
        StringBuffer res = new StringBuffer(1000);
        if (all) {
            res.append("---").append(Messages.SCR).append("---\r\n");
        }
        if (all || "list".equals(commandName) || "ls".equals(commandName)) {
            res.append("\tlist/ls [-c] [bundle id] - ").append(Messages.LIST_ALL_COMPONENTS);
            res.append("\r\n\t\t\t").append(Messages.LIST_ALL_BUNDLE_COMPONENTS);
        }
        if (all || "component".equals(commandName) || "comp".equals(commandName)) {
            res.append("\r\n\tcomponent/comp <component id> - ").append(Messages.PRINT_COMPONENT_INFO);
            res.append("\r\n\t\t\t<component id> - ").append(Messages.COMPONENT_ID_DEFINIED_BY_LIST_COMMAND);
        }
        if (all || "enable".equals(commandName) || "en".equals(commandName)) {
            res.append("\r\n\tenable/en <component id> - ").append(Messages.ENABLE_COMPONENT);
            res.append("\r\n\t\t\t<component id> - ").append(Messages.COMPONENT_ID_DEFINIED_BY_LIST_COMMAND);
        }
        if (all || "disable".equals(commandName) || "dis".equals(commandName)) {
            res.append("\n\tdisable/dis <component id> - ").append(Messages.DISABLE_COMPONENT);
            res.append("\n\t\t\t<component id> - ").append(Messages.COMPONENT_ID_DEFINIED_BY_LIST_COMMAND);
        }
        if (all || "enableAll".equals(commandName) || "enAll".equals(commandName)) {
            res.append("\r\n\tenableAll/enAll [bundle id] - ").append(Messages.ENABLE_ALL_COMPONENTS);
        }
        if (all || "disableAll".equals(commandName) || "disAll".equals(commandName)) {
            res.append("\n\tdisableAll/disAll [bundle id] - ").append(Messages.DISABLE_ALL_COMPONENTS).append("\n");
        }
        return res.toString();
    }

    public void _list(CommandInterpreter intp) throws Exception {
        boolean completeInfo = false;
        Bundle b = null;
        String[] params = this.getParams(intp);
        if (params.length > 0) {
            if (params[0].equals("-c")) {
                completeInfo = true;
                if (params.length > 1 && (b = this.getBundle(intp, params[1])) == null) {
                    return;
                }
            } else {
                b = this.getBundle(intp, params[0]);
                if (b == null) {
                    return;
                }
            }
        }
        this.listComponents(intp, b, completeInfo);
    }

    public void _ls(CommandInterpreter intp) throws Exception {
        this._list(intp);
    }

    public void _component(CommandInterpreter intp) throws Exception {
        String[] params = this.getParams(intp);
        if (params.length > 0) {
            int compIndex = -1;
            try {
                compIndex = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException numberFormatException) {
                intp.println((Object)NLS.bind((String)Messages.WRONG_PARAMETER, (Object)params[0]));
                return;
            }
            this.printComponentDetails(intp, compIndex);
            return;
        }
        intp.println((Object)Messages.EXPECTED_PARAMETER_COMPONENT_ID);
    }

    public void _comp(CommandInterpreter intp) throws Exception {
        this._component(intp);
    }

    public void _enable(CommandInterpreter intp) throws Exception {
        String[] params = this.getParams(intp);
        if (params.length > 0) {
            int compIndex = -1;
            try {
                compIndex = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException numberFormatException) {
                intp.println((Object)NLS.bind((String)Messages.WRONG_PARAMETER, (Object)params[0]));
                return;
            }
            this.enableComponent(intp, compIndex);
            return;
        }
        intp.println((Object)Messages.EXPECTED_PARAMETER_COMPONENT_ID);
    }

    public void _en(CommandInterpreter intp) throws Exception {
        this._enable(intp);
    }

    public void _disable(CommandInterpreter intp) throws Exception {
        String[] params = this.getParams(intp);
        if (params.length > 0) {
            int compIndex = -1;
            try {
                compIndex = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException numberFormatException) {
                intp.println((Object)NLS.bind((String)Messages.WRONG_PARAMETER, (Object)params[0]));
                return;
            }
            this.disableComponent(intp, compIndex);
            return;
        }
        intp.println((Object)Messages.EXPECTED_PARAMETER_COMPONENT_ID);
    }

    public void _dis(CommandInterpreter intp) throws Exception {
        this._disable(intp);
    }

    public void _enableAll(CommandInterpreter intp) throws Exception {
        String[] params = this.getParams(intp);
        Bundle b = null;
        if (params.length > 0 && (b = this.getBundle(intp, params[0])) == null) {
            return;
        }
        this.enableAll(intp, b);
    }

    public void _enAll(CommandInterpreter intp) throws Exception {
        this._enableAll(intp);
    }

    public void _disableAll(CommandInterpreter intp) throws Exception {
        String[] params = this.getParams(intp);
        Bundle b = null;
        if (params.length > 0 && (b = this.getBundle(intp, params[0])) == null) {
            return;
        }
        this.disableAll(intp, b);
    }

    public void _disAll(CommandInterpreter intp) throws Exception {
        this._disableAll(intp);
    }

    public Object _help(CommandInterpreter intp) {
        String commandName = intp.nextArgument();
        if (commandName == null) {
            return Boolean.FALSE;
        }
        String help = this.getHelp(commandName);
        if (help.length() > 0) {
            return help;
        }
        return Boolean.FALSE;
    }

    private String[] getParams(CommandInterpreter intp) {
        Vector<String> arguments = new Vector<String>();
        String arg = intp.nextArgument();
        while (arg != null) {
            if (arg != null) {
                arguments.addElement(arg);
            }
            arg = intp.nextArgument();
        }
        Object[] res = new String[arguments.size()];
        arguments.copyInto(res);
        return res;
    }

    private Bundle getBundle(CommandInterpreter intp, String bidString) {
        long bid = -1L;
        try {
            bid = Long.parseLong(bidString);
        }
        catch (NumberFormatException numberFormatException) {
            intp.println((Object)NLS.bind((String)Messages.WRONG_PARAMETER2, (Object)bidString));
            return null;
        }
        Bundle b = Activator.bc.getBundle(bid);
        if (b == null) {
            intp.println((Object)NLS.bind((String)Messages.BUNDLE_NOT_FOUND, (Object)bidString));
        }
        return b;
    }

    private ComponentRef findComponentWithID(int compID) {
        if (this.componentRefsIDs != null) {
            Enumeration keys = this.componentRefsIDs.keys();
            while (keys.hasMoreElements()) {
                ComponentRef key = (ComponentRef)keys.nextElement();
                if (key.id != compID) continue;
                return key;
            }
        }
        return null;
    }

    private void printComponentDetails(CommandInterpreter intp, int componentIndex) {
        ComponentRef cRef = this.findComponentWithID(componentIndex);
        if (cRef == null) {
            intp.println((Object)Messages.INVALID_COMPONENT_ID);
            return;
        }
        Bundle b = Activator.bc.getBundle(cRef.bid);
        if (b != null) {
            Vector components = (Vector)this.scrManager.bundleToServiceComponents.get(b);
            if (components != null) {
                int i = 0;
                while (i < components.size()) {
                    ServiceComponent sc = (ServiceComponent)components.elementAt(i);
                    if (sc.name.equals(cRef.name)) {
                        this.printComponentDetails(intp, sc);
                        break;
                    }
                    ++i;
                }
            }
        } else {
            intp.println((Object)Messages.CANNOT_FIND_COMPONENT_BUNDLE);
        }
    }

    private void printComponentDetails(CommandInterpreter intp, ServiceComponent sc) {
        int i;
        intp.println((Object)("\t" + sc.toString()));
        intp.println((Object)Messages.DYNAMIC_INFO);
        Vector unresulvedReferences = this.getUnresolvedReferences(sc);
        boolean resolved = true;
        if (unresulvedReferences != null) {
            i = 0;
            while (i < unresulvedReferences.size()) {
                if (this.isMandatory((ComponentReference)unresulvedReferences.elementAt(i))) {
                    resolved = false;
                    break;
                }
                ++i;
            }
        }
        if (resolved) {
            intp.println((Object)Messages.COMPONENT_RESOLVED);
        } else {
            intp.println((Object)Messages.COMPONENT_NOT_RESOLVED);
        }
        if (unresulvedReferences != null) {
            intp.println((Object)Messages.NOT_RESOLVED_REFERENCES);
            i = 0;
            while (i < unresulvedReferences.size()) {
                intp.println((Object)("    " + unresulvedReferences.elementAt(i)));
                ++i;
            }
        } else {
            intp.println((Object)Messages.ALL_REFERENCES_RESOLVED);
        }
        intp.println((Object)Messages.COMPONENT_CONFIGURATIONS);
        Vector enabledSCPs = (Vector)this.resolver.scpEnabled.clone();
        int i2 = 0;
        while (i2 < enabledSCPs.size()) {
            ServiceComponentProp scp = (ServiceComponentProp)enabledSCPs.elementAt(i2);
            if (scp.serviceComponent == sc) {
                this.printSCP(intp, scp);
            }
            ++i2;
        }
        if (sc.getConfigurationPolicy() == "require" && resolved && (sc.componentProps == null || sc.componentProps.size() == 0)) {
            intp.println((Object)Messages.NO_BUILT_COMPONENT_CONFIGURATIONS);
        }
        intp.println();
    }

    private void printSCP(CommandInterpreter intp, ServiceComponentProp scp) {
        Hashtable props = scp.properties;
        intp.println((Object)Messages.CONFIG_PROPERTIES);
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = props.get(key);
            intp.print((Object)("      " + key + " = "));
            intp.print((Object)SCRUtil.getStringRepresentation(value));
            intp.println();
        }
        intp.println((Object)"    Instances:");
        if (scp.instances.size() > 0) {
            ComponentInstanceImpl instance = null;
            int i = 0;
            while (i < scp.instances.size()) {
                instance = (ComponentInstanceImpl)scp.instances.elementAt(i);
                intp.println((Object)("      " + instance));
                if (instance.bindedServices.size() > 0) {
                    intp.println((Object)"    \tBound References:");
                    Enumeration refs = instance.bindedServices.keys();
                    ServiceReference sr = null;
                    while (refs.hasMoreElements()) {
                        sr = (ServiceReference)refs.nextElement();
                        Object interfaces = sr.getProperty("objectClass");
                        intp.println((Object)("        " + SCRUtil.getStringRepresentation(interfaces)));
                        intp.println((Object)("      \t\t-> " + instance.bindedServices.get(sr)));
                    }
                }
                ++i;
            }
        } else {
            String issues = scp.serviceComponent.getComponentIssues();
            if (issues != null) {
                intp.println((Object)("    No instances were created because: " + issues));
            }
        }
    }

    private Vector getUnresolvedReferences(ServiceComponent sc) {
        Vector<ComponentReference> unresolved = new Vector<ComponentReference>();
        if (sc.references != null) {
            int i = 0;
            while (i < sc.references.size()) {
                ComponentReference ref = (ComponentReference)sc.references.elementAt(i);
                if (!this.hasProviders(ref)) {
                    unresolved.addElement(ref);
                }
                ++i;
            }
        }
        return unresolved.isEmpty() ? null : unresolved;
    }

    private boolean hasProviders(ComponentReference ref) {
        if (System.getSecurityManager() != null && !ref.component.bc.getBundle().hasPermission((Object)new ServicePermission(ref.interfaceName, "get"))) {
            return false;
        }
        try {
            ServiceReference[] serviceReferences = null;
            serviceReferences = ref.component.bc.getServiceReferences(ref.interfaceName, ref.target);
            if (serviceReferences != null) {
                return true;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return false;
    }

    private boolean isMandatory(ComponentReference ref) {
        return ref.cardinality == 2 || ref.cardinality == 3;
    }

    private void enableAll(CommandInterpreter intp, Bundle b) {
        Vector<ServiceComponent> componentsToEnable = new Vector<ServiceComponent>();
        if (b != null) {
            intp.println((Object)NLS.bind((String)Messages.ENABLING_ALL_BUNDLE_COMPONENTS, (Object)this.getBundleRepresentationName(b)));
        } else {
            intp.println((Object)Messages.ENABLING_ALL_COMPONENTS);
        }
        if (b != null) {
            Vector components;
            if (this.scrManager.bundleToServiceComponents != null && (components = (Vector)this.scrManager.bundleToServiceComponents.get(b)) != null) {
                int i = 0;
                while (i < components.size()) {
                    ServiceComponent sc = (ServiceComponent)components.elementAt(i);
                    if (!sc.enabled) {
                        componentsToEnable.addElement(sc);
                        sc.enabled = true;
                    }
                    ++i;
                }
                if (!componentsToEnable.isEmpty()) {
                    this.resolver.enableComponents(componentsToEnable);
                }
            }
        } else if (this.scrManager.bundleToServiceComponents != null) {
            Bundle[] allBundles = Activator.bc.getBundles();
            int j = 0;
            while (j < allBundles.length) {
                Vector components = (Vector)this.scrManager.bundleToServiceComponents.get(allBundles[j]);
                if (components != null) {
                    int i = 0;
                    while (i < components.size()) {
                        ServiceComponent sc = (ServiceComponent)components.elementAt(i);
                        if (!sc.enabled) {
                            componentsToEnable.addElement(sc);
                            sc.enabled = true;
                        }
                        ++i;
                    }
                }
                ++j;
            }
            if (!componentsToEnable.isEmpty()) {
                this.resolver.enableComponents(componentsToEnable);
            }
        }
    }

    private void disableAll(CommandInterpreter intp, Bundle b) {
        Vector<ServiceComponent> componentsToDisable = new Vector<ServiceComponent>();
        if (b != null) {
            intp.println((Object)NLS.bind((String)Messages.DISABLING_ALL_BUNDLE_COMPONENTS, (Object)this.getBundleRepresentationName(b)));
        } else {
            intp.println((Object)Messages.DISABLING_ALL_COMPONENTS);
        }
        if (b != null) {
            Vector components;
            if (this.scrManager.bundleToServiceComponents != null && (components = (Vector)this.scrManager.bundleToServiceComponents.get(b)) != null) {
                int i = 0;
                while (i < components.size()) {
                    ServiceComponent sc = (ServiceComponent)components.elementAt(i);
                    if (sc.enabled) {
                        componentsToDisable.addElement(sc);
                        sc.enabled = false;
                    }
                    ++i;
                }
                if (!componentsToDisable.isEmpty()) {
                    this.resolver.disableComponents(componentsToDisable, 1);
                }
            }
        } else if (this.scrManager.bundleToServiceComponents != null) {
            Bundle[] allBundles = Activator.bc.getBundles();
            int j = 0;
            while (j < allBundles.length) {
                Vector components = (Vector)this.scrManager.bundleToServiceComponents.get(allBundles[j]);
                if (components != null) {
                    int i = 0;
                    while (i < components.size()) {
                        ServiceComponent sc = (ServiceComponent)components.elementAt(i);
                        if (sc.enabled) {
                            componentsToDisable.addElement(sc);
                            sc.enabled = false;
                        }
                        ++i;
                    }
                }
                ++j;
            }
            if (!componentsToDisable.isEmpty()) {
                this.resolver.disableComponents(componentsToDisable, 1);
            }
        }
    }

    private void enableComponent(CommandInterpreter intp, int componentIndex) {
        ComponentRef cRef = this.findComponentWithID(componentIndex);
        if (cRef == null) {
            intp.println((Object)Messages.INVALID_COMPONENT_ID);
            return;
        }
        this.scrManager.enableComponent(cRef.name, Activator.bc.getBundle(cRef.bid));
        intp.println((Object)NLS.bind((String)Messages.SENT_ENABLING_REQUEST, (Object)cRef.name));
    }

    private void disableComponent(CommandInterpreter intp, int componentIndex) {
        ComponentRef cRef = this.findComponentWithID(componentIndex);
        if (cRef == null) {
            intp.println((Object)Messages.INVALID_COMPONENT_ID);
            return;
        }
        this.scrManager.disableComponent(cRef.name, Activator.bc.getBundle(cRef.bid));
        intp.println((Object)NLS.bind((String)Messages.SENT_DISABLING_REQUEST, (Object)cRef.name));
    }

    private void listComponents(CommandInterpreter intp, Bundle b, boolean completeInfo) {
        block23: {
            block22: {
                if (this.componentRefsIDs == null) {
                    this.componentRefsIDs = new Hashtable(101);
                }
                if (b != null) {
                    intp.println((Object)NLS.bind((String)Messages.COMPONENTS_IN_BUNDLE, (Object)this.getBundleRepresentationName(b)));
                    if (this.componentRefsIDs.isEmpty()) {
                        this.initComponentRefs();
                    }
                } else {
                    intp.println((Object)Messages.ALL_COMPONENTS);
                }
                if (b == null || this.scrManager.bundleToServiceComponents != null && this.scrManager.bundleToServiceComponents.get(b) != null) {
                    intp.print((Object)"ID");
                    if (completeInfo) {
                        intp.println((Object)Messages.COMPONENT_DETAILS);
                    } else {
                        intp.print((Object)Messages.STATE);
                        intp.print((Object)Messages.COMPONENT_NAME);
                        intp.println((Object)Messages.LOCATED_IN_BUNDLE);
                    }
                }
                if (b == null) break block22;
                if (this.scrManager.bundleToServiceComponents == null) break block23;
                Vector components = (Vector)this.scrManager.bundleToServiceComponents.get(b);
                if (components != null) {
                    int i = 0;
                    while (i < components.size()) {
                        ServiceComponent sc = (ServiceComponent)components.elementAt(i);
                        ComponentRef aRef = new ComponentRef(b.getBundleId(), sc.name);
                        ComponentRef ref = (ComponentRef)this.componentRefsIDs.get(aRef);
                        if (ref == null) {
                            ref = aRef;
                            ref.id = this.generateID();
                            this.componentRefsIDs.put(ref, ref);
                        }
                        if (completeInfo) {
                            intp.print((Object)String.valueOf(ref.id));
                            this.printComponentDetails(intp, sc);
                        } else {
                            intp.print((Object)("" + ref.id));
                            intp.print((Object)("\t" + SCRUtil.getStateStringRepresentation(sc.getState())));
                            intp.print((Object)("\t\t" + sc.name));
                            intp.println((Object)("\t\t\t" + this.getBundleRepresentationName(b) + "(bid=" + b.getBundleId() + ")"));
                        }
                        ++i;
                    }
                }
                String dsHeader = null;
                Dictionary allHeaders = b.getHeaders("");
                dsHeader = (String)allHeaders.get("Service-Component");
                if (dsHeader == null) {
                    intp.println((Object)("No ServiceComponent header was found in bundle " + b.toString()));
                    return;
                }
                Vector issues = this.parseXMLDeclaration(b, dsHeader);
                if (issues.size() > 0) {
                    intp.println();
                    intp.println((Object)"Issues encountered when parsing components xml declarations");
                    int i = 0;
                    while (i < issues.size()) {
                        intp.println((Object)("\t" + issues.get(i)));
                        intp.println();
                        ++i;
                    }
                }
                break block23;
            }
            if (this.scrManager.bundleToServiceComponents != null) {
                Bundle[] allBundles = Activator.bc.getBundles();
                int j = 0;
                while (j < allBundles.length) {
                    Vector components = (Vector)this.scrManager.bundleToServiceComponents.get(allBundles[j]);
                    if (components != null) {
                        int i = 0;
                        while (i < components.size()) {
                            ServiceComponent sc = (ServiceComponent)components.elementAt(i);
                            ComponentRef aRef = new ComponentRef(allBundles[j].getBundleId(), sc.name);
                            ComponentRef ref = (ComponentRef)this.componentRefsIDs.get(aRef);
                            if (ref == null) {
                                ref = aRef;
                                ref.id = this.generateID();
                                this.componentRefsIDs.put(ref, ref);
                            }
                            if (completeInfo) {
                                intp.print((Object)String.valueOf(ref.id));
                                this.printComponentDetails(intp, sc);
                            } else {
                                intp.print((Object)("" + ref.id));
                                intp.print((Object)("\t" + SCRUtil.getStateStringRepresentation(sc.getState())));
                                intp.print((Object)("\t\t" + sc.name));
                                intp.println((Object)("\t\t\t" + this.getBundleRepresentationName(allBundles[j]) + "(bid=" + allBundles[j].getBundleId() + ")"));
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
            }
        }
    }

    private void initComponentRefs() {
        if (this.scrManager.bundleToServiceComponents != null) {
            Bundle[] allBundles = Activator.bc.getBundles();
            int j = 0;
            while (j < allBundles.length) {
                Vector components = (Vector)this.scrManager.bundleToServiceComponents.get(allBundles[j]);
                if (components != null) {
                    int i = 0;
                    while (i < components.size()) {
                        ServiceComponent sc = (ServiceComponent)components.elementAt(i);
                        ComponentRef aRef = new ComponentRef(allBundles[j].getBundleId(), sc.name);
                        ComponentRef ref = (ComponentRef)this.componentRefsIDs.get(aRef);
                        if (ref == null) {
                            ref = aRef;
                            ref.id = this.generateID();
                            this.componentRefsIDs.put(ref, ref);
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
    }

    private String getBundleRepresentationName(Bundle b) {
        String res = b.getSymbolicName();
        if (res == null) {
            res = "with ID " + b.getBundleId();
        }
        return res;
    }

    private synchronized int generateID() {
        return this.curID++;
    }

    /*
     * Unable to fully structure code
     */
    protected Vector parseXMLDeclaration(Bundle bundle, String dsHeader) {
        block17: {
            componentsIssues = new Vector<String>();
            components = new Vector();
            try {
                if (dsHeader == null) break block17;
                tok = new StringTokenizer(dsHeader, ",");
                parser = new DeclarationParser(true);
                while (tok.hasMoreElements()) {
                    definitionFile = tok.nextToken().trim();
                    ind = definitionFile.lastIndexOf(47);
                    path = ind != -1 ? definitionFile.substring(0, ind) : "/";
                    is = null;
                    urls = bundle.findEntries(path, ind != -1 ? definitionFile.substring(ind + 1) : definitionFile, false);
                    if (urls != null && urls.hasMoreElements()) ** GOTO lbl53
                    componentsIssues.add(NLS.bind((String)Messages.COMPONENT_XML_NOT_FOUND, (Object)bundle.getSymbolicName(), (Object)definitionFile));
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        url = (URL)urls.nextElement();
                        if (Activator.DEBUG) {
                            Activator.log.debug("ComponentStorage.parseXMLDeclaration(): loading " + url.toString(), null);
                        }
                        try {
                            is = url.openStream();
                            if (is == null) {
                                componentsIssues.add(NLS.bind((String)Messages.CANT_OPEN_STREAM_TO_COMPONENT_XML, (Object)url));
                            } else {
                                try {
                                    parser.parse(is, bundle, components, url.toString());
                                }
                                catch (Exception e) {
                                    componentsIssues.add(e.getMessage());
                                }
                            }
                        }
                        catch (IOException ie) {
                            componentsIssues.add(String.valueOf(NLS.bind((String)Messages.ERROR_OPENING_COMP_XML, (Object)url)) + "\n\t" + ie);
                            if (is == null) continue;
                            is.close();
                            continue;
                        }
                        catch (Throwable t) {
                            try {
                                componentsIssues.add(String.valueOf(NLS.bind((String)Messages.ILLEGAL_DEFINITION_FILE, (Object)url)) + "\n\t" + t);
                                continue;
                            }
                            catch (Throwable var14_18) {
                                throw var14_18;
                            }
                            finally {
                                if (is != null) {
                                    is.close();
                                }
                            }
                        }
                        if (is == null) continue;
                        is.close();
lbl53:
                        // 6 sources

                        ** while (urls.hasMoreElements())
                    }
lbl54:
                    // 1 sources

                }
                components = parser.components;
                parser.components = null;
            }
            catch (Exception e) {
                componentsIssues.add("Exception [" + e + "] while parsing DS xml definition.");
            }
        }
        return componentsIssues;
    }

    private static class ComponentRef {
        long bid;
        String name;
        int id = -1;

        public ComponentRef(long bid, String name) {
            this.bid = bid;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o instanceof ComponentRef) {
                ComponentRef obj = (ComponentRef)o;
                return obj.bid == this.bid && this.name.equals(obj.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

