/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee.oejb3;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.PropertiesAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"moduleName", "properties", "ejbDeployment"})
@XmlRootElement(name="openejb-jar")
public class OpenejbJar
implements NamedModule {
    @XmlElement(name="properties")
    @XmlJavaTypeAdapter(value=PropertiesAdapter.class)
    protected Properties properties;
    @XmlElement(name="module-name")
    protected String moduleName;
    @XmlElement(name="ejb-deployment", required=true)
    protected List<EjbDeployment> ejbDeployment;

    public List<EjbDeployment> getEjbDeployment() {
        if (this.ejbDeployment == null) {
            this.ejbDeployment = new ArrayList<EjbDeployment>();
        }
        return this.ejbDeployment;
    }

    public Map<String, EjbDeployment> getDeploymentsById() {
        LinkedHashMap<String, EjbDeployment> map = new LinkedHashMap<String, EjbDeployment>();
        for (EjbDeployment deployment : this.getEjbDeployment()) {
            map.put(deployment.getDeploymentId(), deployment);
        }
        return map;
    }

    public Map<String, EjbDeployment> getDeploymentsByEjbName() {
        LinkedHashMap<String, EjbDeployment> map = new LinkedHashMap<String, EjbDeployment>();
        for (EjbDeployment deployment : this.getEjbDeployment()) {
            map.put(deployment.getEjbName(), deployment);
        }
        return map;
    }

    @Override
    public String getId() {
        return this.getModuleName();
    }

    @Override
    public void setId(String id) {
        this.setModuleName(id);
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public int getEjbDeploymentCount() {
        return this.getEjbDeployment().size();
    }

    public EjbDeployment addEjbDeployment(EjbDeployment ejbDeployment) {
        this.getEjbDeployment().add(ejbDeployment);
        return ejbDeployment;
    }

    public void removeEjbDeployment(EjbDeployment ejbDeployment) {
        this.getEjbDeployment().remove(ejbDeployment);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public EjbDeployment addEjbDeployment(EnterpriseBean bean) {
        return this.addEjbDeployment(new EjbDeployment(bean));
    }
}

