/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.EntityManagerFactoryCallable;
import org.apache.openejb.assembler.classic.EntityManagerFactoryThreadFactory;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.ReloadableEntityManagerFactory;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.PersistenceClassLoaderHandler;
import org.apache.openejb.persistence.PersistenceUnitInfoImpl;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class PersistenceBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, PersistenceBuilder.class);
    private final PersistenceClassLoaderHandler persistenceClassLoaderHandler;

    public PersistenceBuilder(PersistenceClassLoaderHandler persistenceClassLoaderHandler) {
        this.persistenceClassLoaderHandler = persistenceClassLoaderHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReloadableEntityManagerFactory createEntityManagerFactory(PersistenceUnitInfo info, ClassLoader classLoader) throws Exception {
        long time;
        ReloadableEntityManagerFactory reloadableEntityManagerFactory;
        PersistenceUnitInfoImpl unitInfo = new PersistenceUnitInfoImpl(this.persistenceClassLoaderHandler);
        unitInfo.setId(info.id);
        unitInfo.setPersistenceUnitName(info.name);
        unitInfo.setPersistenceProviderClassName(info.provider);
        unitInfo.setClassLoader(classLoader);
        unitInfo.setExcludeUnlistedClasses(info.excludeUnlistedClasses);
        Context context = ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext();
        String jtaDataSourceId = info.jtaDataSource;
        unitInfo.setJtaDataSourceName(jtaDataSourceId);
        if (jtaDataSourceId != null && !SystemInstance.get().hasProperty("openejb.geronimo")) {
            String initialJndiName = jtaDataSourceId;
            try {
                if (!jtaDataSourceId.startsWith("java:openejb/Resource/") && !jtaDataSourceId.startsWith("openejb/Resource/")) {
                    jtaDataSourceId = "openejb/Resource/" + jtaDataSourceId;
                }
                DataSource jtaDataSource = (DataSource)context.lookup(jtaDataSourceId);
                unitInfo.setJtaDataSource(jtaDataSource);
            }
            catch (NamingException e) {
                try {
                    unitInfo.setJtaDataSource((DataSource)new InitialContext().lookup(initialJndiName));
                }
                catch (NamingException ne) {
                    throw new OpenEJBException("Could not lookup <jta-data-source> '" + jtaDataSourceId + "' for unit '" + unitInfo.getPersistenceUnitName() + "'", e);
                }
            }
        }
        unitInfo.setManagedClassNames(info.classes);
        unitInfo.setMappingFileNames(info.mappingFiles);
        unitInfo.setProperties(info.properties);
        unitInfo.setPersistenceXMLSchemaVersion(info.persistenceXMLSchemaVersion);
        SharedCacheMode sharedCacheMode = Enum.valueOf(SharedCacheMode.class, info.sharedCacheMode);
        unitInfo.setSharedCacheMode(sharedCacheMode);
        ValidationMode validationMode = Enum.valueOf(ValidationMode.class, info.validationMode);
        unitInfo.setValidationMode(validationMode);
        PersistenceUnitTransactionType type = Enum.valueOf(PersistenceUnitTransactionType.class, info.transactionType);
        unitInfo.setTransactionType(type);
        String nonJtaDataSourceId = info.nonJtaDataSource;
        unitInfo.setNonJtaDataSourceName(nonJtaDataSourceId);
        if (nonJtaDataSourceId != null && !SystemInstance.get().hasProperty("openejb.geronimo")) {
            String initialJndiName = nonJtaDataSourceId;
            try {
                if (!nonJtaDataSourceId.startsWith("java:openejb/Resource/")) {
                    nonJtaDataSourceId = "java:openejb/Resource/" + nonJtaDataSourceId;
                }
                DataSource nonJtaDataSource = (DataSource)context.lookup(nonJtaDataSourceId);
                unitInfo.setNonJtaDataSource(nonJtaDataSource);
            }
            catch (NamingException e) {
                try {
                    unitInfo.setNonJtaDataSource((DataSource)new InitialContext().lookup(initialJndiName));
                }
                catch (NamingException ne) {
                    throw new OpenEJBException("Could not lookup <non-jta-data-source> '" + nonJtaDataSourceId + "' for unit '" + unitInfo.getPersistenceUnitName() + "'", e);
                }
            }
        }
        unitInfo.setRootUrlAndJarUrls(info.persistenceUnitRootUrl, info.jarFiles);
        String persistenceProviderClassName = unitInfo.getPersistenceProviderClassName();
        unitInfo.setPersistenceProviderClassName(persistenceProviderClassName);
        long start = System.nanoTime();
        try {
            EntityManagerFactoryCallable callable = new EntityManagerFactoryCallable(persistenceProviderClassName, unitInfo);
            reloadableEntityManagerFactory = new ReloadableEntityManagerFactory(classLoader, PersistenceBuilder.createEmf(classLoader, callable), callable);
            time = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        catch (Throwable throwable) {
            long time2 = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            logger.info("assembler.buildingPersistenceUnit", unitInfo.getPersistenceUnitName(), unitInfo.getPersistenceProviderClassName(), time2 + "");
            if (logger.isDebugEnabled()) {
                for (Map.Entry<Object, Object> entry : unitInfo.getProperties().entrySet()) {
                    logger.debug(entry.getKey() + "=" + entry.getValue());
                }
            }
            throw throwable;
        }
        logger.info("assembler.buildingPersistenceUnit", unitInfo.getPersistenceUnitName(), unitInfo.getPersistenceProviderClassName(), time + "");
        if (logger.isDebugEnabled()) {
            for (Map.Entry<Object, Object> entry : unitInfo.getProperties().entrySet()) {
                logger.debug(entry.getKey() + "=" + entry.getValue());
            }
        }
        return reloadableEntityManagerFactory;
    }

    public static String getOpenEJBJndiName(String unit) {
        return "openejb/PersistenceUnit/" + unit;
    }

    public static EntityManagerFactory createEmf(ClassLoader classLoader, Callable<EntityManagerFactory> callable) throws ExecutionException, TimeoutException, InterruptedException {
        ExecutorService executor = Executors.newSingleThreadExecutor(new EntityManagerFactoryThreadFactory(classLoader));
        Future<EntityManagerFactory> future = executor.submit(callable);
        return future.get(10L, TimeUnit.MINUTES);
    }
}

