/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.snaps.core.internal.webapp.url;

import org.eclipse.virgo.snaps.core.internal.webapp.url.ImmutablePathTranslation;
import org.eclipse.virgo.snaps.core.internal.webapp.url.PathTranslation;
import org.eclipse.virgo.snaps.core.internal.webapp.url.UrlPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PathUrlPattern
implements UrlPattern {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PREFIX = "/";
    private static final String SUFFIX = "/*";
    private final String pattern;

    public PathUrlPattern(String pattern) {
        this.pattern = pattern.substring(0, pattern.length() - SUFFIX.length());
    }

    public static boolean isPathPattern(String pattern) {
        return pattern != null && pattern.startsWith(PREFIX) && pattern.endsWith(SUFFIX);
    }

    @Override
    public boolean matches(String path) {
        boolean matches;
        boolean bl = matches = path != null && path.startsWith(this.pattern);
        if (matches) {
            this.logger.info("Path '{}' matches pattern '{}'", (Object)path, (Object)this.pattern);
        } else {
            this.logger.info("Path '{}' does not match pattern '{}'", (Object)path, (Object)this.pattern);
        }
        return matches;
    }

    @Override
    public PathTranslation translate(String servletPath) {
        String pathInfo = servletPath.substring(this.pattern.length());
        this.logger.info("Translated path '{}' to '{}'", (Object)servletPath, (Object)pathInfo);
        return new ImmutablePathTranslation(this.pattern, pathInfo);
    }
}

