/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.extensions.equinox.hooks;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.BundleFileWrapperFactoryHook;

final class ExtendedBundleFileWrapperFactoryHook
implements BundleFileWrapperFactoryHook {
    ExtendedBundleFileWrapperFactoryHook() {
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object content, BaseData data, boolean base) throws IOException {
        return new FileResourceEnforcingBundleFile(bundleFile);
    }

    private static class FileResourceEnforcingBundleFile
    extends BundleFile {
        private final BundleFile bundleFile;

        private FileResourceEnforcingBundleFile(BundleFile bundleFile) {
            this.bundleFile = bundleFile;
        }

        public void close() throws IOException {
            this.bundleFile.close();
        }

        public boolean containsDir(String dir) {
            return this.bundleFile.containsDir(dir);
        }

        public BundleEntry getEntry(String path) {
            BundleEntry entry = this.bundleFile.getEntry(path);
            return entry;
        }

        public Enumeration getEntryPaths(String path) {
            Enumeration paths = this.bundleFile.getEntryPaths(path);
            return paths;
        }

        public File getFile(String path, boolean nativeCode) {
            return this.bundleFile.getFile(path, nativeCode);
        }

        public void open() throws IOException {
            this.bundleFile.open();
        }

        public File getBaseFile() {
            return this.bundleFile.getBaseFile();
        }

        public URL getResourceURL(String path, long hostBundleID, int index) {
            return this.doGetResourceURL(path);
        }

        public URL getResourceURL(String path, long hostBundleID) {
            return this.doGetResourceURL(path);
        }

        public URL getResourceURL(String path, BaseData hostData, int index) {
            return this.doGetResourceURL(path);
        }

        private URL doGetResourceURL(String path) {
            BundleEntry entry = this.getEntry(path);
            if (entry != null) {
                return this.getLocalURLForEntry(entry);
            }
            return null;
        }

        private URL getLocalURLForEntry(BundleEntry entry) {
            URL url = entry.getLocalURL();
            try {
                url.openConnection().setDefaultUseCaches(false);
                url.openConnection().setUseCaches(false);
            }
            catch (Exception exception) {}
            if (!"jar".equals(url.getProtocol()) || this.doesJarEntryReallyExist(url)) {
                return url;
            }
            return null;
        }

        private boolean doesJarEntryReallyExist(URL url) {
            boolean entryExists;
            block16: {
                entryExists = false;
                ZipFile jarFile = null;
                try {
                    try {
                        URLConnection connection = url.openConnection();
                        if (connection instanceof JarURLConnection) {
                            JarURLConnection jarURLConnection = (JarURLConnection)connection;
                            jarFile = jarURLConnection.getJarFile();
                            String entryName = jarURLConnection.getEntryName();
                            if (entryName != null && jarFile != null && ((JarFile)jarFile).getEntry(entryName) != null) {
                                entryExists = true;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        entryExists = false;
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return entryExists;
        }
    }
}

