/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.base;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategy;
import org.eclipse.viatra.dse.api.strategy.interfaces.IStrategyFactory;
import org.eclipse.viatra.dse.base.ExplorerThread;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.IDesignSpace;
import org.eclipse.viatra.dse.multithreading.DSEThreadPool;
import org.eclipse.viatra.dse.objectives.IGlobalConstraint;
import org.eclipse.viatra.dse.objectives.IObjective;
import org.eclipse.viatra.dse.objectives.LeveledObjectivesHelper;
import org.eclipse.viatra.dse.solutionstore.SolutionStore;
import org.eclipse.viatra.dse.statecode.IStateCoderFactory;
import org.eclipse.viatra.dse.util.EMFHelper;
import org.eclipse.viatra.dse.visualizer.IDesignSpaceVisualizer;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.ConflictResolvers;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class GlobalContext {
    private ConcurrentLinkedQueue<Throwable> exceptions = new ConcurrentLinkedQueue();
    private volatile ExplorationProcessState state = ExplorationProcessState.NOT_STARTED;
    private final Set<ExplorerThread> runningThreads = new HashSet<ExplorerThread>();
    private DSEThreadPool threadPool = new DSEThreadPool();
    private int numberOfStartedThreads = 0;
    private IDesignSpace designSpace;
    private AtomicBoolean firstThreadContextInited = new AtomicBoolean(false);
    private AtomicBoolean firstThreadContextIniting = new AtomicBoolean(false);
    private Map<RuleSpecification<?>, BatchTransformationRule<?, ?>> specificationRuleMap;
    private Object terminationSnycObject = new Object();
    private Logger logger = Logger.getLogger(IStrategy.class);
    private boolean isAlreadyInited;
    private List<IObjective> objectives = new ArrayList<IObjective>();
    private IObjective[][] leveledObjectives;
    private List<IGlobalConstraint> globalConstraints = new ArrayList<IGlobalConstraint>();
    private Set<BatchTransformationRule<?, ?>> transformations = new HashSet();
    private IStateCoderFactory stateCoderFactory;
    private SolutionStore solutionStore = new SolutionStore(1);
    private Object sharedObject;
    private List<IDesignSpaceVisualizer> visualizers;
    private ConflictResolver conflictResolver = ConflictResolvers.createArbitraryResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForTermination() {
        Object object = this.terminationSnycObject;
        synchronized (object) {
            while (true) {
                if (this.isDone()) {
                    return;
                }
                try {
                    this.terminationSnycObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized ExplorerThread tryStartNewThread(ThreadContext originalThreadContext, Notifier model, IStrategy strategy) {
        if (!this.isAlreadyInited) {
            this.isAlreadyInited = true;
            this.init();
        }
        if (this.state != ExplorationProcessState.COMPLETED && this.state != ExplorationProcessState.STOPPING && this.threadPool.canStartNewThread()) {
            ThreadContext newThreadContext = new ThreadContext(this, strategy, model);
            ExplorerThread explorerThread = new ExplorerThread(newThreadContext);
            newThreadContext.setExplorerThread(explorerThread);
            boolean isSuccessful = this.threadPool.tryStartNewStrategy(explorerThread);
            if (isSuccessful) {
                this.runningThreads.add(explorerThread);
                this.state = ExplorationProcessState.RUNNING;
                ++this.numberOfStartedThreads;
                this.logger.info((Object)("New thread started, active threads: " + this.runningThreads.size()));
                return explorerThread;
            }
        }
        return null;
    }

    public synchronized ExplorerThread tryStartNewThread(ThreadContext originalThreadContext, IStrategy strategy) {
        return this.tryStartNewThread(originalThreadContext, EMFHelper.clone(originalThreadContext.getModel()), strategy);
    }

    public synchronized ExplorerThread tryStartNewThreadWithoutModelClone(ThreadContext originalThreadContext, IStrategy strategy) {
        return this.tryStartNewThread(originalThreadContext, originalThreadContext.getModel(), strategy);
    }

    public synchronized ExplorerThread startFirstThread(IStrategy strategy, Notifier model) {
        Preconditions.checkState((!this.isAlreadyInited ? 1 : 0) != 0, (Object)"First thread is already started.");
        return this.tryStartNewThread(null, EMFHelper.clone(model), strategy);
    }

    public synchronized ExplorerThread startFirstThreadWithoutModelClone(IStrategy strategy, Notifier model) {
        Preconditions.checkState((!this.isAlreadyInited ? 1 : 0) != 0, (Object)"First thread is already started.");
        return this.tryStartNewThread(null, model, strategy);
    }

    public synchronized void startAllThreads(ThreadContext originalThreadContext, IStrategyFactory strategyFactory) {
        while (this.canStartNewThread()) {
            this.tryStartNewThread(originalThreadContext, strategyFactory.createStrategy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void strategyFinished(ExplorerThread strategy) {
        this.runningThreads.remove(strategy);
        this.logger.info((Object)("Thread finished, active threads: " + this.runningThreads.size()));
        if (this.runningThreads.isEmpty()) {
            this.state = ExplorationProcessState.COMPLETED;
            this.threadPool.shutdown();
            Object object = this.terminationSnycObject;
            synchronized (object) {
                this.terminationSnycObject.notify();
                this.logger.info((Object)"Exploration terminated.");
            }
        }
    }

    public synchronized boolean isDone() {
        return this.state == ExplorationProcessState.COMPLETED && this.runningThreads.isEmpty();
    }

    public synchronized boolean isNotStarted() {
        return this.state == ExplorationProcessState.NOT_STARTED;
    }

    public boolean canStartNewThread() {
        return (this.state == ExplorationProcessState.NOT_STARTED || this.state == ExplorationProcessState.RUNNING) && this.threadPool.canStartNewThread();
    }

    public synchronized void stopAllThreads() {
        if (this.state == ExplorationProcessState.RUNNING) {
            this.state = ExplorationProcessState.STOPPING;
            this.logger.info((Object)"Stopping all threads.");
            for (ExplorerThread strategy : this.runningThreads) {
                strategy.stopRunning();
            }
        }
    }

    public void registerException(Throwable e) {
        this.exceptions.add(e);
    }

    private void init() {
        this.leveledObjectives = new LeveledObjectivesHelper(this.objectives).initLeveledObjectives();
        this.specificationRuleMap = new HashMap();
        for (BatchTransformationRule<?, ?> rule : this.transformations) {
            this.specificationRuleMap.put(rule.getRuleSpecification(), rule);
        }
    }

    public List<IDesignSpaceVisualizer> getVisualizers() {
        return ImmutableList.copyOf(this.visualizers);
    }

    public void registerDesignSpaceVisualizer(IDesignSpaceVisualizer visualizer) {
        if (visualizer == null) {
            return;
        }
        if (this.visualizers == null) {
            this.visualizers = new ArrayList<IDesignSpaceVisualizer>();
        }
        this.visualizers.add(visualizer);
    }

    public void deregisterDesignSpaceVisualizer(IDesignSpaceVisualizer visualizer) {
        if (visualizer == null) {
            return;
        }
        if (this.visualizers != null) {
            this.visualizers.remove(visualizer);
        }
    }

    public boolean isDesignSpaceVisualizerRegistered(IDesignSpaceVisualizer visualizer) {
        if (this.visualizers != null) {
            return this.visualizers.contains(visualizer);
        }
        return false;
    }

    public void initVisualizersForThread(ThreadContext threadContext) {
        if (this.visualizers != null && !this.visualizers.isEmpty()) {
            for (IDesignSpaceVisualizer visualizer : this.visualizers) {
                visualizer.init(threadContext);
                threadContext.getDesignSpaceManager().registerExploreEventHandler(visualizer);
            }
        }
    }

    public boolean isExceptionHappendInOtherThread() {
        return !this.exceptions.isEmpty();
    }

    public Collection<Throwable> getExceptions() {
        return this.exceptions;
    }

    public IStateCoderFactory getStateCoderFactory() {
        return this.stateCoderFactory;
    }

    public void setStateCoderFactory(IStateCoderFactory stateCoderFactory) {
        this.stateCoderFactory = stateCoderFactory;
    }

    public Set<BatchTransformationRule<?, ?>> getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Set<BatchTransformationRule<?, ?>> transformations) {
        this.transformations = transformations;
    }

    public DSEThreadPool getThreadPool() {
        return this.threadPool;
    }

    public IDesignSpace getDesignSpace() {
        return this.designSpace;
    }

    public void setDesignSpace(IDesignSpace designSpace) {
        this.designSpace = designSpace;
    }

    public int getNumberOfStartedThreads() {
        return this.numberOfStartedThreads;
    }

    public Object getSharedObject() {
        return this.sharedObject;
    }

    public void setSharedObject(Object sharedObject) {
        this.sharedObject = sharedObject;
    }

    public ExplorationProcessState getState() {
        return this.state;
    }

    public List<IObjective> getObjectives() {
        return this.objectives;
    }

    public void setObjectives(List<IObjective> objectives) {
        this.objectives = objectives;
    }

    public List<IGlobalConstraint> getGlobalConstraints() {
        return this.globalConstraints;
    }

    public void setGlobalConstraints(List<IGlobalConstraint> globalConstraints) {
        this.globalConstraints = globalConstraints;
    }

    AtomicBoolean getFirstThreadContextInited() {
        return this.firstThreadContextInited;
    }

    AtomicBoolean getFirstThreadContextIniting() {
        return this.firstThreadContextIniting;
    }

    public IObjective[][] getLeveledObjectives() {
        return this.leveledObjectives;
    }

    public void setSolutionStore(SolutionStore solutionStore) {
        this.solutionStore = solutionStore;
    }

    public SolutionStore getSolutionStore() {
        return this.solutionStore;
    }

    public Map<RuleSpecification<?>, BatchTransformationRule<?, ?>> getSpecificationRuleMap() {
        return this.specificationRuleMap;
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    public ConflictResolver getConflictResolver() {
        return this.conflictResolver;
    }

    public static enum ExplorationProcessState {
        NOT_STARTED,
        RUNNING,
        STOPPING,
        COMPLETED;

    }
}

