/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.pcap.core.tests.trace;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEvent;
import org.eclipse.tracecompass.internal.tmf.pcap.core.trace.PcapTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.eclipse.tracecompass.tmf.pcap.core.tests.shared.PcapTmfTestTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class PcapTraceTest {
    private static final PcapTmfTestTrace TEST_TRACE = PcapTmfTestTrace.MOSTLY_TCP;
    private PcapTrace fFixture;

    @Before
    public void setUp() throws TmfTraceException {
        Assume.assumeTrue((boolean)TEST_TRACE.exists());
        this.fFixture = new PcapTrace();
        this.fFixture.initTrace(null, TEST_TRACE.getPath(), PcapEvent.class);
    }

    @After
    public void tearDown() {
        if (this.fFixture != null) {
            this.fFixture.dispose();
        }
    }

    @Test
    public void testPcapTrace() {
        PcapTrace result = new PcapTrace();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1000L, (long)result.getCacheSize());
        Assert.assertEquals((long)0L, (long)result.getNbEvents());
        Assert.assertEquals((long)0L, (long)result.getStreamingInterval());
        Assert.assertNull((Object)result.getResource());
        Assert.assertNull((Object)result.getEventType());
        result.dispose();
    }

    @Test
    public void testParseEvent() {
        ITmfContext ctx = this.fFixture.seekEvent(0L);
        this.fFixture.getNext(ctx);
        PcapEvent event = this.fFixture.parseEvent(ctx);
        Assert.assertNotNull((Object)event);
    }

    @Test
    public void testBroadcast() {
        TmfEndSynchSignal signal = new TmfEndSynchSignal(1);
        this.fFixture.broadcast((TmfSignal)signal);
    }

    @Test
    public void testGetCacheSize() {
        PcapTrace emptyFixture = new PcapTrace();
        int result = emptyFixture.getCacheSize();
        Assert.assertEquals((long)1000L, (long)result);
        emptyFixture.dispose();
    }

    @Test
    public void testGetCurrentLocation() {
        TmfLongLocation result = (TmfLongLocation)this.fFixture.getCurrentLocation();
        Assert.assertEquals((Object)new TmfLongLocation(0L), (Object)result);
    }

    @Test
    public void testSeekEventLoc_null() {
        ITmfLocation loc = null;
        this.fFixture.seekEvent(loc);
        Assert.assertNotNull((Object)this.fFixture);
    }

    @Test
    public void testSeekEventLoc_normal() {
        TmfLongLocation loc = new TmfLongLocation(3L);
        this.fFixture.seekEvent((ITmfLocation)loc);
        Assert.assertNotNull((Object)this.fFixture);
    }

    @Test
    public void testGetEndTime() {
        ITmfTimestamp result = this.fFixture.getEndTime();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetEventType() {
        Class result = this.fFixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(PcapEvent.class, (Object)result);
    }

    @Test
    public void testGetLocationRatio() {
        TmfLongLocation location = new TmfLongLocation(20L);
        double result = this.fFixture.getLocationRatio((ITmfLocation)location);
        Assert.assertEquals((double)0.46511627906976744, (double)result, (double)0.01);
    }

    @Test
    public void testGetName() {
        String result = this.fFixture.getName();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetTraceProperties() {
        int result = this.fFixture.getProperties().size();
        Assert.assertEquals((long)6L, (long)result);
    }

    @Test
    public void testGetNbEvents() {
        long result = this.fFixture.getNbEvents();
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testGetPath() {
        String result = this.fFixture.getPath();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetResource() {
        IResource result = this.fFixture.getResource();
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetStartTime() {
        ITmfTimestamp result = this.fFixture.getStartTime();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetStreamingInterval() {
        long result = this.fFixture.getStreamingInterval();
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testGetTimeRange() {
        TmfTimeRange result = this.fFixture.getTimeRange();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testSeekEvent_ratio() {
        double ratio = 0.4883720930232558;
        ITmfContext result = this.fFixture.seekEvent(ratio);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testSeekEvent_rank() {
        long rank = 1L;
        ITmfContext result = this.fFixture.seekEvent(rank);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testSeekEvent_location() {
        TmfLongLocation pcapLocation = new TmfLongLocation(10L);
        ITmfContext result = this.fFixture.seekEvent((ITmfLocation)pcapLocation);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testValidate() {
        IProject project = null;
        IStatus result = this.fFixture.validate(project, TEST_TRACE.getPath());
        Assert.assertTrue((boolean)result.isOK());
    }

    @Test
    public void getSource() {
        String a = this.fFixture.getHostId();
        Assert.assertEquals((Object)"mostlyTCP.pcap", (Object)a);
    }
}

