/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.model;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenAnalysisModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfStateValueTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace4.xml";
    private ITmfTrace fTrace;
    private DataDrivenAnalysisModule fModule;

    @Before
    public void setUp() throws TmfAnalysisException {
        DataDrivenAnalysisModule module;
        ITmfTrace trace;
        this.fTrace = trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        this.fModule = module = XmlUtilsTest.initializeModule(TmfXmlTestFiles.STATE_VALUE_FILE);
        module.setTrace(trace);
        module.schedule();
        module.waitForCompletion();
    }

    @After
    public void cleanUp() {
        DataDrivenAnalysisModule module;
        ITmfTrace trace = this.fTrace;
        if (trace != null) {
            trace.dispose();
        }
        if ((module = this.fModule) != null) {
            module.dispose();
        }
    }

    @Test
    public void testStateValueUpdate() throws AttributeNotFoundException, StateSystemDisposedException {
        DataDrivenAnalysisModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"update", "0"});
        int[] expectedStarts = new int[]{1, 3, 5, 7, 20};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"GOOD"), TmfStateValue.nullValue(), TmfStateValue.newValueString((String)"BAD"), TmfStateValue.nullValue()};
        XmlUtilsTest.verifyStateIntervals("testStateValueUpdate", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValueModify() throws AttributeNotFoundException, StateSystemDisposedException {
        DataDrivenAnalysisModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"modify", "0"});
        int[] expectedStarts = new int[]{1, 3, 5, 7, 20};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"UNKNOWN"), TmfStateValue.newValueString((String)"GOOD"), TmfStateValue.newValueString((String)"UNKNOWN"), TmfStateValue.newValueString((String)"BAD")};
        XmlUtilsTest.verifyStateIntervals("testStateValueModify", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValuePeek() throws AttributeNotFoundException, StateSystemDisposedException {
        DataDrivenAnalysisModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"stack"});
        int[] expectedStarts = new int[]{1, 2, 5, 7, 10, 20};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueLong((long)1L), TmfStateValue.newValueLong((long)2L), TmfStateValue.newValueLong((long)5L), TmfStateValue.newValueLong((long)2L), TmfStateValue.newValueLong((long)10L)};
        XmlUtilsTest.verifyStackStateIntervals("testStateValuePeek", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValueMapping() throws AttributeNotFoundException, StateSystemDisposedException {
        DataDrivenAnalysisModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"mapped"});
        int[] expectedStarts = new int[]{1, 3, 5, 7, 10, 20, 20};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"TRUE"), TmfStateValue.newValueString((String)"FALSE"), TmfStateValue.newValueString((String)"TRUE"), TmfStateValue.newValueString((String)"FALSE"), TmfStateValue.newValueString((String)"TRUE"), TmfStateValue.newValueString((String)"FALSE")};
        XmlUtilsTest.verifyStateIntervals("testMappingGroups", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValueHostId() throws AttributeNotFoundException, StateSystemDisposedException {
        DataDrivenAnalysisModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"hostID"});
        int[] expectedStarts = new int[]{1, 20};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"testTrace4.xml")};
        XmlUtilsTest.verifyStateIntervals("testHostId", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValueScript() throws AttributeNotFoundException, StateSystemDisposedException {
        DataDrivenAnalysisModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"script"});
        int[] expectedStarts = new int[]{1, 3, 5, 7, 10, 20, 20};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueString((String)"TRUE"), TmfStateValue.newValueString((String)"FALSE"), TmfStateValue.newValueString((String)"TRUE"), TmfStateValue.newValueString((String)"FALSE"), TmfStateValue.newValueString((String)"TRUE"), TmfStateValue.newValueString((String)"FALSE")};
        XmlUtilsTest.verifyStateIntervals("testStateValueScript", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testStateValueFuture() throws AttributeNotFoundException, StateSystemDisposedException {
        DataDrivenAnalysisModule module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem();
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"future"});
        int[] expectedStarts = new int[]{1, 3, 5, 7, 10, 12, 20};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueInt((int)100), TmfStateValue.newValueInt((int)101), TmfStateValue.newValueInt((int)100), TmfStateValue.newValueInt((int)101), TmfStateValue.newValueInt((int)100), TmfStateValue.newValueInt((int)101)};
        XmlUtilsTest.verifyStateIntervals("future value modification", ss, quark, expectedStarts, expectedValues);
        quark = ss.getQuarkAbsolute(new String[]{"futureStr"});
        XmlUtilsTest.verifyStateIntervals("future time as string", ss, quark, expectedStarts, expectedValues);
        quark = ss.getQuarkAbsolute(new String[]{"futureStack", "0", "1"});
        int[] expected01Starts = new int[]{1, 2, 11, 20};
        ITmfStateValue[] expected01Values = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueString((String)"op1"), TmfStateValue.nullValue()};
        XmlUtilsTest.verifyStateIntervals("future stack CPU 0, level 1", ss, quark, expected01Starts, expected01Values);
        quark = ss.getQuarkAbsolute(new String[]{"futureStack", "0", "2"});
        int[] expected02Starts = new int[]{1, 6, 7, 20};
        ITmfStateValue[] expected02Values = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueString((String)"op1"), TmfStateValue.nullValue()};
        XmlUtilsTest.verifyStateIntervals("future stack CPU 0, level 2", ss, quark, expected02Starts, expected02Values);
        quark = ss.getQuarkAbsolute(new String[]{"futureStack", "1", "1"});
        int[] expected11Starts = new int[]{1, 3, 8, 11, 16, 20};
        ITmfStateValue[] expected11Values = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueString((String)"op1"), TmfStateValue.nullValue(), TmfStateValue.newValueString((String)"op1"), TmfStateValue.nullValue()};
        XmlUtilsTest.verifyStateIntervals("future stack CPU 1, level 1", ss, quark, expected11Starts, expected11Values);
    }
}

