/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.tests.collect;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Chars;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.collect.BufferedBlockingQueue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public class BufferedBlockingQueueTest {
    @Rule
    public TestRule timeoutRule = new Timeout(2L, TimeUnit.MINUTES);
    private static final String testString = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    private BufferedBlockingQueue<Character> charQueue;

    @Before
    public void init() {
        this.charQueue = new BufferedBlockingQueue(15, 15);
    }

    public void testValidConstructor1() {
        Assert.assertNotNull((Object)new BufferedBlockingQueue(1, 1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstructor1() {
        Assert.assertNotNull((Object)new BufferedBlockingQueue(0, 0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstructor2() {
        Assert.assertNotNull((Object)new BufferedBlockingQueue(1, 0));
    }

    public void testInvalidConstructor3() {
        Assert.assertNotNull((Object)new BufferedBlockingQueue(0, 1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstructor4() {
        Assert.assertNotNull((Object)new BufferedBlockingQueue(-1, 1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstructor5() {
        Assert.assertNotNull((Object)new BufferedBlockingQueue(1, -1));
    }

    @Test
    public void testSingleInsertion() {
        Character element = Character.valueOf('x');
        this.charQueue.put((Object)element);
        this.charQueue.flushInputBuffer();
        Character out = (Character)this.charQueue.take();
        Assert.assertEquals((Object)element, (Object)out);
    }

    @Test
    public void testSimpleInsertion() {
        String string = "Hello world!";
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char elem = cArray[n2];
            this.charQueue.put((Object)Character.valueOf(elem));
            ++n2;
        }
        this.charQueue.flushInputBuffer();
        StringBuilder sb = new StringBuilder();
        while (!this.charQueue.isEmpty()) {
            sb.append(this.charQueue.take());
        }
        Assert.assertEquals((Object)string, (Object)sb.toString());
    }

    @Test
    public void testLargeInsertion() {
        String string = testString.substring(0, 222);
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char elem = cArray[n2];
            this.charQueue.put((Object)Character.valueOf(elem));
            ++n2;
        }
        this.charQueue.flushInputBuffer();
        StringBuilder sb = new StringBuilder();
        while (!this.charQueue.isEmpty()) {
            sb.append(this.charQueue.take());
        }
        Assert.assertEquals((Object)string, (Object)sb.toString());
    }

    @Test
    public void testIsEmpty() {
        BufferedBlockingQueue stringQueue = new BufferedBlockingQueue(15, 15);
        Assert.assertTrue((boolean)stringQueue.isEmpty());
        stringQueue.put((Object)"Hello");
        Assert.assertFalse((boolean)stringQueue.isEmpty());
        stringQueue.flushInputBuffer();
        Assert.assertFalse((boolean)stringQueue.isEmpty());
        stringQueue.flushInputBuffer();
        Assert.assertFalse((boolean)stringQueue.isEmpty());
        stringQueue.flushInputBuffer();
        stringQueue.take();
        Assert.assertTrue((boolean)stringQueue.isEmpty());
        stringQueue.flushInputBuffer();
        Assert.assertTrue((boolean)stringQueue.isEmpty());
    }

    @Test
    public void testOddInsertions() {
        BufferedBlockingQueue objectQueue = new BufferedBlockingQueue(15, 15);
        LinkedList<Number> expectedValues = new LinkedList<Number>();
        Random rnd = new Random();
        rnd.setSeed(123L);
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 50) {
                Integer testInt = rnd.nextInt();
                Long testLong = rnd.nextLong();
                Double testDouble = rnd.nextDouble();
                Double testGaussian = rnd.nextGaussian();
                expectedValues.add(testInt);
                expectedValues.add(testLong);
                expectedValues.add(testDouble);
                expectedValues.add(testGaussian);
                objectQueue.put((Object)testInt);
                objectQueue.put((Object)testLong);
                objectQueue.put((Object)testDouble);
                objectQueue.put((Object)testGaussian);
                ++j;
            }
            objectQueue.flushInputBuffer();
            while (!expectedValues.isEmpty()) {
                Object expected = expectedValues.removeFirst();
                Object actual = objectQueue.take();
                Assert.assertEquals(expected, (Object)actual);
            }
            ++i;
        }
    }

    @Test
    public void testMultiThread() throws InterruptedException {
        final Character lastElement = Character.valueOf('%');
        Thread producer = new Thread(){

            @Override
            public void run() {
                char[] cArray = BufferedBlockingQueueTest.testString.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    BufferedBlockingQueueTest.this.charQueue.put((Object)Character.valueOf(c));
                    ++n2;
                }
                BufferedBlockingQueueTest.this.charQueue.put((Object)lastElement);
                BufferedBlockingQueueTest.this.charQueue.flushInputBuffer();
            }
        };
        producer.start();
        Thread consumer = new Thread(){

            @Override
            public void run() {
                Character s = (Character)BufferedBlockingQueueTest.this.charQueue.take();
                while (!s.equals(lastElement)) {
                    s = (Character)BufferedBlockingQueueTest.this.charQueue.take();
                }
            }
        };
        consumer.start();
        consumer.join();
        producer.join();
    }

    @Test
    public void testBlockingPeek() throws InterruptedException {
        final Character lastElement = Character.valueOf('%');
        final StringBuilder sb = new StringBuilder();
        Thread consumer = new Thread(){

            @Override
            public void run() {
                boolean isFinished = false;
                while (!isFinished) {
                    Character s = (Character)BufferedBlockingQueueTest.this.charQueue.blockingPeek();
                    isFinished = s.equals(lastElement);
                    if (!isFinished) {
                        sb.append(s);
                    }
                    BufferedBlockingQueueTest.this.charQueue.take();
                }
            }
        };
        consumer.start();
        Thread producer = new Thread(){

            @Override
            public void run() {
                char[] cArray = BufferedBlockingQueueTest.testString.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    BufferedBlockingQueueTest.this.charQueue.put((Object)Character.valueOf(c));
                    ++n2;
                }
                BufferedBlockingQueueTest.this.charQueue.put((Object)lastElement);
                BufferedBlockingQueueTest.this.charQueue.flushInputBuffer();
            }
        };
        producer.start();
        producer.join();
        consumer.join();
        Assert.assertEquals((Object)testString, (Object)sb.toString());
    }

    @Test
    public void testIteratorContents() {
        LinkedList<Character> expected = new LinkedList<Character>();
        Assert.assertFalse((boolean)this.charQueue.iterator().hasNext());
        int i = 0;
        while (i < 50) {
            char c = testString.charAt(i);
            this.charQueue.put((Object)Character.valueOf(c));
            expected.addFirst(Character.valueOf(c));
            ++i;
        }
        LinkedList actual = new LinkedList();
        Iterators.addAll(actual, (Iterator)this.charQueue.iterator());
        BufferedBlockingQueueTest.assertSameElements(expected, actual);
        int i2 = 50;
        while (i2 < 60) {
            char c = testString.charAt(i2);
            this.charQueue.put((Object)Character.valueOf(c));
            this.charQueue.flushInputBuffer();
            expected.addFirst(Character.valueOf(c));
            ++i2;
        }
        actual = new LinkedList();
        Iterators.addAll(actual, (Iterator)this.charQueue.iterator());
        BufferedBlockingQueueTest.assertSameElements(expected, actual);
        i2 = 0;
        while (i2 < 30) {
            this.charQueue.take();
            expected.removeLast();
            ++i2;
        }
        actual = new LinkedList();
        Iterators.addAll(actual, (Iterator)this.charQueue.iterator());
        BufferedBlockingQueueTest.assertSameElements(expected, actual);
        while (!this.charQueue.isEmpty()) {
            this.charQueue.take();
            expected.removeLast();
        }
        Assert.assertFalse((boolean)this.charQueue.iterator().hasNext());
    }

    private static <T> void assertSameElements(Collection<T> c1, Collection<T> c2) {
        Assert.assertEquals((Object)HashMultiset.create(c1), (Object)HashMultiset.create(c2));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testConcurrentIteration() {
        @NonNull BufferedBlockingQueue queue = new BufferedBlockingQueue(15, 15);
        String poisonPill = "That's all folks!";
        List<@NonNull T> strings = Chars.asList((char[])testString.toCharArray()).stream().map(Object::toString).collect(Collectors.toList());
        Iterable<Iterable<String>> results = BufferedBlockingQueueTest.runConcurrencyTest(queue, strings, "That's all folks!", 1, 1, 1);
        Assert.assertEquals(strings, (Object)Iterables.getOnlyElement(results));
    }

    private static <T> Iterable<Iterable<T>> runConcurrencyTest(BufferedBlockingQueue<@NonNull T> queue, List<@NonNull T> testBuffer, @NonNull T poisonPill, int nbProducerThreads, int nbConsumerThreads, int nbObserverThreads) {
        if (nbProducerThreads < 1 || nbConsumerThreads < 1 || nbObserverThreads < 0) {
            throw new IllegalArgumentException();
        }
        ExecutorService pool = Executors.newFixedThreadPool(nbProducerThreads + nbConsumerThreads + nbObserverThreads);
        LinkedList consumedElements = new LinkedList();
        int i = 0;
        while (i < nbProducerThreads) {
            final class ProducerThread
            implements Runnable {
                private final /* synthetic */ List val$testBuffer;
                private final /* synthetic */ BufferedBlockingQueue val$queue;
                private final /* synthetic */ Object val$poisonPill;

                ProducerThread(List list, BufferedBlockingQueue bufferedBlockingQueue, Object object) {
                    this.val$testBuffer = list;
                    this.val$queue = bufferedBlockingQueue;
                    this.val$poisonPill = object;
                }

                @Override
                public void run() {
                    int i = 0;
                    while (i < this.val$testBuffer.size()) {
                        Object elem = this.val$testBuffer.get(i);
                        this.val$queue.put(elem);
                        ++i;
                    }
                    this.val$queue.put(this.val$poisonPill);
                    this.val$queue.flushInputBuffer();
                }
            }
            pool.submit(new ProducerThread(testBuffer, queue, poisonPill));
            ++i;
        }
        i = 0;
        while (i < nbConsumerThreads) {
            final class ConsumerThread
            implements Callable<Iterable<T>> {
                private final /* synthetic */ BufferedBlockingQueue val$queue;
                private final /* synthetic */ Object val$poisonPill;

                ConsumerThread(BufferedBlockingQueue bufferedBlockingQueue, Object object) {
                    this.val$queue = bufferedBlockingQueue;
                    this.val$poisonPill = object;
                }

                @Override
                public Iterable<T> call() {
                    LinkedList<Object> results = new LinkedList<Object>();
                    Object elem = this.val$queue.take();
                    while (!elem.equals(this.val$poisonPill)) {
                        results.add(elem);
                        elem = this.val$queue.take();
                    }
                    return results;
                }
            }
            consumedElements.add(pool.submit(new ConsumerThread(queue, poisonPill)));
            ++i;
        }
        i = 0;
        while (i < nbObserverThreads) {
            final class ObserverThread
            implements Runnable {
                private final /* synthetic */ BufferedBlockingQueue val$queue;

                ObserverThread(BufferedBlockingQueue bufferedBlockingQueue) {
                    this.val$queue = bufferedBlockingQueue;
                }

                @Override
                public void run() {
                    int i = 0;
                    while (i < 5) {
                        HashSet results = new HashSet();
                        for (Object input : this.val$queue) {
                            results.add(input);
                        }
                        ++i;
                    }
                }
            }
            pool.submit(new ObserverThread(queue));
            ++i;
        }
        LinkedList<Iterable<T>> results = new LinkedList<Iterable<T>>();
        try {
            for (Future future : consumedElements) {
                Iterable threadResult = (Iterable)future.get();
                results.add(threadResult);
            }
            pool.shutdown();
            boolean bl = pool.awaitTermination(2L, TimeUnit.MINUTES);
            if (!bl) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            Assert.fail((String)exception.getMessage());
        }
        return results;
    }
}

