/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.analysis.criticalpath;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphBuilder;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphFactory;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.GraphOps;
import org.junit.Assert;
import org.junit.Test;

public abstract class TmfCriticalPathAlgorithmTest {
    protected abstract ITmfGraph computeCriticalPath(ITmfGraph var1, @NonNull ITmfVertex var2);

    protected abstract ITmfGraph getExpectedCriticalPath(GraphBuilder var1);

    private void testCriticalPath(GraphBuilder builder, @NonNull IGraphWorker obj) {
        ITmfGraph main = builder.build();
        Assert.assertNotNull((Object)main);
        ITmfGraph expected = this.getExpectedCriticalPath(builder);
        Assert.assertNotNull((Object)expected);
        ITmfVertex head = main.getHead(obj);
        ITmfGraph actual = this.computeCriticalPath(main, head);
        Assert.assertNotNull((Object)actual);
        GraphOps.checkEquality(expected, actual);
    }

    @Test
    public void testCriticalPathBasic() {
        this.testCriticalPath(GraphFactory.GRAPH_BASIC, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupSelf() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_SELF, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupNew() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_NEW, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupUnknown() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_UNKNOWN, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupMutual() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_MUTUAL, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupNested() {
        this.testCriticalPath(GraphFactory.GRAPH_NESTED, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupOpened() {
        this.testCriticalPath(GraphFactory.GRAPH_OPENED, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupOpenedDelay() {
        this.testCriticalPath(GraphFactory.GRAPH_OPENED_DELAY, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupMissing() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_MISSING, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupEmbedded() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_EMBEDDED, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupInterleave() {
        this.testCriticalPath(GraphFactory.GRAPH_WAKEUP_INTERLEAVE, GraphFactory.Actor0);
    }

    @Test
    public void testCriticalPathWakeupNet1() {
        this.testCriticalPath(GraphFactory.GRAPH_NET1, GraphFactory.Actor0);
    }
}

