/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event.matching;

import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventDependency;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.event.TmfEventTypeStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfEventMatchingTest {
    private static final @NonNull IProgressMonitor PROGRESS_MONITOR = new NullProgressMonitor();
    private TmfTraceStub fT1;
    private TmfTraceStub fT2;
    private @NonNull Collection<@NonNull ITmfTrace> fTraces = Collections.emptyList();

    @Before
    public void init() {
        TmfTraceStub t1 = new TmfTraceStub();
        t1.init("t1");
        TmfTraceStub t2 = new TmfTraceStub();
        t2.init("t2");
        LinkedList<@NonNull ITmfTrace> traces = new LinkedList<ITmfTrace>();
        traces.add((ITmfTrace)t1);
        traces.add((ITmfTrace)t2);
        this.fT1 = t1;
        this.fT2 = t2;
        this.fTraces = traces;
        TmfEventMatching.registerMatchObject((ITmfMatchEventDefinition)new StubEventMatching());
    }

    @After
    public void cleanup() {
        TmfTraceStub trace = this.fT1;
        if (trace != null) {
            trace.dispose();
        }
        if ((trace = this.fT2) != null) {
            trace.dispose();
        }
    }

    @Test
    public void testHostToSelf() {
        int count = 1;
        int matchedKey1 = count++;
        int unmatchedKey = count++;
        int matchedKey3 = count++;
        Collection<@NonNull ITmfTrace> traces = this.fTraces;
        Assert.assertNotNull(traces);
        TmfEventMatchingStub matching = new TmfEventMatchingStub(traces);
        matching.initMatching();
        TmfTraceStub trace = this.fT1;
        Assert.assertNotNull((Object)((Object)trace));
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)trace, TmfTimestamp.fromNanos((long)1L), matchedKey1, TmfEventMatching.Direction.CAUSE), (ITmfTrace)trace, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)trace).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)trace, TmfTimestamp.fromNanos((long)3L), matchedKey1, TmfEventMatching.Direction.EFFECT), (ITmfTrace)trace, PROGRESS_MONITOR);
        Assert.assertEquals((long)0L, (long)matching.getUnmatchedOut().row((Object)trace).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)trace, TmfTimestamp.fromNanos((long)5L), unmatchedKey, TmfEventMatching.Direction.EFFECT), (ITmfTrace)trace, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedIn().row((Object)trace).size());
        Assert.assertEquals((long)0L, (long)matching.getUnmatchedOut().row((Object)trace).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)trace, TmfTimestamp.fromNanos((long)7L), matchedKey3, TmfEventMatching.Direction.CAUSE), (ITmfTrace)trace, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedIn().row((Object)trace).size());
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)trace).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)trace, TmfTimestamp.fromNanos((long)7L), matchedKey3, TmfEventMatching.Direction.EFFECT), (ITmfTrace)trace, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedIn().row((Object)trace).size());
        Assert.assertEquals((long)0L, (long)matching.getUnmatchedOut().row((Object)trace).size());
    }

    @Test
    public void testMultiHost() {
        int count = 1;
        int matchedKey1 = count++;
        int unmatchedKey1 = count++;
        int unmatchedKey2 = count++;
        int unmatchedKey3 = count++;
        int unmatchedKey4 = count++;
        int matchedKey2 = count++;
        Collection<@NonNull ITmfTrace> traces = this.fTraces;
        Assert.assertNotNull(traces);
        TmfEventMatchingStub matching = new TmfEventMatchingStub(traces);
        matching.initMatching();
        TmfTraceStub t1 = this.fT1;
        Assert.assertNotNull((Object)((Object)t1));
        TmfTraceStub t2 = this.fT2;
        Assert.assertNotNull((Object)((Object)t2));
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)1L), unmatchedKey1, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)3L), unmatchedKey2, TmfEventMatching.Direction.EFFECT), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)5L), unmatchedKey3, TmfEventMatching.Direction.EFFECT), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)2L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)7L), matchedKey1, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)2L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)2L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)11L), matchedKey2, TmfEventMatching.Direction.EFFECT), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)2L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)13L), unmatchedKey4, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t2, TmfTimestamp.fromNanos((long)20L), matchedKey1, TmfEventMatching.Direction.EFFECT), (ITmfTrace)t2, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t2, TmfTimestamp.fromNanos((long)21L), matchedKey2, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t2, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)0L, (long)matching.getUnmatchedIn().row((Object)t1).size());
    }

    @Test
    public void testMultiHostMultiKeyType() {
        int count = 1;
        int matchedKey1 = count++;
        int unmatchedKey1 = count++;
        int unmatchedKey2 = count++;
        int unmatchedKey3 = count++;
        int unmatchedKey4 = count++;
        int unmatchedStringKey1 = -count++;
        int matchedStringKey1 = -count++;
        int matchedKey2 = count++;
        Collection<@NonNull ITmfTrace> traces = this.fTraces;
        Assert.assertNotNull(traces);
        TmfEventMatchingStub matching = new TmfEventMatchingStub(traces);
        matching.initMatching();
        TmfTraceStub t1 = this.fT1;
        Assert.assertNotNull((Object)((Object)t1));
        TmfTraceStub t2 = this.fT2;
        Assert.assertNotNull((Object)((Object)t2));
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)1L), unmatchedKey1, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)3L), unmatchedKey2, TmfEventMatching.Direction.EFFECT), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)5L), unmatchedKey3, TmfEventMatching.Direction.EFFECT), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)2L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)6L), unmatchedStringKey1, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)2L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)2L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)7L), matchedKey1, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)2L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)11L), matchedKey2, TmfEventMatching.Direction.EFFECT), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)13L), unmatchedKey4, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)4L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t1, TmfTimestamp.fromNanos((long)15L), matchedStringKey1, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t1, PROGRESS_MONITOR);
        Assert.assertEquals((long)5L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t2, TmfTimestamp.fromNanos((long)20L), matchedKey1, TmfEventMatching.Direction.EFFECT), (ITmfTrace)t2, PROGRESS_MONITOR);
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t2, TmfTimestamp.fromNanos((long)21L), matchedKey2, TmfEventMatching.Direction.CAUSE), (ITmfTrace)t2, PROGRESS_MONITOR);
        Assert.assertEquals((long)3L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)0L, (long)matching.getUnmatchedIn().row((Object)t1).size());
        matching.matchEvent((ITmfEvent)new MatchEventStub((ITmfTrace)t2, TmfTimestamp.fromNanos((long)22L), matchedStringKey1, TmfEventMatching.Direction.EFFECT), (ITmfTrace)t2, PROGRESS_MONITOR);
        Assert.assertEquals((long)1L, (long)matching.getUnmatchedOut().row((Object)t1).size());
        Assert.assertEquals((long)0L, (long)matching.getUnmatchedIn().row((Object)t1).size());
    }

    private static class IntMatchingKey
    implements IEventMatchingKey {
        private final @NonNull Integer fId;

        public IntMatchingKey(@NonNull Integer id) {
            this.fId = id;
        }

        public int hashCode() {
            return this.fId.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof IntMatchingKey) {
                IntMatchingKey key = (IntMatchingKey)o;
                return key.fId.equals(this.fId);
            }
            return false;
        }
    }

    private static class MatchEventStub
    extends TmfEvent {
        private final int fId;
        private final TmfEventMatching.Direction fDirection;

        public MatchEventStub(ITmfTrace trace, ITmfTimestamp timestamp, int id, TmfEventMatching.Direction direction) {
            super(trace, -1L, timestamp, (ITmfEventType)new TmfEventTypeStub(), (ITmfEventField)new TmfEventField("stub", (Object)"stub", null));
            this.fId = id;
            this.fDirection = direction;
        }
    }

    private static class StringMatchingKey
    implements IEventMatchingKey {
        private final @NonNull String fStr;

        public StringMatchingKey(@NonNull String id) {
            this.fStr = id;
        }

        public int hashCode() {
            return this.fStr.hashCode();
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof StringMatchingKey) {
                StringMatchingKey key = (StringMatchingKey)o;
                return key.fStr.equals(this.fStr);
            }
            return false;
        }
    }

    private static class StubEventMatching
    implements ITmfMatchEventDefinition {
        private StubEventMatching() {
        }

        public IEventMatchingKey getEventKey(ITmfEvent event) {
            if (!(event instanceof MatchEventStub)) {
                return null;
            }
            int id = ((MatchEventStub)event).fId;
            if (id < 0) {
                return new StringMatchingKey(String.valueOf(id));
            }
            return new IntMatchingKey(id);
        }

        public boolean canMatchTrace(ITmfTrace trace) {
            return true;
        }

        public TmfEventMatching.Direction getDirection(ITmfEvent event) {
            if (!(event instanceof MatchEventStub)) {
                return null;
            }
            return ((MatchEventStub)event).fDirection;
        }
    }

    private static class TmfEventMatchingStub
    extends TmfEventMatching {
        public TmfEventMatchingStub(Collection<@NonNull ITmfTrace> traces) {
            super(traces);
        }

        public Table<ITmfTrace, IEventMatchingKey, TmfEventDependency.DependencyEvent> getUnmatchedIn() {
            return super.getUnmatchedIn();
        }

        public Table<ITmfTrace, IEventMatchingKey, TmfEventDependency.DependencyEvent> getUnmatchedOut() {
            return super.getUnmatchedOut();
        }
    }
}

