/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import java.util.LinkedList;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IChannelInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.DomainInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DomainInfoTest {
    private IDomainInfo fDomainInfo1 = null;
    private IDomainInfo fDomainInfo2 = null;
    private IChannelInfo fChannelInfo1 = null;
    private IChannelInfo fChannelInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fChannelInfo1 = factory.getChannel1();
        this.fChannelInfo2 = factory.getChannel2();
        this.fDomainInfo1 = factory.getDomainInfo1();
        this.fDomainInfo2 = factory.getDomainInfo2();
    }

    @Test
    public void testDomainInfo() {
        DomainInfo result = new DomainInfo("test");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test", (Object)result.getName());
        Assert.assertEquals((long)0L, (long)result.getChannels().length);
    }

    @Test
    public void testDomainInfoCopy() {
        DomainInfo channelInfo = new DomainInfo((DomainInfo)this.fDomainInfo1);
        IChannelInfo[] orignalEvents = this.fDomainInfo1.getChannels();
        IChannelInfo[] resultEvents = channelInfo.getChannels();
        int i = 0;
        while (i < orignalEvents.length) {
            Assert.assertEquals((Object)orignalEvents[i], (Object)resultEvents[i]);
            ++i;
        }
    }

    @Test
    public void testDomainlCopy2() {
        try {
            DomainInfo domain = null;
            new DomainInfo(domain);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAndSetters() {
        Assert.assertEquals((long)1L, (long)this.fDomainInfo1.getChannels().length);
        Assert.assertNotNull((Object)this.fDomainInfo1.getChannels()[0]);
        Assert.assertEquals((Object)this.fChannelInfo1, (Object)this.fDomainInfo1.getChannels()[0]);
        DomainInfo domain = new DomainInfo("domain");
        LinkedList<IChannelInfo> list = new LinkedList<IChannelInfo>();
        list.add(this.fChannelInfo1);
        list.add(this.fChannelInfo2);
        domain.setChannels(list);
        IChannelInfo[] result = domain.getChannels();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)this.fChannelInfo1, (Object)result[0]);
        Assert.assertEquals((Object)this.fChannelInfo2, (Object)result[1]);
    }

    @Test
    public void testToString_1() {
        DomainInfo fixture = new DomainInfo("domain");
        String result = fixture.toString();
        Assert.assertEquals((Object)"[DomainInfo([TraceInfo(Name=domain)],Channels=None,Loggers=None,isKernel=false)]", (Object)result);
    }

    @Test
    public void testToString_2() {
        String result = this.fDomainInfo1.toString();
        Assert.assertEquals((Object)"[DomainInfo([TraceInfo(Name=test1)],Channels=[ChannelInfo([TraceInfo(Name=channel1)],State=DISABLED,OverwriteMode=true,SubBuffersSize=13,NumberOfSubBuffers=12,SwitchTimer=10,ReadTimer=11,output=splice(),NumberOfDiscardedEvents=14,NumberOfLostPackets=15,Events=[EventInfo([BaseEventInfo([TraceInfo(Name=event1)],type=TRACEPOINT,level=TRACE_DEBUG)],State=ENABLED,levelType=LOGLEVEL_ONLY)])],Loggers=None,isKernel=false)]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fDomainInfo1.equals(this.fDomainInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fDomainInfo2.equals(this.fDomainInfo2));
        Assert.assertTrue((String)"equals", (!this.fDomainInfo1.equals(this.fDomainInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fDomainInfo2.equals(this.fDomainInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        DomainInfo event1 = new DomainInfo((DomainInfo)this.fDomainInfo1);
        DomainInfo event2 = new DomainInfo((DomainInfo)this.fDomainInfo2);
        Assert.assertTrue((String)"equals", (boolean)event1.equals((Object)this.fDomainInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fDomainInfo1.equals(event1));
        Assert.assertTrue((String)"equals", (boolean)event2.equals((Object)this.fDomainInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fDomainInfo2.equals(event2));
    }

    @Test
    public void testEqualsTransivity() {
        DomainInfo channel1 = new DomainInfo((DomainInfo)this.fDomainInfo1);
        DomainInfo channel2 = new DomainInfo((DomainInfo)this.fDomainInfo1);
        DomainInfo channel3 = new DomainInfo((DomainInfo)this.fDomainInfo1);
        Assert.assertTrue((String)"equals", (boolean)channel1.equals((Object)channel2));
        Assert.assertTrue((String)"equals", (boolean)channel2.equals((Object)channel3));
        Assert.assertTrue((String)"equals", (boolean)channel1.equals((Object)channel3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fDomainInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fDomainInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        DomainInfo channel1 = new DomainInfo((DomainInfo)this.fDomainInfo1);
        DomainInfo channel2 = new DomainInfo((DomainInfo)this.fDomainInfo2);
        Assert.assertTrue((String)"hashCode", (this.fDomainInfo1.hashCode() == channel1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fDomainInfo2.hashCode() == channel2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fDomainInfo1.hashCode() != channel2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fDomainInfo2.hashCode() != channel1.hashCode() ? 1 : 0) != 0);
    }
}

